"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("../../aws-events"); // Automatically re-written from '@aws-cdk/aws-events'
const targets = require("../../aws-events-targets"); // Automatically re-written from '@aws-cdk/aws-events-targets'
const event_bridge_1 = require("./event-bridge");
/**
 * (experimental) Use a Lambda function as a Lambda destination.
 *
 * @experimental
 */
class LambdaDestination {
    /**
     * @experimental
     */
    constructor(fn, options = {}) {
        this.fn = fn;
        this.options = options;
    }
    /**
     * (experimental) Returns a destination configuration.
     *
     * @experimental
     */
    bind(scope, fn, options) {
        // Normal Lambda destination (full invocation record)
        if (!this.options.responseOnly) {
            // deduplicated automatically
            this.fn.grantInvoke(fn);
            return {
                destination: this.fn.functionArn,
            };
        }
        // Otherwise add rule to extract the response payload and use EventBridge
        // as destination
        if (!options) { // `options` added to bind() as optionnal to avoid breaking change
            throw new Error('Options must be defined when using `responseOnly`.');
        }
        // Match invocation result of the source function (`fn`) and use it
        // to trigger the destination function (`this.fn`).
        new events.Rule(scope, options.type, {
            eventPattern: {
                detailType: [`Lambda Function Invocation Result - ${options.type}`],
                resources: [`${fn.functionArn}:$LATEST`],
                source: ['lambda'],
            },
            targets: [
                new targets.LambdaFunction(this.fn, {
                    event: events.RuleTargetInput.fromEventPath('$.detail.responsePayload'),
                }),
            ],
        });
        const destination = new event_bridge_1.EventBridgeDestination(); // Use default event bus here
        return destination.bind(scope, fn);
    }
}
exports.LambdaDestination = LambdaDestination;
_a = JSII_RTTI_SYMBOL_1;
LambdaDestination[_a] = { fqn: "monocdk.aws_lambda_destinations.LambdaDestination", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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