"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventBridgeDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const events = require("../../aws-events"); // Automatically re-written from '@aws-cdk/aws-events'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * (experimental) Use an Event Bridge event bus as a Lambda destination.
 *
 * If no event bus is specified, the default event bus is used.
 *
 * @experimental
 */
class EventBridgeDestination {
    /**
     * @default - use the default event bus
     * @experimental
     */
    constructor(eventBus) {
        this.eventBus = eventBus;
    }
    /**
     * (experimental) Returns a destination configuration.
     *
     * @experimental
     */
    bind(_scope, fn, _options) {
        if (this.eventBus) {
            this.eventBus.grantPutEventsTo(fn);
            return {
                destination: this.eventBus.eventBusArn,
            };
        }
        const existingDefaultEventBus = _scope.node.tryFindChild('DefaultEventBus');
        let eventBus = existingDefaultEventBus || events.EventBus.fromEventBusArn(_scope, 'DefaultEventBus', core_1.Stack.of(fn).formatArn({
            service: 'events',
            resource: 'event-bus',
            resourceName: 'default',
        }));
        eventBus.grantPutEventsTo(fn);
        return {
            destination: eventBus.eventBusArn,
        };
    }
}
exports.EventBridgeDestination = EventBridgeDestination;
_a = JSII_RTTI_SYMBOL_1;
EventBridgeDestination[_a] = { fqn: "monocdk.aws_lambda_destinations.EventBridgeDestination", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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