"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ViaServicePrincipal = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
/**
 * (experimental) A principal to allow access to a key if it's being used through another AWS service.
 *
 * @experimental
 */
class ViaServicePrincipal extends iam.PrincipalBase {
    /**
     * @experimental
     */
    constructor(serviceName, basePrincipal) {
        super();
        this.serviceName = serviceName;
        this.basePrincipal = basePrincipal ? basePrincipal : new iam.AnyPrincipal();
    }
    /**
     * (experimental) Return the policy fragment that identifies this principal in a Policy.
     *
     * @experimental
     */
    get policyFragment() {
        // Make a copy of the base policyFragment to add a condition to it
        const base = this.basePrincipal.policyFragment;
        const conditions = Object.assign({}, base.conditions);
        if (conditions.StringEquals) {
            conditions.StringEquals = Object.assign({ 'kms:ViaService': this.serviceName }, conditions.StringEquals);
        }
        else {
            conditions.StringEquals = { 'kms:ViaService': this.serviceName };
        }
        return { principalJson: base.principalJson, conditions };
    }
}
exports.ViaServicePrincipal = ViaServicePrincipal;
_a = JSII_RTTI_SYMBOL_1;
ViaServicePrincipal[_a] = { fqn: "monocdk.aws_kms.ViaServicePrincipal", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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