import * as iam from "../../aws-iam";
import { IResource, RemovalPolicy, Resource, Duration } from "../../core";
import { Construct } from 'constructs';
import { Alias } from './alias';
/**
 * (experimental) A KMS Key, either managed by this CDK app, or imported.
 *
 * @experimental
 */
export interface IKey extends IResource {
    /**
     * (experimental) The ARN of the key.
     *
     * @experimental
     * @attribute true
     */
    readonly keyArn: string;
    /**
     * (experimental) The ID of the key (the part that looks something like: 1234abcd-12ab-34cd-56ef-1234567890ab).
     *
     * @experimental
     * @attribute true
     */
    readonly keyId: string;
    /**
     * (experimental) Defines a new alias for the key.
     *
     * @experimental
     */
    addAlias(alias: string): Alias;
    /**
     * (experimental) Adds a statement to the KMS key resource policy.
     *
     * @param statement The policy statement to add.
     * @param allowNoOp If this is set to `false` and there is no policy defined (i.e. external key), the operation will fail. Otherwise, it will no-op.
     * @experimental
     */
    addToResourcePolicy(statement: iam.PolicyStatement, allowNoOp?: boolean): iam.AddToResourcePolicyResult;
    /**
     * (experimental) Grant the indicated permissions on this key to the given principal.
     *
     * @experimental
     */
    grant(grantee: iam.IGrantable, ...actions: string[]): iam.Grant;
    /**
     * (experimental) Grant decryption permissions using this key to the given principal.
     *
     * @experimental
     */
    grantDecrypt(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant encryption permissions using this key to the given principal.
     *
     * @experimental
     */
    grantEncrypt(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant encryption and decryption permissions using this key to the given principal.
     *
     * @experimental
     */
    grantEncryptDecrypt(grantee: iam.IGrantable): iam.Grant;
}
declare abstract class KeyBase extends Resource implements IKey {
    /**
     * The ARN of the key.
     */
    abstract readonly keyArn: string;
    abstract readonly keyId: string;
    /**
     * Optional policy document that represents the resource policy of this key.
     *
     * If specified, addToResourcePolicy can be used to edit this policy.
     * Otherwise this method will no-op.
     */
    protected abstract readonly policy?: iam.PolicyDocument;
    /**
     * Optional property to control trusting account identities.
     *
     * If specified, grants will default identity policies instead of to both
     * resource and identity policies. This matches the default behavior when creating
     * KMS keys via the API or console.
     */
    protected abstract readonly trustAccountIdentities: boolean;
    /**
     * Collection of aliases added to the key
     *
     * Tracked to determine whether or not the aliasName should be added to the end of its ID
     */
    private readonly aliases;
    /**
     * (experimental) Defines a new alias for the key.
     *
     * @experimental
     */
    addAlias(aliasName: string): Alias;
    /**
     * (experimental) Adds a statement to the KMS key resource policy.
     *
     * @param statement The policy statement to add.
     * @param allowNoOp If this is set to `false` and there is no policy defined (i.e. external key), the operation will fail. Otherwise, it will no-op.
     * @experimental
     */
    addToResourcePolicy(statement: iam.PolicyStatement, allowNoOp?: boolean): iam.AddToResourcePolicyResult;
    /**
     * (experimental) Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     *
     * @experimental
     */
    protected validate(): string[];
    /**
     * (experimental) Grant the indicated permissions on this key to the given principal.
     *
     * This modifies both the principal's policy as well as the resource policy,
     * since the default CloudFormation setup for KMS keys is that the policy
     * must not be empty and so default grants won't work.
     *
     * @experimental
     */
    grant(grantee: iam.IGrantable, ...actions: string[]): iam.Grant;
    /**
     * (experimental) Grant decryption permissions using this key to the given principal.
     *
     * @experimental
     */
    grantDecrypt(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant encryption permissions using this key to the given principal.
     *
     * @experimental
     */
    grantEncrypt(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant encryption and decryption permissions using this key to the given principal.
     *
     * @experimental
     */
    grantEncryptDecrypt(grantee: iam.IGrantable): iam.Grant;
    /**
     * Checks whether the grantee belongs to a stack that will be deployed
     * after the stack containing this key.
     *
     * @param grantee the grantee to give permissions to
     * @returns the account ID of the grantee stack if its stack does depend on this stack,
     *   undefined otherwise
     */
    private granteeStackDependsOnKeyStack;
    private principalIsANewlyCreatedResource;
    private isGranteeFromAnotherRegion;
    private isGranteeFromAnotherAccount;
}
/**
 * (experimental) The key spec, represents the cryptographic configuration of keys.
 *
 * @experimental
 */
export declare enum KeySpec {
    /**
     * (experimental) The default key spec.
     *
     * Valid usage: ENCRYPT_DECRYPT
     *
     * @experimental
     */
    SYMMETRIC_DEFAULT = "SYMMETRIC_DEFAULT",
    /**
     * (experimental) RSA with 2048 bits of key.
     *
     * Valid usage: ENCRYPT_DECRYPT and SIGN_VERIFY
     *
     * @experimental
     */
    RSA_2048 = "RSA_2048",
    /**
     * (experimental) RSA with 3072 bits of key.
     *
     * Valid usage: ENCRYPT_DECRYPT and SIGN_VERIFY
     *
     * @experimental
     */
    RSA_3072 = "RSA_3072",
    /**
     * (experimental) RSA with 4096 bits of key.
     *
     * Valid usage: ENCRYPT_DECRYPT and SIGN_VERIFY
     *
     * @experimental
     */
    RSA_4096 = "RSA_4096",
    /**
     * (experimental) NIST FIPS 186-4, Section 6.4, ECDSA signature using the curve specified by the key and SHA-256 for the message digest.
     *
     * Valid usage: SIGN_VERIFY
     *
     * @experimental
     */
    ECC_NIST_P256 = "ECC_NIST_P256",
    /**
     * (experimental) NIST FIPS 186-4, Section 6.4, ECDSA signature using the curve specified by the key and SHA-384 for the message digest.
     *
     * Valid usage: SIGN_VERIFY
     *
     * @experimental
     */
    ECC_NIST_P384 = "ECC_NIST_P384",
    /**
     * (experimental) NIST FIPS 186-4, Section 6.4, ECDSA signature using the curve specified by the key and SHA-512 for the message digest.
     *
     * Valid usage: SIGN_VERIFY
     *
     * @experimental
     */
    ECC_NIST_P521 = "ECC_NIST_P521",
    /**
     * (experimental) Standards for Efficient Cryptography 2, Section 2.4.1, ECDSA signature on the Koblitz curve.
     *
     * Valid usage: SIGN_VERIFY
     *
     * @experimental
     */
    ECC_SECG_P256K1 = "ECC_SECG_P256K1"
}
/**
 * (experimental) The key usage, represents the cryptographic operations of keys.
 *
 * @experimental
 */
export declare enum KeyUsage {
    /**
     * (experimental) Encryption and decryption.
     *
     * @experimental
     */
    ENCRYPT_DECRYPT = "ENCRYPT_DECRYPT",
    /**
     * (experimental) Signing and verification.
     *
     * @experimental
     */
    SIGN_VERIFY = "SIGN_VERIFY"
}
/**
 * (experimental) Construction properties for a KMS Key object.
 *
 * @experimental
 */
export interface KeyProps {
    /**
     * (experimental) A description of the key.
     *
     * Use a description that helps your users decide
     * whether the key is appropriate for a particular task.
     *
     * @default - No description.
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) Initial alias to add to the key.
     *
     * More aliases can be added later by calling `addAlias`.
     *
     * @default - No alias is added for the key.
     * @experimental
     */
    readonly alias?: string;
    /**
     * (experimental) Indicates whether AWS KMS rotates the key.
     *
     * @default false
     * @experimental
     */
    readonly enableKeyRotation?: boolean;
    /**
     * (experimental) Indicates whether the key is available for use.
     *
     * @default - Key is enabled.
     * @experimental
     */
    readonly enabled?: boolean;
    /**
     * (experimental) The cryptographic configuration of the key. The valid value depends on usage of the key.
     *
     * IMPORTANT: If you change this property of an existing key, the existing key is scheduled for deletion
     * and a new key is created with the specified value.
     *
     * @default KeySpec.SYMMETRIC_DEFAULT
     * @experimental
     */
    readonly keySpec?: KeySpec;
    /**
     * (experimental) The cryptographic operations for which the key can be used.
     *
     * IMPORTANT: If you change this property of an existing key, the existing key is scheduled for deletion
     * and a new key is created with the specified value.
     *
     * @default KeyUsage.ENCRYPT_DECRYPT
     * @experimental
     */
    readonly keyUsage?: KeyUsage;
    /**
     * (experimental) Custom policy document to attach to the KMS key.
     *
     * NOTE - If the `@aws-cdk/aws-kms:defaultKeyPolicies` feature flag is set (the default for new projects),
     * this policy will *override* the default key policy and become the only key policy for the key. If the
     * feature flag is not set, this policy will be appended to the default key policy.
     *
     * @default - A policy document with permissions for the account root to
     * administer the key will be created.
     * @experimental
     */
    readonly policy?: iam.PolicyDocument;
    /**
     * (experimental) A list of principals to add as key administrators to the key policy.
     *
     * Key administrators have permissions to manage the key (e.g., change permissions, revoke), but do not have permissions
     * to use the key in cryptographic operations (e.g., encrypt, decrypt).
     *
     * These principals will be added to the default key policy (if none specified), or to the specified policy (if provided).
     *
     * @default []
     * @experimental
     */
    readonly admins?: iam.IPrincipal[];
    /**
     * (experimental) Whether the encryption key should be retained when it is removed from the Stack.
     *
     * This is useful when one wants to
     * retain access to data that was encrypted with a key that is being retired.
     *
     * @default RemovalPolicy.Retain
     * @experimental
     */
    readonly removalPolicy?: RemovalPolicy;
    /**
     * (deprecated) Whether the key usage can be granted by IAM policies.
     *
     * Setting this to true adds a default statement which delegates key
     * access control completely to the identity's IAM policy (similar
     * to how it works for other AWS resources). This matches the default behavior
     * when creating KMS keys via the API or console.
     *
     * If the `@aws-cdk/aws-kms:defaultKeyPolicies` feature flag is set (the default for new projects),
     * this flag will always be treated as 'true' and does not need to be explicitly set.
     *
     * @default - false, unless the `@aws-cdk/aws-kms:defaultKeyPolicies` feature flag is set.
     * @see https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam
     * @deprecated redundant with the `@aws-cdk/aws-kms:defaultKeyPolicies` feature flag
     */
    readonly trustAccountIdentities?: boolean;
    /**
     * (experimental) Specifies the number of days in the waiting period before AWS KMS deletes a CMK that has been removed from a CloudFormation stack.
     *
     * When you remove a customer master key (CMK) from a CloudFormation stack, AWS KMS schedules the CMK for deletion
     * and starts the mandatory waiting period. The PendingWindowInDays property determines the length of waiting period.
     * During the waiting period, the key state of CMK is Pending Deletion, which prevents the CMK from being used in
     * cryptographic operations. When the waiting period expires, AWS KMS permanently deletes the CMK.
     *
     * Enter a value between 7 and 30 days.
     *
     * @default - 30 days
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html#cfn-kms-key-pendingwindowindays
     * @experimental
     */
    readonly pendingWindow?: Duration;
}
/**
 * (experimental) Defines a KMS key.
 *
 * @experimental
 * @resource AWS::KMS::Key
 */
export declare class Key extends KeyBase {
    /**
     * (experimental) Import an externally defined KMS Key using its ARN.
     *
     * @param scope the construct that will "own" the imported key.
     * @param id the id of the imported key in the construct tree.
     * @param keyArn the ARN of an existing KMS key.
     * @experimental
     */
    static fromKeyArn(scope: Construct, id: string, keyArn: string): IKey;
    /**
     * (experimental) The ARN of the key.
     *
     * @experimental
     */
    readonly keyArn: string;
    /**
     * (experimental) The ID of the key (the part that looks something like: 1234abcd-12ab-34cd-56ef-1234567890ab).
     *
     * @experimental
     */
    readonly keyId: string;
    /**
     * (experimental) Optional policy document that represents the resource policy of this key.
     *
     * If specified, addToResourcePolicy can be used to edit this policy.
     * Otherwise this method will no-op.
     *
     * @experimental
     */
    protected readonly policy?: iam.PolicyDocument;
    /**
     * (experimental) Optional property to control trusting account identities.
     *
     * If specified, grants will default identity policies instead of to both
     * resource and identity policies. This matches the default behavior when creating
     * KMS keys via the API or console.
     *
     * @experimental
     */
    protected readonly trustAccountIdentities: boolean;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: KeyProps);
    /**
     * (experimental) Grant admins permissions using this key to the given principal.
     *
     * Key administrators have permissions to manage the key (e.g., change permissions, revoke), but do not have permissions
     * to use the key in cryptographic operations (e.g., encrypt, decrypt).
     *
     * @experimental
     */
    grantAdmin(grantee: iam.IGrantable): iam.Grant;
    /**
     * Adds the default key policy to the key. This policy gives the AWS account (root user) full access to the CMK,
     * which reduces the risk of the CMK becoming unmanageable and enables IAM policies to allow access to the CMK.
     * This is the same policy that is default when creating a Key via the KMS API or Console.
     * @see https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default
     */
    private addDefaultAdminPolicy;
    /**
     * Grants the account admin privileges -- not full account access -- plus the GenerateDataKey action.
     * The GenerateDataKey action was added for interop with S3 in https://github.com/aws/aws-cdk/issues/3458.
     *
     * This policy is discouraged and deprecated by the `@aws-cdk/aws-kms:defaultKeyPolicies` feature flag.
     *
     * @link https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default
     * @deprecated
     */
    private addLegacyAdminPolicy;
}
export {};
