import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export interface CfnDeliveryStreamProps {
    /**
     * `AWS::KinesisFirehose::DeliveryStream.DeliveryStreamEncryptionConfigurationInput`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-deliverystreamencryptionconfigurationinput
     */
    readonly deliveryStreamEncryptionConfigurationInput?: CfnDeliveryStream.DeliveryStreamEncryptionConfigurationInputProperty | cdk.IResolvable;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.DeliveryStreamName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-deliverystreamname
     */
    readonly deliveryStreamName?: string;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.DeliveryStreamType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-deliverystreamtype
     */
    readonly deliveryStreamType?: string;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.ElasticsearchDestinationConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration
     */
    readonly elasticsearchDestinationConfiguration?: CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.ExtendedS3DestinationConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration
     */
    readonly extendedS3DestinationConfiguration?: CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.HttpEndpointDestinationConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration
     */
    readonly httpEndpointDestinationConfiguration?: CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.KinesisStreamSourceConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration
     */
    readonly kinesisStreamSourceConfiguration?: CfnDeliveryStream.KinesisStreamSourceConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.RedshiftDestinationConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration
     */
    readonly redshiftDestinationConfiguration?: CfnDeliveryStream.RedshiftDestinationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.S3DestinationConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration
     */
    readonly s3DestinationConfiguration?: CfnDeliveryStream.S3DestinationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.SplunkDestinationConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration
     */
    readonly splunkDestinationConfiguration?: CfnDeliveryStream.SplunkDestinationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare class CfnDeliveryStream extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::KinesisFirehose::DeliveryStream";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDeliveryStream;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.DeliveryStreamEncryptionConfigurationInput`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-deliverystreamencryptionconfigurationinput
     */
    deliveryStreamEncryptionConfigurationInput: CfnDeliveryStream.DeliveryStreamEncryptionConfigurationInputProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.DeliveryStreamName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-deliverystreamname
     */
    deliveryStreamName: string | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.DeliveryStreamType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-deliverystreamtype
     */
    deliveryStreamType: string | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.ElasticsearchDestinationConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration
     */
    elasticsearchDestinationConfiguration: CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.ExtendedS3DestinationConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration
     */
    extendedS3DestinationConfiguration: CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.HttpEndpointDestinationConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration
     */
    httpEndpointDestinationConfiguration: CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.KinesisStreamSourceConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration
     */
    kinesisStreamSourceConfiguration: CfnDeliveryStream.KinesisStreamSourceConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.RedshiftDestinationConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration
     */
    redshiftDestinationConfiguration: CfnDeliveryStream.RedshiftDestinationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.S3DestinationConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration
     */
    s3DestinationConfiguration: CfnDeliveryStream.S3DestinationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.SplunkDestinationConfiguration`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration
     */
    splunkDestinationConfiguration: CfnDeliveryStream.SplunkDestinationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::KinesisFirehose::DeliveryStream`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnDeliveryStreamProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-bufferinghints.html
     */
    interface BufferingHintsProperty {
        /**
         * `CfnDeliveryStream.BufferingHintsProperty.IntervalInSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-bufferinghints.html#cfn-kinesisfirehose-deliverystream-bufferinghints-intervalinseconds
         */
        readonly intervalInSeconds?: number;
        /**
         * `CfnDeliveryStream.BufferingHintsProperty.SizeInMBs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-bufferinghints.html#cfn-kinesisfirehose-deliverystream-bufferinghints-sizeinmbs
         */
        readonly sizeInMBs?: number;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-cloudwatchloggingoptions.html
     */
    interface CloudWatchLoggingOptionsProperty {
        /**
         * `CfnDeliveryStream.CloudWatchLoggingOptionsProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-cloudwatchloggingoptions.html#cfn-kinesisfirehose-deliverystream-cloudwatchloggingoptions-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.CloudWatchLoggingOptionsProperty.LogGroupName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-cloudwatchloggingoptions.html#cfn-kinesisfirehose-deliverystream-cloudwatchloggingoptions-loggroupname
         */
        readonly logGroupName?: string;
        /**
         * `CfnDeliveryStream.CloudWatchLoggingOptionsProperty.LogStreamName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-cloudwatchloggingoptions.html#cfn-kinesisfirehose-deliverystream-cloudwatchloggingoptions-logstreamname
         */
        readonly logStreamName?: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-copycommand.html
     */
    interface CopyCommandProperty {
        /**
         * `CfnDeliveryStream.CopyCommandProperty.CopyOptions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-copycommand.html#cfn-kinesisfirehose-deliverystream-copycommand-copyoptions
         */
        readonly copyOptions?: string;
        /**
         * `CfnDeliveryStream.CopyCommandProperty.DataTableColumns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-copycommand.html#cfn-kinesisfirehose-deliverystream-copycommand-datatablecolumns
         */
        readonly dataTableColumns?: string;
        /**
         * `CfnDeliveryStream.CopyCommandProperty.DataTableName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-copycommand.html#cfn-kinesisfirehose-deliverystream-copycommand-datatablename
         */
        readonly dataTableName: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dataformatconversionconfiguration.html
     */
    interface DataFormatConversionConfigurationProperty {
        /**
         * `CfnDeliveryStream.DataFormatConversionConfigurationProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dataformatconversionconfiguration.html#cfn-kinesisfirehose-deliverystream-dataformatconversionconfiguration-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.DataFormatConversionConfigurationProperty.InputFormatConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dataformatconversionconfiguration.html#cfn-kinesisfirehose-deliverystream-dataformatconversionconfiguration-inputformatconfiguration
         */
        readonly inputFormatConfiguration?: CfnDeliveryStream.InputFormatConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.DataFormatConversionConfigurationProperty.OutputFormatConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dataformatconversionconfiguration.html#cfn-kinesisfirehose-deliverystream-dataformatconversionconfiguration-outputformatconfiguration
         */
        readonly outputFormatConfiguration?: CfnDeliveryStream.OutputFormatConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.DataFormatConversionConfigurationProperty.SchemaConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dataformatconversionconfiguration.html#cfn-kinesisfirehose-deliverystream-dataformatconversionconfiguration-schemaconfiguration
         */
        readonly schemaConfiguration?: CfnDeliveryStream.SchemaConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-deliverystreamencryptionconfigurationinput.html
     */
    interface DeliveryStreamEncryptionConfigurationInputProperty {
        /**
         * `CfnDeliveryStream.DeliveryStreamEncryptionConfigurationInputProperty.KeyARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-deliverystreamencryptionconfigurationinput.html#cfn-kinesisfirehose-deliverystream-deliverystreamencryptionconfigurationinput-keyarn
         */
        readonly keyArn?: string;
        /**
         * `CfnDeliveryStream.DeliveryStreamEncryptionConfigurationInputProperty.KeyType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-deliverystreamencryptionconfigurationinput.html#cfn-kinesisfirehose-deliverystream-deliverystreamencryptionconfigurationinput-keytype
         */
        readonly keyType: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-deserializer.html
     */
    interface DeserializerProperty {
        /**
         * `CfnDeliveryStream.DeserializerProperty.HiveJsonSerDe`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-deserializer.html#cfn-kinesisfirehose-deliverystream-deserializer-hivejsonserde
         */
        readonly hiveJsonSerDe?: CfnDeliveryStream.HiveJsonSerDeProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.DeserializerProperty.OpenXJsonSerDe`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-deserializer.html#cfn-kinesisfirehose-deliverystream-deserializer-openxjsonserde
         */
        readonly openXJsonSerDe?: CfnDeliveryStream.OpenXJsonSerDeProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchbufferinghints.html
     */
    interface ElasticsearchBufferingHintsProperty {
        /**
         * `CfnDeliveryStream.ElasticsearchBufferingHintsProperty.IntervalInSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchbufferinghints.html#cfn-kinesisfirehose-deliverystream-elasticsearchbufferinghints-intervalinseconds
         */
        readonly intervalInSeconds?: number;
        /**
         * `CfnDeliveryStream.ElasticsearchBufferingHintsProperty.SizeInMBs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchbufferinghints.html#cfn-kinesisfirehose-deliverystream-elasticsearchbufferinghints-sizeinmbs
         */
        readonly sizeInMBs?: number;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html
     */
    interface ElasticsearchDestinationConfigurationProperty {
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.BufferingHints`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-bufferinghints
         */
        readonly bufferingHints?: CfnDeliveryStream.ElasticsearchBufferingHintsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.CloudWatchLoggingOptions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-cloudwatchloggingoptions
         */
        readonly cloudWatchLoggingOptions?: CfnDeliveryStream.CloudWatchLoggingOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.ClusterEndpoint`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-clusterendpoint
         */
        readonly clusterEndpoint?: string;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.DomainARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-domainarn
         */
        readonly domainArn?: string;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.IndexName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-indexname
         */
        readonly indexName: string;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.IndexRotationPeriod`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-indexrotationperiod
         */
        readonly indexRotationPeriod?: string;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.ProcessingConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-processingconfiguration
         */
        readonly processingConfiguration?: CfnDeliveryStream.ProcessingConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.RetryOptions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-retryoptions
         */
        readonly retryOptions?: CfnDeliveryStream.ElasticsearchRetryOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.RoleARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.S3BackupMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-s3backupmode
         */
        readonly s3BackupMode?: string;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.S3Configuration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-s3configuration
         */
        readonly s3Configuration: CfnDeliveryStream.S3DestinationConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.TypeName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-typename
         */
        readonly typeName?: string;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.VpcConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-vpcconfiguration
         */
        readonly vpcConfiguration?: CfnDeliveryStream.VpcConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchretryoptions.html
     */
    interface ElasticsearchRetryOptionsProperty {
        /**
         * `CfnDeliveryStream.ElasticsearchRetryOptionsProperty.DurationInSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchretryoptions.html#cfn-kinesisfirehose-deliverystream-elasticsearchretryoptions-durationinseconds
         */
        readonly durationInSeconds?: number;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-encryptionconfiguration.html
     */
    interface EncryptionConfigurationProperty {
        /**
         * `CfnDeliveryStream.EncryptionConfigurationProperty.KMSEncryptionConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-encryptionconfiguration.html#cfn-kinesisfirehose-deliverystream-encryptionconfiguration-kmsencryptionconfig
         */
        readonly kmsEncryptionConfig?: CfnDeliveryStream.KMSEncryptionConfigProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.EncryptionConfigurationProperty.NoEncryptionConfig`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-encryptionconfiguration.html#cfn-kinesisfirehose-deliverystream-encryptionconfiguration-noencryptionconfig
         */
        readonly noEncryptionConfig?: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html
     */
    interface ExtendedS3DestinationConfigurationProperty {
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.BucketARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-bucketarn
         */
        readonly bucketArn: string;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.BufferingHints`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-bufferinghints
         */
        readonly bufferingHints?: CfnDeliveryStream.BufferingHintsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.CloudWatchLoggingOptions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-cloudwatchloggingoptions
         */
        readonly cloudWatchLoggingOptions?: CfnDeliveryStream.CloudWatchLoggingOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.CompressionFormat`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-compressionformat
         */
        readonly compressionFormat?: string;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.DataFormatConversionConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-dataformatconversionconfiguration
         */
        readonly dataFormatConversionConfiguration?: CfnDeliveryStream.DataFormatConversionConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.EncryptionConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-encryptionconfiguration
         */
        readonly encryptionConfiguration?: CfnDeliveryStream.EncryptionConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.ErrorOutputPrefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-erroroutputprefix
         */
        readonly errorOutputPrefix?: string;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.Prefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-prefix
         */
        readonly prefix?: string;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.ProcessingConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-processingconfiguration
         */
        readonly processingConfiguration?: CfnDeliveryStream.ProcessingConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.RoleARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.S3BackupConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-s3backupconfiguration
         */
        readonly s3BackupConfiguration?: CfnDeliveryStream.S3DestinationConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.S3BackupMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-s3backupmode
         */
        readonly s3BackupMode?: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-hivejsonserde.html
     */
    interface HiveJsonSerDeProperty {
        /**
         * `CfnDeliveryStream.HiveJsonSerDeProperty.TimestampFormats`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-hivejsonserde.html#cfn-kinesisfirehose-deliverystream-hivejsonserde-timestampformats
         */
        readonly timestampFormats?: string[];
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointcommonattribute.html
     */
    interface HttpEndpointCommonAttributeProperty {
        /**
         * `CfnDeliveryStream.HttpEndpointCommonAttributeProperty.AttributeName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointcommonattribute.html#cfn-kinesisfirehose-deliverystream-httpendpointcommonattribute-attributename
         */
        readonly attributeName: string;
        /**
         * `CfnDeliveryStream.HttpEndpointCommonAttributeProperty.AttributeValue`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointcommonattribute.html#cfn-kinesisfirehose-deliverystream-httpendpointcommonattribute-attributevalue
         */
        readonly attributeValue: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointconfiguration.html
     */
    interface HttpEndpointConfigurationProperty {
        /**
         * `CfnDeliveryStream.HttpEndpointConfigurationProperty.AccessKey`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointconfiguration-accesskey
         */
        readonly accessKey?: string;
        /**
         * `CfnDeliveryStream.HttpEndpointConfigurationProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointconfiguration-name
         */
        readonly name?: string;
        /**
         * `CfnDeliveryStream.HttpEndpointConfigurationProperty.Url`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointconfiguration-url
         */
        readonly url: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html
     */
    interface HttpEndpointDestinationConfigurationProperty {
        /**
         * `CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty.BufferingHints`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-bufferinghints
         */
        readonly bufferingHints?: CfnDeliveryStream.BufferingHintsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty.CloudWatchLoggingOptions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-cloudwatchloggingoptions
         */
        readonly cloudWatchLoggingOptions?: CfnDeliveryStream.CloudWatchLoggingOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty.EndpointConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-endpointconfiguration
         */
        readonly endpointConfiguration: CfnDeliveryStream.HttpEndpointConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty.ProcessingConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-processingconfiguration
         */
        readonly processingConfiguration?: CfnDeliveryStream.ProcessingConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty.RequestConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-requestconfiguration
         */
        readonly requestConfiguration?: CfnDeliveryStream.HttpEndpointRequestConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty.RetryOptions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-retryoptions
         */
        readonly retryOptions?: CfnDeliveryStream.RetryOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty.RoleARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-rolearn
         */
        readonly roleArn?: string;
        /**
         * `CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty.S3BackupMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-s3backupmode
         */
        readonly s3BackupMode?: string;
        /**
         * `CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty.S3Configuration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-s3configuration
         */
        readonly s3Configuration: CfnDeliveryStream.S3DestinationConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointrequestconfiguration.html
     */
    interface HttpEndpointRequestConfigurationProperty {
        /**
         * `CfnDeliveryStream.HttpEndpointRequestConfigurationProperty.CommonAttributes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointrequestconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointrequestconfiguration-commonattributes
         */
        readonly commonAttributes?: Array<CfnDeliveryStream.HttpEndpointCommonAttributeProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.HttpEndpointRequestConfigurationProperty.ContentEncoding`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointrequestconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointrequestconfiguration-contentencoding
         */
        readonly contentEncoding?: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-inputformatconfiguration.html
     */
    interface InputFormatConfigurationProperty {
        /**
         * `CfnDeliveryStream.InputFormatConfigurationProperty.Deserializer`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-inputformatconfiguration.html#cfn-kinesisfirehose-deliverystream-inputformatconfiguration-deserializer
         */
        readonly deserializer?: CfnDeliveryStream.DeserializerProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kmsencryptionconfig.html
     */
    interface KMSEncryptionConfigProperty {
        /**
         * `CfnDeliveryStream.KMSEncryptionConfigProperty.AWSKMSKeyARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kmsencryptionconfig.html#cfn-kinesisfirehose-deliverystream-kmsencryptionconfig-awskmskeyarn
         */
        readonly awskmsKeyArn: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html
     */
    interface KinesisStreamSourceConfigurationProperty {
        /**
         * `CfnDeliveryStream.KinesisStreamSourceConfigurationProperty.KinesisStreamARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html#cfn-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration-kinesisstreamarn
         */
        readonly kinesisStreamArn: string;
        /**
         * `CfnDeliveryStream.KinesisStreamSourceConfigurationProperty.RoleARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html#cfn-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration-rolearn
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-openxjsonserde.html
     */
    interface OpenXJsonSerDeProperty {
        /**
         * `CfnDeliveryStream.OpenXJsonSerDeProperty.CaseInsensitive`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-openxjsonserde.html#cfn-kinesisfirehose-deliverystream-openxjsonserde-caseinsensitive
         */
        readonly caseInsensitive?: boolean | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.OpenXJsonSerDeProperty.ColumnToJsonKeyMappings`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-openxjsonserde.html#cfn-kinesisfirehose-deliverystream-openxjsonserde-columntojsonkeymappings
         */
        readonly columnToJsonKeyMappings?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.OpenXJsonSerDeProperty.ConvertDotsInJsonKeysToUnderscores`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-openxjsonserde.html#cfn-kinesisfirehose-deliverystream-openxjsonserde-convertdotsinjsonkeystounderscores
         */
        readonly convertDotsInJsonKeysToUnderscores?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html
     */
    interface OrcSerDeProperty {
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.BlockSizeBytes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-blocksizebytes
         */
        readonly blockSizeBytes?: number;
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.BloomFilterColumns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-bloomfiltercolumns
         */
        readonly bloomFilterColumns?: string[];
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.BloomFilterFalsePositiveProbability`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-bloomfilterfalsepositiveprobability
         */
        readonly bloomFilterFalsePositiveProbability?: number;
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.Compression`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-compression
         */
        readonly compression?: string;
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.DictionaryKeyThreshold`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-dictionarykeythreshold
         */
        readonly dictionaryKeyThreshold?: number;
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.EnablePadding`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-enablepadding
         */
        readonly enablePadding?: boolean | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.FormatVersion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-formatversion
         */
        readonly formatVersion?: string;
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.PaddingTolerance`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-paddingtolerance
         */
        readonly paddingTolerance?: number;
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.RowIndexStride`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-rowindexstride
         */
        readonly rowIndexStride?: number;
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.StripeSizeBytes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-stripesizebytes
         */
        readonly stripeSizeBytes?: number;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-outputformatconfiguration.html
     */
    interface OutputFormatConfigurationProperty {
        /**
         * `CfnDeliveryStream.OutputFormatConfigurationProperty.Serializer`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-outputformatconfiguration.html#cfn-kinesisfirehose-deliverystream-outputformatconfiguration-serializer
         */
        readonly serializer?: CfnDeliveryStream.SerializerProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html
     */
    interface ParquetSerDeProperty {
        /**
         * `CfnDeliveryStream.ParquetSerDeProperty.BlockSizeBytes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-blocksizebytes
         */
        readonly blockSizeBytes?: number;
        /**
         * `CfnDeliveryStream.ParquetSerDeProperty.Compression`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-compression
         */
        readonly compression?: string;
        /**
         * `CfnDeliveryStream.ParquetSerDeProperty.EnableDictionaryCompression`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-enabledictionarycompression
         */
        readonly enableDictionaryCompression?: boolean | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ParquetSerDeProperty.MaxPaddingBytes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-maxpaddingbytes
         */
        readonly maxPaddingBytes?: number;
        /**
         * `CfnDeliveryStream.ParquetSerDeProperty.PageSizeBytes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-pagesizebytes
         */
        readonly pageSizeBytes?: number;
        /**
         * `CfnDeliveryStream.ParquetSerDeProperty.WriterVersion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-writerversion
         */
        readonly writerVersion?: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processingconfiguration.html
     */
    interface ProcessingConfigurationProperty {
        /**
         * `CfnDeliveryStream.ProcessingConfigurationProperty.Enabled`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processingconfiguration.html#cfn-kinesisfirehose-deliverystream-processingconfiguration-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ProcessingConfigurationProperty.Processors`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processingconfiguration.html#cfn-kinesisfirehose-deliverystream-processingconfiguration-processors
         */
        readonly processors?: Array<CfnDeliveryStream.ProcessorProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processor.html
     */
    interface ProcessorProperty {
        /**
         * `CfnDeliveryStream.ProcessorProperty.Parameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processor.html#cfn-kinesisfirehose-deliverystream-processor-parameters
         */
        readonly parameters?: Array<CfnDeliveryStream.ProcessorParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ProcessorProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processor.html#cfn-kinesisfirehose-deliverystream-processor-type
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processorparameter.html
     */
    interface ProcessorParameterProperty {
        /**
         * `CfnDeliveryStream.ProcessorParameterProperty.ParameterName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processorparameter.html#cfn-kinesisfirehose-deliverystream-processorparameter-parametername
         */
        readonly parameterName: string;
        /**
         * `CfnDeliveryStream.ProcessorParameterProperty.ParameterValue`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processorparameter.html#cfn-kinesisfirehose-deliverystream-processorparameter-parametervalue
         */
        readonly parameterValue: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html
     */
    interface RedshiftDestinationConfigurationProperty {
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.CloudWatchLoggingOptions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-cloudwatchloggingoptions
         */
        readonly cloudWatchLoggingOptions?: CfnDeliveryStream.CloudWatchLoggingOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.ClusterJDBCURL`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-clusterjdbcurl
         */
        readonly clusterJdbcurl: string;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.CopyCommand`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-copycommand
         */
        readonly copyCommand: CfnDeliveryStream.CopyCommandProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.Password`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-password
         */
        readonly password: string;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.ProcessingConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-processingconfiguration
         */
        readonly processingConfiguration?: CfnDeliveryStream.ProcessingConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.RetryOptions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-retryoptions
         */
        readonly retryOptions?: CfnDeliveryStream.RedshiftRetryOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.RoleARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.S3BackupConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-s3backupconfiguration
         */
        readonly s3BackupConfiguration?: CfnDeliveryStream.S3DestinationConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.S3BackupMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-s3backupmode
         */
        readonly s3BackupMode?: string;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.S3Configuration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-s3configuration
         */
        readonly s3Configuration: CfnDeliveryStream.S3DestinationConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.Username`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-username
         */
        readonly username: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftretryoptions.html
     */
    interface RedshiftRetryOptionsProperty {
        /**
         * `CfnDeliveryStream.RedshiftRetryOptionsProperty.DurationInSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftretryoptions.html#cfn-kinesisfirehose-deliverystream-redshiftretryoptions-durationinseconds
         */
        readonly durationInSeconds?: number;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-retryoptions.html
     */
    interface RetryOptionsProperty {
        /**
         * `CfnDeliveryStream.RetryOptionsProperty.DurationInSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-retryoptions.html#cfn-kinesisfirehose-deliverystream-retryoptions-durationinseconds
         */
        readonly durationInSeconds?: number;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html
     */
    interface S3DestinationConfigurationProperty {
        /**
         * `CfnDeliveryStream.S3DestinationConfigurationProperty.BucketARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-bucketarn
         */
        readonly bucketArn: string;
        /**
         * `CfnDeliveryStream.S3DestinationConfigurationProperty.BufferingHints`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-bufferinghints
         */
        readonly bufferingHints?: CfnDeliveryStream.BufferingHintsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.S3DestinationConfigurationProperty.CloudWatchLoggingOptions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-cloudwatchloggingoptions
         */
        readonly cloudWatchLoggingOptions?: CfnDeliveryStream.CloudWatchLoggingOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.S3DestinationConfigurationProperty.CompressionFormat`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-compressionformat
         */
        readonly compressionFormat?: string;
        /**
         * `CfnDeliveryStream.S3DestinationConfigurationProperty.EncryptionConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-encryptionconfiguration
         */
        readonly encryptionConfiguration?: CfnDeliveryStream.EncryptionConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.S3DestinationConfigurationProperty.ErrorOutputPrefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-erroroutputprefix
         */
        readonly errorOutputPrefix?: string;
        /**
         * `CfnDeliveryStream.S3DestinationConfigurationProperty.Prefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-prefix
         */
        readonly prefix?: string;
        /**
         * `CfnDeliveryStream.S3DestinationConfigurationProperty.RoleARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-rolearn
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html
     */
    interface SchemaConfigurationProperty {
        /**
         * `CfnDeliveryStream.SchemaConfigurationProperty.CatalogId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-catalogid
         */
        readonly catalogId?: string;
        /**
         * `CfnDeliveryStream.SchemaConfigurationProperty.DatabaseName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-databasename
         */
        readonly databaseName?: string;
        /**
         * `CfnDeliveryStream.SchemaConfigurationProperty.Region`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-region
         */
        readonly region?: string;
        /**
         * `CfnDeliveryStream.SchemaConfigurationProperty.RoleARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-rolearn
         */
        readonly roleArn?: string;
        /**
         * `CfnDeliveryStream.SchemaConfigurationProperty.TableName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-tablename
         */
        readonly tableName?: string;
        /**
         * `CfnDeliveryStream.SchemaConfigurationProperty.VersionId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-versionid
         */
        readonly versionId?: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-serializer.html
     */
    interface SerializerProperty {
        /**
         * `CfnDeliveryStream.SerializerProperty.OrcSerDe`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-serializer.html#cfn-kinesisfirehose-deliverystream-serializer-orcserde
         */
        readonly orcSerDe?: CfnDeliveryStream.OrcSerDeProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.SerializerProperty.ParquetSerDe`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-serializer.html#cfn-kinesisfirehose-deliverystream-serializer-parquetserde
         */
        readonly parquetSerDe?: CfnDeliveryStream.ParquetSerDeProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html
     */
    interface SplunkDestinationConfigurationProperty {
        /**
         * `CfnDeliveryStream.SplunkDestinationConfigurationProperty.CloudWatchLoggingOptions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration-cloudwatchloggingoptions
         */
        readonly cloudWatchLoggingOptions?: CfnDeliveryStream.CloudWatchLoggingOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.SplunkDestinationConfigurationProperty.HECAcknowledgmentTimeoutInSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration-hecacknowledgmenttimeoutinseconds
         */
        readonly hecAcknowledgmentTimeoutInSeconds?: number;
        /**
         * `CfnDeliveryStream.SplunkDestinationConfigurationProperty.HECEndpoint`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration-hecendpoint
         */
        readonly hecEndpoint: string;
        /**
         * `CfnDeliveryStream.SplunkDestinationConfigurationProperty.HECEndpointType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration-hecendpointtype
         */
        readonly hecEndpointType: string;
        /**
         * `CfnDeliveryStream.SplunkDestinationConfigurationProperty.HECToken`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration-hectoken
         */
        readonly hecToken: string;
        /**
         * `CfnDeliveryStream.SplunkDestinationConfigurationProperty.ProcessingConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration-processingconfiguration
         */
        readonly processingConfiguration?: CfnDeliveryStream.ProcessingConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.SplunkDestinationConfigurationProperty.RetryOptions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration-retryoptions
         */
        readonly retryOptions?: CfnDeliveryStream.SplunkRetryOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.SplunkDestinationConfigurationProperty.S3BackupMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration-s3backupmode
         */
        readonly s3BackupMode?: string;
        /**
         * `CfnDeliveryStream.SplunkDestinationConfigurationProperty.S3Configuration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration-s3configuration
         */
        readonly s3Configuration: CfnDeliveryStream.S3DestinationConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkretryoptions.html
     */
    interface SplunkRetryOptionsProperty {
        /**
         * `CfnDeliveryStream.SplunkRetryOptionsProperty.DurationInSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkretryoptions.html#cfn-kinesisfirehose-deliverystream-splunkretryoptions-durationinseconds
         */
        readonly durationInSeconds?: number;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 */
export declare namespace CfnDeliveryStream {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-vpcconfiguration.html
     */
    interface VpcConfigurationProperty {
        /**
         * `CfnDeliveryStream.VpcConfigurationProperty.RoleARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-vpcconfiguration.html#cfn-kinesisfirehose-deliverystream-vpcconfiguration-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnDeliveryStream.VpcConfigurationProperty.SecurityGroupIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-vpcconfiguration.html#cfn-kinesisfirehose-deliverystream-vpcconfiguration-securitygroupids
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnDeliveryStream.VpcConfigurationProperty.SubnetIds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-vpcconfiguration.html#cfn-kinesisfirehose-deliverystream-vpcconfiguration-subnetids
         */
        readonly subnetIds: string[];
    }
}
