"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FirehoseMetrics = void 0;
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class FirehoseMetrics {
    static incomingBytesAverage(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'IncomingBytes',
            dimensions,
            statistic: 'Average',
        };
    }
    static incomingRecordsAverage(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'IncomingRecords',
            dimensions,
            statistic: 'Average',
        };
    }
    static backupToS3BytesAverage(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'BackupToS3.Bytes',
            dimensions,
            statistic: 'Average',
        };
    }
    static backupToS3DataFreshnessAverage(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'BackupToS3.DataFreshness',
            dimensions,
            statistic: 'Average',
        };
    }
    static backupToS3RecordsAverage(dimensions) {
        return {
            namespace: 'AWS/Firehose',
            metricName: 'BackupToS3.Records',
            dimensions,
            statistic: 'Average',
        };
    }
}
exports.FirehoseMetrics = FirehoseMetrics;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoia2luZXNpc2ZpcmVob3NlLWNhbm5lZC1tZXRyaWNzLmdlbmVyYXRlZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImtpbmVzaXNmaXJlaG9zZS1jYW5uZWQtbWV0cmljcy5nZW5lcmF0ZWQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsK0VBQStFO0FBQy9FLDRCQUE0QixDQUFDLGlFQUFpRTtBQUM5RixNQUFhLGVBQWU7SUFDakIsTUFBTSxDQUFDLG9CQUFvQixDQUFDLFVBRWxDO1FBQ0csT0FBTztZQUNILFNBQVMsRUFBRSxjQUFjO1lBQ3pCLFVBQVUsRUFBRSxlQUFlO1lBQzNCLFVBQVU7WUFDVixTQUFTLEVBQUUsU0FBUztTQUN2QixDQUFDO0lBQ04sQ0FBQztJQUNNLE1BQU0sQ0FBQyxzQkFBc0IsQ0FBQyxVQUVwQztRQUNHLE9BQU87WUFDSCxTQUFTLEVBQUUsY0FBYztZQUN6QixVQUFVLEVBQUUsaUJBQWlCO1lBQzdCLFVBQVU7WUFDVixTQUFTLEVBQUUsU0FBUztTQUN2QixDQUFDO0lBQ04sQ0FBQztJQUNNLE1BQU0sQ0FBQyxzQkFBc0IsQ0FBQyxVQUVwQztRQUNHLE9BQU87WUFDSCxTQUFTLEVBQUUsY0FBYztZQUN6QixVQUFVLEVBQUUsa0JBQWtCO1lBQzlCLFVBQVU7WUFDVixTQUFTLEVBQUUsU0FBUztTQUN2QixDQUFDO0lBQ04sQ0FBQztJQUNNLE1BQU0sQ0FBQyw4QkFBOEIsQ0FBQyxVQUU1QztRQUNHLE9BQU87WUFDSCxTQUFTLEVBQUUsY0FBYztZQUN6QixVQUFVLEVBQUUsMEJBQTBCO1lBQ3RDLFVBQVU7WUFDVixTQUFTLEVBQUUsU0FBUztTQUN2QixDQUFDO0lBQ04sQ0FBQztJQUNNLE1BQU0sQ0FBQyx3QkFBd0IsQ0FBQyxVQUV0QztRQUNHLE9BQU87WUFDSCxTQUFTLEVBQUUsY0FBYztZQUN6QixVQUFVLEVBQUUsb0JBQW9CO1lBQ2hDLFVBQVU7WUFDVixTQUFTLEVBQUUsU0FBUztTQUN2QixDQUFDO0lBQ04sQ0FBQztDQUNKO0FBbkRELDBDQW1EQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCAyMDEyLTIwMjEgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbi8qIGVzbGludC1kaXNhYmxlIG1heC1sZW4gKi8gLy8gVGhpcyBpcyBnZW5lcmF0ZWQgY29kZSAtIGxpbmUgbGVuZ3RocyBhcmUgZGlmZmljdWx0IHRvIGNvbnRyb2xcbmV4cG9ydCBjbGFzcyBGaXJlaG9zZU1ldHJpY3Mge1xuICAgIHB1YmxpYyBzdGF0aWMgaW5jb21pbmdCeXRlc0F2ZXJhZ2UoZGltZW5zaW9uczoge1xuICAgICAgICBEZWxpdmVyeVN0cmVhbU5hbWU6IHN0cmluZztcbiAgICB9KSB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBuYW1lc3BhY2U6ICdBV1MvRmlyZWhvc2UnLFxuICAgICAgICAgICAgbWV0cmljTmFtZTogJ0luY29taW5nQnl0ZXMnLFxuICAgICAgICAgICAgZGltZW5zaW9ucyxcbiAgICAgICAgICAgIHN0YXRpc3RpYzogJ0F2ZXJhZ2UnLFxuICAgICAgICB9O1xuICAgIH1cbiAgICBwdWJsaWMgc3RhdGljIGluY29taW5nUmVjb3Jkc0F2ZXJhZ2UoZGltZW5zaW9uczoge1xuICAgICAgICBEZWxpdmVyeVN0cmVhbU5hbWU6IHN0cmluZztcbiAgICB9KSB7XG4gICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICBuYW1lc3BhY2U6ICdBV1MvRmlyZWhvc2UnLFxuICAgICAgICAgICAgbWV0cmljTmFtZTogJ0luY29taW5nUmVjb3JkcycsXG4gICAgICAgICAgICBkaW1lbnNpb25zLFxuICAgICAgICAgICAgc3RhdGlzdGljOiAnQXZlcmFnZScsXG4gICAgICAgIH07XG4gICAgfVxuICAgIHB1YmxpYyBzdGF0aWMgYmFja3VwVG9TM0J5dGVzQXZlcmFnZShkaW1lbnNpb25zOiB7XG4gICAgICAgIERlbGl2ZXJ5U3RyZWFtTmFtZTogc3RyaW5nO1xuICAgIH0pIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIG5hbWVzcGFjZTogJ0FXUy9GaXJlaG9zZScsXG4gICAgICAgICAgICBtZXRyaWNOYW1lOiAnQmFja3VwVG9TMy5CeXRlcycsXG4gICAgICAgICAgICBkaW1lbnNpb25zLFxuICAgICAgICAgICAgc3RhdGlzdGljOiAnQXZlcmFnZScsXG4gICAgICAgIH07XG4gICAgfVxuICAgIHB1YmxpYyBzdGF0aWMgYmFja3VwVG9TM0RhdGFGcmVzaG5lc3NBdmVyYWdlKGRpbWVuc2lvbnM6IHtcbiAgICAgICAgRGVsaXZlcnlTdHJlYW1OYW1lOiBzdHJpbmc7XG4gICAgfSkge1xuICAgICAgICByZXR1cm4ge1xuICAgICAgICAgICAgbmFtZXNwYWNlOiAnQVdTL0ZpcmVob3NlJyxcbiAgICAgICAgICAgIG1ldHJpY05hbWU6ICdCYWNrdXBUb1MzLkRhdGFGcmVzaG5lc3MnLFxuICAgICAgICAgICAgZGltZW5zaW9ucyxcbiAgICAgICAgICAgIHN0YXRpc3RpYzogJ0F2ZXJhZ2UnLFxuICAgICAgICB9O1xuICAgIH1cbiAgICBwdWJsaWMgc3RhdGljIGJhY2t1cFRvUzNSZWNvcmRzQXZlcmFnZShkaW1lbnNpb25zOiB7XG4gICAgICAgIERlbGl2ZXJ5U3RyZWFtTmFtZTogc3RyaW5nO1xuICAgIH0pIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIG5hbWVzcGFjZTogJ0FXUy9GaXJlaG9zZScsXG4gICAgICAgICAgICBtZXRyaWNOYW1lOiAnQmFja3VwVG9TMy5SZWNvcmRzJyxcbiAgICAgICAgICAgIGRpbWVuc2lvbnMsXG4gICAgICAgICAgICBzdGF0aXN0aWM6ICdBdmVyYWdlJyxcbiAgICAgICAgfTtcbiAgICB9XG59XG4iXX0=