import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::KinesisAnalytics::Application`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 */
export interface CfnApplicationProps {
    /**
     * `AWS::KinesisAnalytics::Application.Inputs`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-inputs
     */
    readonly inputs: Array<CfnApplication.InputProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::KinesisAnalytics::Application.ApplicationCode`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-applicationcode
     */
    readonly applicationCode?: string;
    /**
     * `AWS::KinesisAnalytics::Application.ApplicationDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-applicationdescription
     */
    readonly applicationDescription?: string;
    /**
     * `AWS::KinesisAnalytics::Application.ApplicationName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-applicationname
     */
    readonly applicationName?: string;
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::Application`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 */
export declare class CfnApplication extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::KinesisAnalytics::Application";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnApplication;
    /**
     * `AWS::KinesisAnalytics::Application.Inputs`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-inputs
     */
    inputs: Array<CfnApplication.InputProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::KinesisAnalytics::Application.ApplicationCode`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-applicationcode
     */
    applicationCode: string | undefined;
    /**
     * `AWS::KinesisAnalytics::Application.ApplicationDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-applicationdescription
     */
    applicationDescription: string | undefined;
    /**
     * `AWS::KinesisAnalytics::Application.ApplicationName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html#cfn-kinesisanalytics-application-applicationname
     */
    applicationName: string | undefined;
    /**
     * Create a new `AWS::KinesisAnalytics::Application`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApplicationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::Application`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-csvmappingparameters.html
     */
    interface CSVMappingParametersProperty {
        /**
         * `CfnApplication.CSVMappingParametersProperty.RecordColumnDelimiter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-csvmappingparameters.html#cfn-kinesisanalytics-application-csvmappingparameters-recordcolumndelimiter
         */
        readonly recordColumnDelimiter: string;
        /**
         * `CfnApplication.CSVMappingParametersProperty.RecordRowDelimiter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-csvmappingparameters.html#cfn-kinesisanalytics-application-csvmappingparameters-recordrowdelimiter
         */
        readonly recordRowDelimiter: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::Application`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html
     */
    interface InputProperty {
        /**
         * `CfnApplication.InputProperty.InputParallelism`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputparallelism
         */
        readonly inputParallelism?: CfnApplication.InputParallelismProperty | cdk.IResolvable;
        /**
         * `CfnApplication.InputProperty.InputProcessingConfiguration`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputprocessingconfiguration
         */
        readonly inputProcessingConfiguration?: CfnApplication.InputProcessingConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnApplication.InputProperty.InputSchema`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-inputschema
         */
        readonly inputSchema: CfnApplication.InputSchemaProperty | cdk.IResolvable;
        /**
         * `CfnApplication.InputProperty.KinesisFirehoseInput`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-kinesisfirehoseinput
         */
        readonly kinesisFirehoseInput?: CfnApplication.KinesisFirehoseInputProperty | cdk.IResolvable;
        /**
         * `CfnApplication.InputProperty.KinesisStreamsInput`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-kinesisstreamsinput
         */
        readonly kinesisStreamsInput?: CfnApplication.KinesisStreamsInputProperty | cdk.IResolvable;
        /**
         * `CfnApplication.InputProperty.NamePrefix`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-input.html#cfn-kinesisanalytics-application-input-nameprefix
         */
        readonly namePrefix: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::Application`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html
     */
    interface InputLambdaProcessorProperty {
        /**
         * `CfnApplication.InputLambdaProcessorProperty.ResourceARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html#cfn-kinesisanalytics-application-inputlambdaprocessor-resourcearn
         */
        readonly resourceArn: string;
        /**
         * `CfnApplication.InputLambdaProcessorProperty.RoleARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputlambdaprocessor.html#cfn-kinesisanalytics-application-inputlambdaprocessor-rolearn
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::Application`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputparallelism.html
     */
    interface InputParallelismProperty {
        /**
         * `CfnApplication.InputParallelismProperty.Count`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputparallelism.html#cfn-kinesisanalytics-application-inputparallelism-count
         */
        readonly count?: number;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::Application`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputprocessingconfiguration.html
     */
    interface InputProcessingConfigurationProperty {
        /**
         * `CfnApplication.InputProcessingConfigurationProperty.InputLambdaProcessor`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputprocessingconfiguration.html#cfn-kinesisanalytics-application-inputprocessingconfiguration-inputlambdaprocessor
         */
        readonly inputLambdaProcessor?: CfnApplication.InputLambdaProcessorProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::Application`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html
     */
    interface InputSchemaProperty {
        /**
         * `CfnApplication.InputSchemaProperty.RecordColumns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordcolumns
         */
        readonly recordColumns: Array<CfnApplication.RecordColumnProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnApplication.InputSchemaProperty.RecordEncoding`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordencoding
         */
        readonly recordEncoding?: string;
        /**
         * `CfnApplication.InputSchemaProperty.RecordFormat`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-inputschema.html#cfn-kinesisanalytics-application-inputschema-recordformat
         */
        readonly recordFormat: CfnApplication.RecordFormatProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::Application`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-jsonmappingparameters.html
     */
    interface JSONMappingParametersProperty {
        /**
         * `CfnApplication.JSONMappingParametersProperty.RecordRowPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-jsonmappingparameters.html#cfn-kinesisanalytics-application-jsonmappingparameters-recordrowpath
         */
        readonly recordRowPath: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::Application`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisfirehoseinput.html
     */
    interface KinesisFirehoseInputProperty {
        /**
         * `CfnApplication.KinesisFirehoseInputProperty.ResourceARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisfirehoseinput.html#cfn-kinesisanalytics-application-kinesisfirehoseinput-resourcearn
         */
        readonly resourceArn: string;
        /**
         * `CfnApplication.KinesisFirehoseInputProperty.RoleARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisfirehoseinput.html#cfn-kinesisanalytics-application-kinesisfirehoseinput-rolearn
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::Application`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisstreamsinput.html
     */
    interface KinesisStreamsInputProperty {
        /**
         * `CfnApplication.KinesisStreamsInputProperty.ResourceARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisstreamsinput.html#cfn-kinesisanalytics-application-kinesisstreamsinput-resourcearn
         */
        readonly resourceArn: string;
        /**
         * `CfnApplication.KinesisStreamsInputProperty.RoleARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-kinesisstreamsinput.html#cfn-kinesisanalytics-application-kinesisstreamsinput-rolearn
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::Application`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html
     */
    interface MappingParametersProperty {
        /**
         * `CfnApplication.MappingParametersProperty.CSVMappingParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html#cfn-kinesisanalytics-application-mappingparameters-csvmappingparameters
         */
        readonly csvMappingParameters?: CfnApplication.CSVMappingParametersProperty | cdk.IResolvable;
        /**
         * `CfnApplication.MappingParametersProperty.JSONMappingParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-mappingparameters.html#cfn-kinesisanalytics-application-mappingparameters-jsonmappingparameters
         */
        readonly jsonMappingParameters?: CfnApplication.JSONMappingParametersProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::Application`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html
     */
    interface RecordColumnProperty {
        /**
         * `CfnApplication.RecordColumnProperty.Mapping`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-mapping
         */
        readonly mapping?: string;
        /**
         * `CfnApplication.RecordColumnProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-name
         */
        readonly name: string;
        /**
         * `CfnApplication.RecordColumnProperty.SqlType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordcolumn.html#cfn-kinesisanalytics-application-recordcolumn-sqltype
         */
        readonly sqlType: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::Application`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::Application
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-application.html
 */
export declare namespace CfnApplication {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html
     */
    interface RecordFormatProperty {
        /**
         * `CfnApplication.RecordFormatProperty.MappingParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html#cfn-kinesisanalytics-application-recordformat-mappingparameters
         */
        readonly mappingParameters?: CfnApplication.MappingParametersProperty | cdk.IResolvable;
        /**
         * `CfnApplication.RecordFormatProperty.RecordFormatType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-application-recordformat.html#cfn-kinesisanalytics-application-recordformat-recordformattype
         */
        readonly recordFormatType: string;
    }
}
/**
 * Properties for defining a `AWS::KinesisAnalytics::ApplicationOutput`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html
 */
export interface CfnApplicationOutputProps {
    /**
     * `AWS::KinesisAnalytics::ApplicationOutput.ApplicationName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html#cfn-kinesisanalytics-applicationoutput-applicationname
     */
    readonly applicationName: string;
    /**
     * `AWS::KinesisAnalytics::ApplicationOutput.Output`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html#cfn-kinesisanalytics-applicationoutput-output
     */
    readonly output: CfnApplicationOutput.OutputProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationOutput`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationOutput
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html
 */
export declare class CfnApplicationOutput extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::KinesisAnalytics::ApplicationOutput";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnApplicationOutput;
    /**
     * `AWS::KinesisAnalytics::ApplicationOutput.ApplicationName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html#cfn-kinesisanalytics-applicationoutput-applicationname
     */
    applicationName: string;
    /**
     * `AWS::KinesisAnalytics::ApplicationOutput.Output`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html#cfn-kinesisanalytics-applicationoutput-output
     */
    output: CfnApplicationOutput.OutputProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::KinesisAnalytics::ApplicationOutput`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApplicationOutputProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationOutput`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationOutput
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html
 */
export declare namespace CfnApplicationOutput {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-destinationschema.html
     */
    interface DestinationSchemaProperty {
        /**
         * `CfnApplicationOutput.DestinationSchemaProperty.RecordFormatType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-destinationschema.html#cfn-kinesisanalytics-applicationoutput-destinationschema-recordformattype
         */
        readonly recordFormatType?: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationOutput`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationOutput
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html
 */
export declare namespace CfnApplicationOutput {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-kinesisfirehoseoutput.html
     */
    interface KinesisFirehoseOutputProperty {
        /**
         * `CfnApplicationOutput.KinesisFirehoseOutputProperty.ResourceARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-kinesisfirehoseoutput.html#cfn-kinesisanalytics-applicationoutput-kinesisfirehoseoutput-resourcearn
         */
        readonly resourceArn: string;
        /**
         * `CfnApplicationOutput.KinesisFirehoseOutputProperty.RoleARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-kinesisfirehoseoutput.html#cfn-kinesisanalytics-applicationoutput-kinesisfirehoseoutput-rolearn
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationOutput`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationOutput
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html
 */
export declare namespace CfnApplicationOutput {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-kinesisstreamsoutput.html
     */
    interface KinesisStreamsOutputProperty {
        /**
         * `CfnApplicationOutput.KinesisStreamsOutputProperty.ResourceARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-kinesisstreamsoutput.html#cfn-kinesisanalytics-applicationoutput-kinesisstreamsoutput-resourcearn
         */
        readonly resourceArn: string;
        /**
         * `CfnApplicationOutput.KinesisStreamsOutputProperty.RoleARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-kinesisstreamsoutput.html#cfn-kinesisanalytics-applicationoutput-kinesisstreamsoutput-rolearn
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationOutput`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationOutput
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html
 */
export declare namespace CfnApplicationOutput {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-lambdaoutput.html
     */
    interface LambdaOutputProperty {
        /**
         * `CfnApplicationOutput.LambdaOutputProperty.ResourceARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-lambdaoutput.html#cfn-kinesisanalytics-applicationoutput-lambdaoutput-resourcearn
         */
        readonly resourceArn: string;
        /**
         * `CfnApplicationOutput.LambdaOutputProperty.RoleARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-lambdaoutput.html#cfn-kinesisanalytics-applicationoutput-lambdaoutput-rolearn
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationOutput`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationOutput
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationoutput.html
 */
export declare namespace CfnApplicationOutput {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-output.html
     */
    interface OutputProperty {
        /**
         * `CfnApplicationOutput.OutputProperty.DestinationSchema`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-output.html#cfn-kinesisanalytics-applicationoutput-output-destinationschema
         */
        readonly destinationSchema: CfnApplicationOutput.DestinationSchemaProperty | cdk.IResolvable;
        /**
         * `CfnApplicationOutput.OutputProperty.KinesisFirehoseOutput`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-output.html#cfn-kinesisanalytics-applicationoutput-output-kinesisfirehoseoutput
         */
        readonly kinesisFirehoseOutput?: CfnApplicationOutput.KinesisFirehoseOutputProperty | cdk.IResolvable;
        /**
         * `CfnApplicationOutput.OutputProperty.KinesisStreamsOutput`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-output.html#cfn-kinesisanalytics-applicationoutput-output-kinesisstreamsoutput
         */
        readonly kinesisStreamsOutput?: CfnApplicationOutput.KinesisStreamsOutputProperty | cdk.IResolvable;
        /**
         * `CfnApplicationOutput.OutputProperty.LambdaOutput`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-output.html#cfn-kinesisanalytics-applicationoutput-output-lambdaoutput
         */
        readonly lambdaOutput?: CfnApplicationOutput.LambdaOutputProperty | cdk.IResolvable;
        /**
         * `CfnApplicationOutput.OutputProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationoutput-output.html#cfn-kinesisanalytics-applicationoutput-output-name
         */
        readonly name?: string;
    }
}
/**
 * Properties for defining a `AWS::KinesisAnalytics::ApplicationReferenceDataSource`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html
 */
export interface CfnApplicationReferenceDataSourceProps {
    /**
     * `AWS::KinesisAnalytics::ApplicationReferenceDataSource.ApplicationName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-applicationname
     */
    readonly applicationName: string;
    /**
     * `AWS::KinesisAnalytics::ApplicationReferenceDataSource.ReferenceDataSource`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-referencedatasource
     */
    readonly referenceDataSource: CfnApplicationReferenceDataSource.ReferenceDataSourceProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationReferenceDataSource`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationReferenceDataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html
 */
export declare class CfnApplicationReferenceDataSource extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::KinesisAnalytics::ApplicationReferenceDataSource";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnApplicationReferenceDataSource;
    /**
     * `AWS::KinesisAnalytics::ApplicationReferenceDataSource.ApplicationName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-applicationname
     */
    applicationName: string;
    /**
     * `AWS::KinesisAnalytics::ApplicationReferenceDataSource.ReferenceDataSource`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-referencedatasource
     */
    referenceDataSource: CfnApplicationReferenceDataSource.ReferenceDataSourceProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::KinesisAnalytics::ApplicationReferenceDataSource`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApplicationReferenceDataSourceProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationReferenceDataSource`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationReferenceDataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html
 */
export declare namespace CfnApplicationReferenceDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-csvmappingparameters.html
     */
    interface CSVMappingParametersProperty {
        /**
         * `CfnApplicationReferenceDataSource.CSVMappingParametersProperty.RecordColumnDelimiter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-csvmappingparameters.html#cfn-kinesisanalytics-applicationreferencedatasource-csvmappingparameters-recordcolumndelimiter
         */
        readonly recordColumnDelimiter: string;
        /**
         * `CfnApplicationReferenceDataSource.CSVMappingParametersProperty.RecordRowDelimiter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-csvmappingparameters.html#cfn-kinesisanalytics-applicationreferencedatasource-csvmappingparameters-recordrowdelimiter
         */
        readonly recordRowDelimiter: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationReferenceDataSource`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationReferenceDataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html
 */
export declare namespace CfnApplicationReferenceDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-jsonmappingparameters.html
     */
    interface JSONMappingParametersProperty {
        /**
         * `CfnApplicationReferenceDataSource.JSONMappingParametersProperty.RecordRowPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-jsonmappingparameters.html#cfn-kinesisanalytics-applicationreferencedatasource-jsonmappingparameters-recordrowpath
         */
        readonly recordRowPath: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationReferenceDataSource`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationReferenceDataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html
 */
export declare namespace CfnApplicationReferenceDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-mappingparameters.html
     */
    interface MappingParametersProperty {
        /**
         * `CfnApplicationReferenceDataSource.MappingParametersProperty.CSVMappingParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-mappingparameters.html#cfn-kinesisanalytics-applicationreferencedatasource-mappingparameters-csvmappingparameters
         */
        readonly csvMappingParameters?: CfnApplicationReferenceDataSource.CSVMappingParametersProperty | cdk.IResolvable;
        /**
         * `CfnApplicationReferenceDataSource.MappingParametersProperty.JSONMappingParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-mappingparameters.html#cfn-kinesisanalytics-applicationreferencedatasource-mappingparameters-jsonmappingparameters
         */
        readonly jsonMappingParameters?: CfnApplicationReferenceDataSource.JSONMappingParametersProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationReferenceDataSource`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationReferenceDataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html
 */
export declare namespace CfnApplicationReferenceDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordcolumn.html
     */
    interface RecordColumnProperty {
        /**
         * `CfnApplicationReferenceDataSource.RecordColumnProperty.Mapping`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordcolumn.html#cfn-kinesisanalytics-applicationreferencedatasource-recordcolumn-mapping
         */
        readonly mapping?: string;
        /**
         * `CfnApplicationReferenceDataSource.RecordColumnProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordcolumn.html#cfn-kinesisanalytics-applicationreferencedatasource-recordcolumn-name
         */
        readonly name: string;
        /**
         * `CfnApplicationReferenceDataSource.RecordColumnProperty.SqlType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordcolumn.html#cfn-kinesisanalytics-applicationreferencedatasource-recordcolumn-sqltype
         */
        readonly sqlType: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationReferenceDataSource`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationReferenceDataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html
 */
export declare namespace CfnApplicationReferenceDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordformat.html
     */
    interface RecordFormatProperty {
        /**
         * `CfnApplicationReferenceDataSource.RecordFormatProperty.MappingParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordformat.html#cfn-kinesisanalytics-applicationreferencedatasource-recordformat-mappingparameters
         */
        readonly mappingParameters?: CfnApplicationReferenceDataSource.MappingParametersProperty | cdk.IResolvable;
        /**
         * `CfnApplicationReferenceDataSource.RecordFormatProperty.RecordFormatType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-recordformat.html#cfn-kinesisanalytics-applicationreferencedatasource-recordformat-recordformattype
         */
        readonly recordFormatType: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationReferenceDataSource`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationReferenceDataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html
 */
export declare namespace CfnApplicationReferenceDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referencedatasource.html
     */
    interface ReferenceDataSourceProperty {
        /**
         * `CfnApplicationReferenceDataSource.ReferenceDataSourceProperty.ReferenceSchema`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-referencedatasource-referenceschema
         */
        readonly referenceSchema: CfnApplicationReferenceDataSource.ReferenceSchemaProperty | cdk.IResolvable;
        /**
         * `CfnApplicationReferenceDataSource.ReferenceDataSourceProperty.S3ReferenceDataSource`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-referencedatasource-s3referencedatasource
         */
        readonly s3ReferenceDataSource?: CfnApplicationReferenceDataSource.S3ReferenceDataSourceProperty | cdk.IResolvable;
        /**
         * `CfnApplicationReferenceDataSource.ReferenceDataSourceProperty.TableName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-referencedatasource-tablename
         */
        readonly tableName?: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationReferenceDataSource`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationReferenceDataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html
 */
export declare namespace CfnApplicationReferenceDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referenceschema.html
     */
    interface ReferenceSchemaProperty {
        /**
         * `CfnApplicationReferenceDataSource.ReferenceSchemaProperty.RecordColumns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referenceschema.html#cfn-kinesisanalytics-applicationreferencedatasource-referenceschema-recordcolumns
         */
        readonly recordColumns: Array<CfnApplicationReferenceDataSource.RecordColumnProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnApplicationReferenceDataSource.ReferenceSchemaProperty.RecordEncoding`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referenceschema.html#cfn-kinesisanalytics-applicationreferencedatasource-referenceschema-recordencoding
         */
        readonly recordEncoding?: string;
        /**
         * `CfnApplicationReferenceDataSource.ReferenceSchemaProperty.RecordFormat`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-referenceschema.html#cfn-kinesisanalytics-applicationreferencedatasource-referenceschema-recordformat
         */
        readonly recordFormat: CfnApplicationReferenceDataSource.RecordFormatProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisAnalytics::ApplicationReferenceDataSource`.
 *
 * @external
 * @cloudformationResource AWS::KinesisAnalytics::ApplicationReferenceDataSource
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisanalytics-applicationreferencedatasource.html
 */
export declare namespace CfnApplicationReferenceDataSource {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-s3referencedatasource.html
     */
    interface S3ReferenceDataSourceProperty {
        /**
         * `CfnApplicationReferenceDataSource.S3ReferenceDataSourceProperty.BucketARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-s3referencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-s3referencedatasource-bucketarn
         */
        readonly bucketArn: string;
        /**
         * `CfnApplicationReferenceDataSource.S3ReferenceDataSourceProperty.FileKey`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-s3referencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-s3referencedatasource-filekey
         */
        readonly fileKey: string;
        /**
         * `CfnApplicationReferenceDataSource.S3ReferenceDataSourceProperty.ReferenceRoleARN`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisanalytics-applicationreferencedatasource-s3referencedatasource.html#cfn-kinesisanalytics-applicationreferencedatasource-s3referencedatasource-referencerolearn
         */
        readonly referenceRoleArn: string;
    }
}
