"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisAnalyticsMetrics = void 0;
// Copyright 2012-2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class KinesisAnalyticsMetrics {
    static bytesAverage(dimensions) {
        return {
            namespace: 'AWS/KinesisAnalytics',
            metricName: 'Bytes',
            dimensions,
            statistic: 'Average',
        };
    }
    static kpUsAverage(dimensions) {
        return {
            namespace: 'AWS/KinesisAnalytics',
            metricName: 'KPUs',
            dimensions,
            statistic: 'Average',
        };
    }
    static millisBehindLatestAverage(dimensions) {
        return {
            namespace: 'AWS/KinesisAnalytics',
            metricName: 'MillisBehindLatest',
            dimensions,
            statistic: 'Average',
        };
    }
    static recordsAverage(dimensions) {
        return {
            namespace: 'AWS/KinesisAnalytics',
            metricName: 'Records',
            dimensions,
            statistic: 'Average',
        };
    }
    static successAverage(dimensions) {
        return {
            namespace: 'AWS/KinesisAnalytics',
            metricName: 'Success',
            dimensions,
            statistic: 'Average',
        };
    }
    static inputProcessingDurationAverage(dimensions) {
        return {
            namespace: 'AWS/KinesisAnalytics',
            metricName: 'InputProcessing.Duration',
            dimensions,
            statistic: 'Average',
        };
    }
    static inputProcessingOkRecordsSum(dimensions) {
        return {
            namespace: 'AWS/KinesisAnalytics',
            metricName: 'InputProcessing.OkRecords',
            dimensions,
            statistic: 'Sum',
        };
    }
    static inputProcessingOkBytesSum(dimensions) {
        return {
            namespace: 'AWS/KinesisAnalytics',
            metricName: 'InputProcessing.OkBytes',
            dimensions,
            statistic: 'Sum',
        };
    }
    static inputProcessingDroppedRecordsSum(dimensions) {
        return {
            namespace: 'AWS/KinesisAnalytics',
            metricName: 'InputProcessing.DroppedRecords',
            dimensions,
            statistic: 'Sum',
        };
    }
    static inputProcessingProcessingFailedRecordsSum(dimensions) {
        return {
            namespace: 'AWS/KinesisAnalytics',
            metricName: 'InputProcessing.ProcessingFailedRecords',
            dimensions,
            statistic: 'Sum',
        };
    }
    static inputProcessingSuccessSum(dimensions) {
        return {
            namespace: 'AWS/KinesisAnalytics',
            metricName: 'InputProcessing.Success',
            dimensions,
            statistic: 'Sum',
        };
    }
    static lambdaDeliveryOkRecordsSum(dimensions) {
        return {
            namespace: 'AWS/KinesisAnalytics',
            metricName: 'LambdaDelivery.OkRecords',
            dimensions,
            statistic: 'Sum',
        };
    }
    static lambdaDeliveryDeliveryFailedRecordsSum(dimensions) {
        return {
            namespace: 'AWS/KinesisAnalytics',
            metricName: 'LambdaDelivery.DeliveryFailedRecords',
            dimensions,
            statistic: 'Sum',
        };
    }
    static lambdaDeliveryDurationAverage(dimensions) {
        return {
            namespace: 'AWS/KinesisAnalytics',
            metricName: 'LambdaDelivery.Duration',
            dimensions,
            statistic: 'Average',
        };
    }
}
exports.KinesisAnalyticsMetrics = KinesisAnalyticsMetrics;
//# sourceMappingURL=data:application/json;base64,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