"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateFlinkApplicationProps = void 0;
const core = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
/**
 * Early validation for the props used to create FlinkApplications.
 */
function validateFlinkApplicationProps(props) {
    validateApplicationName(props.applicationName);
    validateParallelism(props.parallelism);
    validateParallelismPerKpu(props.parallelismPerKpu);
}
exports.validateFlinkApplicationProps = validateFlinkApplicationProps;
function validateApplicationName(applicationName) {
    if (applicationName === undefined || core.Token.isUnresolved(applicationName)) {
        return;
    }
    if (applicationName.length === 0) {
        throw new Error('applicationName cannot be empty. It must contain at least 1 character.');
    }
    if (!/^[a-zA-Z0-9_.-]+$/.test(applicationName)) {
        throw new Error(`applicationName may only contain letters, numbers, underscores, hyphens, and periods. Name: ${applicationName}`);
    }
    if (applicationName.length > 128) {
        throw new Error(`applicationName max length is 128. Name: ${applicationName} is ${applicationName.length} characters.`);
    }
}
function validateParallelism(parallelism) {
    if (parallelism === undefined || core.Token.isUnresolved(parallelism)) {
        return;
    }
    if (parallelism < 1) {
        throw new Error('parallelism must be at least 1');
    }
}
function validateParallelismPerKpu(parallelismPerKpu) {
    if (parallelismPerKpu === undefined || core.Token.isUnresolved(parallelismPerKpu)) {
        return;
    }
    if (parallelismPerKpu < 1) {
        throw new Error('parallelismPerKpu must be at least 1');
    }
}
//# sourceMappingURL=data:application/json;base64,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