"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.flinkApplicationConfiguration = void 0;
/**
 * Build the nested Cfn FlinkApplicationConfiguration object. This function
 * doesn't return empty config objects, returning the minimal config needed to
 * express the supplied properties.
 *
 * This function also handles the quirky configType: 'CUSTOM' setting required
 * whenever config in one of the nested groupings.
 */
function flinkApplicationConfiguration(config) {
    var _a, _b;
    const checkpointConfiguration = configFor({
        checkpointingEnabled: config.checkpointingEnabled,
        checkpointInterval: (_a = config.checkpointInterval) === null || _a === void 0 ? void 0 : _a.toMilliseconds(),
        minPauseBetweenCheckpoints: (_b = config.minPauseBetweenCheckpoints) === null || _b === void 0 ? void 0 : _b.toMilliseconds(),
    });
    const monitoringConfiguration = configFor({
        logLevel: config.logLevel,
        metricsLevel: config.metricsLevel,
    });
    const parallelismConfiguration = configFor({
        autoScalingEnabled: config.autoScalingEnabled,
        parallelism: config.parallelism,
        parallelismPerKpu: config.parallelismPerKpu,
    });
    const applicationConfiguration = {
        checkpointConfiguration,
        monitoringConfiguration,
        parallelismConfiguration,
    };
    if (isEmptyObj(applicationConfiguration)) {
        return;
    }
    return applicationConfiguration;
}
exports.flinkApplicationConfiguration = flinkApplicationConfiguration;
function configFor(config) {
    if (isEmptyObj(config)) {
        return;
    }
    return {
        ...config,
        configurationType: 'CUSTOM',
    };
}
function isEmptyObj(obj) {
    return Object.values(obj).every(v => v === undefined);
}
//# sourceMappingURL=data:application/json;base64,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