import * as core from "../../../core";
import { LogLevel, MetricsLevel } from '../types';
interface FlinkApplicationConfiguration extends CheckpointConfiguration, MonitoringConfiguration, ParallelismConfiguration {
}
interface CheckpointConfiguration {
    checkpointingEnabled?: boolean;
    checkpointInterval?: core.Duration;
    minPauseBetweenCheckpoints?: core.Duration;
}
interface MonitoringConfiguration {
    logLevel?: LogLevel;
    metricsLevel?: MetricsLevel;
}
interface ParallelismConfiguration {
    autoScalingEnabled?: boolean;
    parallelism?: number;
    parallelismPerKpu?: number;
}
/**
 * Build the nested Cfn FlinkApplicationConfiguration object. This function
 * doesn't return empty config objects, returning the minimal config needed to
 * express the supplied properties.
 *
 * This function also handles the quirky configType: 'CUSTOM' setting required
 * whenever config in one of the nested groupings.
 */
export declare function flinkApplicationConfiguration(config: FlinkApplicationConfiguration): {
    checkpointConfiguration: {
        configurationType: string;
    } | undefined;
    monitoringConfiguration: {
        configurationType: string;
    } | undefined;
    parallelismConfiguration: {
        configurationType: string;
    } | undefined;
} | undefined;
export {};
