import * as iam from "../../aws-iam";
import * as logs from "../../aws-logs";
import * as core from "../../core";
import { Construct } from 'constructs';
import { ApplicationCode } from './application-code';
import { LogLevel, MetricsLevel, PropertyGroups, Runtime } from './types';
/**
 * (experimental) An interface expressing the public properties on both an imported and CDK-created Flink application.
 *
 * @experimental
 */
export interface IApplication extends core.IResource, iam.IGrantable {
    /**
     * (experimental) The application ARN.
     *
     * @experimental
     * @attribute true
     */
    readonly applicationArn: string;
    /**
     * (experimental) The name of the Flink application.
     *
     * @experimental
     * @attribute true
     */
    readonly applicationName: string;
    /**
     * (experimental) The application IAM role.
     *
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) Convenience method for adding a policy statement to the application role.
     *
     * @experimental
     */
    addToRolePolicy(policyStatement: iam.PolicyStatement): boolean;
}
/**
 * Implements the functionality shared between CDK created and imported
 * IApplications.
 */
declare abstract class ApplicationBase extends core.Resource implements IApplication {
    abstract readonly applicationArn: string;
    abstract readonly applicationName: string;
    abstract readonly role?: iam.IRole;
    abstract readonly grantPrincipal: iam.IPrincipal;
    /**
     * (experimental) Implement the convenience {@link IApplication.addToPrincipalPolicy} method.
     *
     * @experimental
     */
    addToRolePolicy(policyStatement: iam.PolicyStatement): boolean;
}
/**
 * (experimental) Props for creating an Application construct.
 *
 * @experimental
 */
export interface ApplicationProps {
    /**
     * (experimental) A name for your Application that is unique to an AWS account.
     *
     * @default - CloudFormation-generated name
     * @experimental
     */
    readonly applicationName?: string;
    /**
     * (experimental) The Flink version to use for this application.
     *
     * @experimental
     */
    readonly runtime: Runtime;
    /**
     * (experimental) The Flink code asset to run.
     *
     * @experimental
     */
    readonly code: ApplicationCode;
    /**
     * (experimental) Whether checkpointing is enabled while your application runs.
     *
     * @default true
     * @experimental
     */
    readonly checkpointingEnabled?: boolean;
    /**
     * (experimental) The interval between checkpoints.
     *
     * @default 1 minute
     * @experimental
     */
    readonly checkpointInterval?: core.Duration;
    /**
     * (experimental) The minimum amount of time in to wait after a checkpoint finishes to start a new checkpoint.
     *
     * @default 5 seconds
     * @experimental
     */
    readonly minPauseBetweenCheckpoints?: core.Duration;
    /**
     * (experimental) The level of log verbosity from the Flink application.
     *
     * @default FlinkLogLevel.INFO
     * @experimental
     */
    readonly logLevel?: LogLevel;
    /**
     * (experimental) Describes the granularity of the CloudWatch metrics for an application.
     *
     * Use caution with Parallelism level metrics. Parallelism granularity logs
     * metrics for each parallel thread and can quickly become expensive when
     * parallelism is high (e.g. > 64).
     *
     * @default MetricsLevel.APPLICATION
     * @experimental
     */
    readonly metricsLevel?: MetricsLevel;
    /**
     * (experimental) Whether the Kinesis Data Analytics service can increase the parallelism of the application in response to resource usage.
     *
     * @default true
     * @experimental
     */
    readonly autoScalingEnabled?: boolean;
    /**
     * (experimental) The initial parallelism for the application.
     *
     * Kinesis Data Analytics can
     * stop the app, increase the parallelism, and start the app again if
     * autoScalingEnabled is true (the default value).
     *
     * @default 1
     * @experimental
     */
    readonly parallelism?: number;
    /**
     * (experimental) The Flink parallelism allowed per Kinesis Processing Unit (KPU).
     *
     * @default 1
     * @experimental
     */
    readonly parallelismPerKpu?: number;
    /**
     * (experimental) Determines if Flink snapshots are enabled.
     *
     * @default true
     * @experimental
     */
    readonly snapshotsEnabled?: boolean;
    /**
     * (experimental) Configuration PropertyGroups.
     *
     * You can use these property groups to pass
     * arbitrary runtime configuration values to your Flink app.
     *
     * @default No property group configuration provided to the Flink app
     * @experimental
     */
    readonly propertyGroups?: PropertyGroups;
    /**
     * (experimental) A role to use to grant permissions to your application.
     *
     * Prefer omitting
     * this property and using the default role.
     *
     * @default - a new Role will be created
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) Provide a RemovalPolicy to override the default.
     *
     * @default RemovalPolicy.DESTROY
     * @experimental
     */
    readonly removalPolicy?: core.RemovalPolicy;
    /**
     * (experimental) The log group to send log entries to.
     *
     * @default CDK's default LogGroup
     * @experimental
     */
    readonly logGroup?: logs.ILogGroup;
}
/**
 * (experimental) The L2 construct for Flink Kinesis Data Applications.
 *
 * @experimental
 * @resource AWS::KinesisAnalyticsV2::Application
 */
export declare class Application extends ApplicationBase {
    /**
     * (experimental) Import an existing Flink application defined outside of CDK code by applicationName.
     *
     * @experimental
     */
    static fromApplicationName(scope: Construct, id: string, applicationName: string): IApplication;
    /**
     * (experimental) Import an existing application defined outside of CDK code by applicationArn.
     *
     * @experimental
     */
    static fromApplicationArn(scope: Construct, id: string, applicationArn: string): IApplication;
    /**
     * (experimental) The application ARN.
     *
     * @experimental
     */
    readonly applicationArn: string;
    /**
     * (experimental) The name of the Flink application.
     *
     * @experimental
     */
    readonly applicationName: string;
    /**
     * (experimental) The application IAM role.
     *
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    readonly grantPrincipal: iam.IPrincipal;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ApplicationProps);
}
export {};
