"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationCode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const s3_assets = require("../../aws-s3-assets"); // Automatically re-written from '@aws-cdk/aws-s3-assets'
/**
 * (experimental) Code configuration providing the location to a Flink application JAR file.
 *
 * @experimental
 */
class ApplicationCode {
    /**
     * (experimental) Reference code from an S3 bucket.
     *
     * @param bucket - an s3 bucket.
     * @param fileKey - a key pointing to a Flink JAR file.
     * @param objectVersion - an optional version string for the provided fileKey.
     * @experimental
     */
    static fromBucket(bucket, fileKey, objectVersion) {
        return new BucketApplicationCode({
            bucket,
            fileKey,
            objectVersion,
        });
    }
    /**
     * (experimental) Reference code from a local directory containing a Flink JAR file.
     *
     * @param path - a local directory path.
     * @experimental
     * @parm options - standard s3 AssetOptions
     */
    static fromAsset(path, options) {
        return new AssetApplicationCode(path, options);
    }
}
exports.ApplicationCode = ApplicationCode;
_a = JSII_RTTI_SYMBOL_1;
ApplicationCode[_a] = { fqn: "monocdk.aws_kinesisanalytics_flink.ApplicationCode", version: "1.106.1" };
class BucketApplicationCode extends ApplicationCode {
    constructor(props) {
        super();
        this.bucket = props.bucket;
        this.fileKey = props.fileKey;
        this.objectVersion = props.objectVersion;
    }
    bind(_scope) {
        return {
            applicationCodeConfigurationProperty: {
                applicationCodeConfiguration: {
                    codeContent: {
                        s3ContentLocation: {
                            bucketArn: this.bucket.bucketArn,
                            fileKey: this.fileKey,
                            objectVersion: this.objectVersion,
                        },
                    },
                    codeContentType: 'ZIPFILE',
                },
            },
            bucket: this.bucket,
        };
    }
}
class AssetApplicationCode extends ApplicationCode {
    constructor(path, options) {
        super();
        this.path = path;
        this.options = options;
    }
    bind(scope) {
        this._asset = new s3_assets.Asset(scope, 'Code', {
            path: this.path,
            ...this.options,
        });
        if (!this._asset.isZipArchive) {
            throw new Error(`Asset must be a .zip file or a directory (${this.path})`);
        }
        return {
            applicationCodeConfigurationProperty: {
                applicationCodeConfiguration: {
                    codeContent: {
                        s3ContentLocation: {
                            bucketArn: this._asset.bucket.bucketArn,
                            fileKey: this._asset.s3ObjectKey,
                        },
                    },
                    codeContentType: 'ZIPFILE',
                },
            },
            bucket: this._asset.bucket,
        };
    }
    get asset() {
        return this._asset;
    }
    get bucket() {
        var _b;
        return (_b = this._asset) === null || _b === void 0 ? void 0 : _b.bucket;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBwbGljYXRpb24tY29kZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFwcGxpY2F0aW9uLWNvZGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFFQSxpREFBaUQsQ0FBQyx5REFBeUQ7Ozs7OztBQW9CM0csTUFBc0IsZUFBZTs7Ozs7Ozs7O0lBUTFCLE1BQU0sQ0FBQyxVQUFVLENBQUMsTUFBa0IsRUFBRSxPQUFlLEVBQUUsYUFBc0I7UUFDaEYsT0FBTyxJQUFJLHFCQUFxQixDQUFDO1lBQzdCLE1BQU07WUFDTixPQUFPO1lBQ1AsYUFBYTtTQUNoQixDQUFDLENBQUM7SUFDUCxDQUFDOzs7Ozs7OztJQU9NLE1BQU0sQ0FBQyxTQUFTLENBQUMsSUFBWSxFQUFFLE9BQWdDO1FBQ2xFLE9BQU8sSUFBSSxvQkFBb0IsQ0FBQyxJQUFJLEVBQUUsT0FBTyxDQUFDLENBQUM7SUFDbkQsQ0FBQzs7QUF2QkwsMENBNEJDOzs7QUFNRCxNQUFNLHFCQUFzQixTQUFRLGVBQWU7SUFJL0MsWUFBWSxLQUFpQztRQUN6QyxLQUFLLEVBQUUsQ0FBQztRQUNSLElBQUksQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQztRQUMzQixJQUFJLENBQUMsT0FBTyxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUM7UUFDN0IsSUFBSSxDQUFDLGFBQWEsR0FBRyxLQUFLLENBQUMsYUFBYSxDQUFDO0lBQzdDLENBQUM7SUFDTSxJQUFJLENBQUMsTUFBaUI7UUFDekIsT0FBTztZQUNILG9DQUFvQyxFQUFFO2dCQUNsQyw0QkFBNEIsRUFBRTtvQkFDMUIsV0FBVyxFQUFFO3dCQUNULGlCQUFpQixFQUFFOzRCQUNmLFNBQVMsRUFBRSxJQUFJLENBQUMsTUFBTyxDQUFDLFNBQVM7NEJBQ2pDLE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBTzs0QkFDckIsYUFBYSxFQUFFLElBQUksQ0FBQyxhQUFhO3lCQUNwQztxQkFDSjtvQkFDRCxlQUFlLEVBQUUsU0FBUztpQkFDN0I7YUFDSjtZQUNELE1BQU0sRUFBRSxJQUFJLENBQUMsTUFBTztTQUN2QixDQUFDO0lBQ04sQ0FBQztDQUNKO0FBQ0QsTUFBTSxvQkFBcUIsU0FBUSxlQUFlO0lBSTlDLFlBQVksSUFBWSxFQUFFLE9BQWdDO1FBQ3RELEtBQUssRUFBRSxDQUFDO1FBQ1IsSUFBSSxDQUFDLElBQUksR0FBRyxJQUFJLENBQUM7UUFDakIsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPLENBQUM7SUFDM0IsQ0FBQztJQUNNLElBQUksQ0FBQyxLQUFnQjtRQUN4QixJQUFJLENBQUMsTUFBTSxHQUFHLElBQUksU0FBUyxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsTUFBTSxFQUFFO1lBQzdDLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSTtZQUNmLEdBQUcsSUFBSSxDQUFDLE9BQU87U0FDbEIsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsWUFBWSxFQUFFO1lBQzNCLE1BQU0sSUFBSSxLQUFLLENBQUMsNkNBQTZDLElBQUksQ0FBQyxJQUFJLEdBQUcsQ0FBQyxDQUFDO1NBQzlFO1FBQ0QsT0FBTztZQUNILG9DQUFvQyxFQUFFO2dCQUNsQyw0QkFBNEIsRUFBRTtvQkFDMUIsV0FBVyxFQUFFO3dCQUNULGlCQUFpQixFQUFFOzRCQUNmLFNBQVMsRUFBRSxJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxTQUFTOzRCQUN2QyxPQUFPLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxXQUFXO3lCQUNuQztxQkFDSjtvQkFDRCxlQUFlLEVBQUUsU0FBUztpQkFDN0I7YUFDSjtZQUNELE1BQU0sRUFBRSxJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU07U0FDN0IsQ0FBQztJQUNOLENBQUM7SUFDRCxJQUFJLEtBQUs7UUFDTCxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUM7SUFDdkIsQ0FBQztJQUNELElBQUksTUFBTTs7UUFDTixhQUFPLElBQUksQ0FBQyxNQUFNLDBDQUFFLE1BQU0sQ0FBQztJQUMvQixDQUFDO0NBQ0oiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBrYSBmcm9tIFwiLi4vLi4vYXdzLWtpbmVzaXNhbmFseXRpY3NcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2F3cy1raW5lc2lzYW5hbHl0aWNzJ1xuaW1wb3J0ICogYXMgczMgZnJvbSBcIi4uLy4uL2F3cy1zM1wiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLXMzJ1xuaW1wb3J0ICogYXMgczNfYXNzZXRzIGZyb20gXCIuLi8uLi9hd3MtczMtYXNzZXRzXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3MtczMtYXNzZXRzJ1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSBcIi4uLy4uL2NvcmVcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2NvcmUnXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBBcHBsaWNhdGlvbkNvZGVDb25maWcge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBhcHBsaWNhdGlvbkNvZGVDb25maWd1cmF0aW9uUHJvcGVydHk6IGthLkNmbkFwcGxpY2F0aW9uVjIuQXBwbGljYXRpb25Db25maWd1cmF0aW9uUHJvcGVydHk7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IGJ1Y2tldDogczMuSUJ1Y2tldDtcbn1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBBcHBsaWNhdGlvbkNvZGUge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyBmcm9tQnVja2V0KGJ1Y2tldDogczMuSUJ1Y2tldCwgZmlsZUtleTogc3RyaW5nLCBvYmplY3RWZXJzaW9uPzogc3RyaW5nKTogQXBwbGljYXRpb25Db2RlIHtcbiAgICAgICAgcmV0dXJuIG5ldyBCdWNrZXRBcHBsaWNhdGlvbkNvZGUoe1xuICAgICAgICAgICAgYnVja2V0LFxuICAgICAgICAgICAgZmlsZUtleSxcbiAgICAgICAgICAgIG9iamVjdFZlcnNpb24sXG4gICAgICAgIH0pO1xuICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHN0YXRpYyBmcm9tQXNzZXQocGF0aDogc3RyaW5nLCBvcHRpb25zPzogczNfYXNzZXRzLkFzc2V0T3B0aW9ucyk6IEFwcGxpY2F0aW9uQ29kZSB7XG4gICAgICAgIHJldHVybiBuZXcgQXNzZXRBcHBsaWNhdGlvbkNvZGUocGF0aCwgb3B0aW9ucyk7XG4gICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyBhYnN0cmFjdCBiaW5kKHNjb3BlOiBDb25zdHJ1Y3QpOiBBcHBsaWNhdGlvbkNvZGVDb25maWc7XG59XG5pbnRlcmZhY2UgQnVja2V0QXBwbGljYXRpb25Db2RlUHJvcHMge1xuICAgIHJlYWRvbmx5IGJ1Y2tldDogczMuSUJ1Y2tldDtcbiAgICByZWFkb25seSBmaWxlS2V5OiBzdHJpbmc7XG4gICAgcmVhZG9ubHkgb2JqZWN0VmVyc2lvbj86IHN0cmluZztcbn1cbmNsYXNzIEJ1Y2tldEFwcGxpY2F0aW9uQ29kZSBleHRlbmRzIEFwcGxpY2F0aW9uQ29kZSB7XG4gICAgcHVibGljIHJlYWRvbmx5IGJ1Y2tldD86IHMzLklCdWNrZXQ7XG4gICAgcHVibGljIHJlYWRvbmx5IGZpbGVLZXk6IHN0cmluZztcbiAgICBwdWJsaWMgcmVhZG9ubHkgb2JqZWN0VmVyc2lvbj86IHN0cmluZztcbiAgICBjb25zdHJ1Y3Rvcihwcm9wczogQnVja2V0QXBwbGljYXRpb25Db2RlUHJvcHMpIHtcbiAgICAgICAgc3VwZXIoKTtcbiAgICAgICAgdGhpcy5idWNrZXQgPSBwcm9wcy5idWNrZXQ7XG4gICAgICAgIHRoaXMuZmlsZUtleSA9IHByb3BzLmZpbGVLZXk7XG4gICAgICAgIHRoaXMub2JqZWN0VmVyc2lvbiA9IHByb3BzLm9iamVjdFZlcnNpb247XG4gICAgfVxuICAgIHB1YmxpYyBiaW5kKF9zY29wZTogQ29uc3RydWN0KTogQXBwbGljYXRpb25Db2RlQ29uZmlnIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGFwcGxpY2F0aW9uQ29kZUNvbmZpZ3VyYXRpb25Qcm9wZXJ0eToge1xuICAgICAgICAgICAgICAgIGFwcGxpY2F0aW9uQ29kZUNvbmZpZ3VyYXRpb246IHtcbiAgICAgICAgICAgICAgICAgICAgY29kZUNvbnRlbnQ6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHMzQ29udGVudExvY2F0aW9uOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgYnVja2V0QXJuOiB0aGlzLmJ1Y2tldCEuYnVja2V0QXJuLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGZpbGVLZXk6IHRoaXMuZmlsZUtleSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBvYmplY3RWZXJzaW9uOiB0aGlzLm9iamVjdFZlcnNpb24sXG4gICAgICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgICAgICAgICBjb2RlQ29udGVudFR5cGU6ICdaSVBGSUxFJyxcbiAgICAgICAgICAgICAgICB9LFxuICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIGJ1Y2tldDogdGhpcy5idWNrZXQhLFxuICAgICAgICB9O1xuICAgIH1cbn1cbmNsYXNzIEFzc2V0QXBwbGljYXRpb25Db2RlIGV4dGVuZHMgQXBwbGljYXRpb25Db2RlIHtcbiAgICBwcml2YXRlIHJlYWRvbmx5IHBhdGg6IHN0cmluZztcbiAgICBwcml2YXRlIHJlYWRvbmx5IG9wdGlvbnM/OiBzM19hc3NldHMuQXNzZXRPcHRpb25zO1xuICAgIHByaXZhdGUgX2Fzc2V0PzogczNfYXNzZXRzLkFzc2V0O1xuICAgIGNvbnN0cnVjdG9yKHBhdGg6IHN0cmluZywgb3B0aW9ucz86IHMzX2Fzc2V0cy5Bc3NldE9wdGlvbnMpIHtcbiAgICAgICAgc3VwZXIoKTtcbiAgICAgICAgdGhpcy5wYXRoID0gcGF0aDtcbiAgICAgICAgdGhpcy5vcHRpb25zID0gb3B0aW9ucztcbiAgICB9XG4gICAgcHVibGljIGJpbmQoc2NvcGU6IENvbnN0cnVjdCk6IEFwcGxpY2F0aW9uQ29kZUNvbmZpZyB7XG4gICAgICAgIHRoaXMuX2Fzc2V0ID0gbmV3IHMzX2Fzc2V0cy5Bc3NldChzY29wZSwgJ0NvZGUnLCB7XG4gICAgICAgICAgICBwYXRoOiB0aGlzLnBhdGgsXG4gICAgICAgICAgICAuLi50aGlzLm9wdGlvbnMsXG4gICAgICAgIH0pO1xuICAgICAgICBpZiAoIXRoaXMuX2Fzc2V0LmlzWmlwQXJjaGl2ZSkge1xuICAgICAgICAgICAgdGhyb3cgbmV3IEVycm9yKGBBc3NldCBtdXN0IGJlIGEgLnppcCBmaWxlIG9yIGEgZGlyZWN0b3J5ICgke3RoaXMucGF0aH0pYCk7XG4gICAgICAgIH1cbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGFwcGxpY2F0aW9uQ29kZUNvbmZpZ3VyYXRpb25Qcm9wZXJ0eToge1xuICAgICAgICAgICAgICAgIGFwcGxpY2F0aW9uQ29kZUNvbmZpZ3VyYXRpb246IHtcbiAgICAgICAgICAgICAgICAgICAgY29kZUNvbnRlbnQ6IHtcbiAgICAgICAgICAgICAgICAgICAgICAgIHMzQ29udGVudExvY2F0aW9uOiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgYnVja2V0QXJuOiB0aGlzLl9hc3NldC5idWNrZXQuYnVja2V0QXJuLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGZpbGVLZXk6IHRoaXMuX2Fzc2V0LnMzT2JqZWN0S2V5LFxuICAgICAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgICAgICAgICAgY29kZUNvbnRlbnRUeXBlOiAnWklQRklMRScsXG4gICAgICAgICAgICAgICAgfSxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgICBidWNrZXQ6IHRoaXMuX2Fzc2V0LmJ1Y2tldCxcbiAgICAgICAgfTtcbiAgICB9XG4gICAgZ2V0IGFzc2V0KCk6IHMzX2Fzc2V0cy5Bc3NldCB8IHVuZGVmaW5lZCB7XG4gICAgICAgIHJldHVybiB0aGlzLl9hc3NldDtcbiAgICB9XG4gICAgZ2V0IGJ1Y2tldCgpOiBzMy5JQnVja2V0IHwgdW5kZWZpbmVkIHtcbiAgICAgICAgcmV0dXJuIHRoaXMuX2Fzc2V0Py5idWNrZXQ7XG4gICAgfVxufVxuIl19