import * as ka from "../../aws-kinesisanalytics";
import * as s3 from "../../aws-s3";
import * as s3_assets from "../../aws-s3-assets";
import { Construct } from "../../core";
/**
 * (experimental) The return type of {@link ApplicationCode.bind}. This represents CloudFormation configuration and an s3 bucket holding the Flink application JAR file.
 *
 * @experimental
 */
export interface ApplicationCodeConfig {
    /**
     * (experimental) Low-level Cloudformation ApplicationConfigurationProperty.
     *
     * @experimental
     */
    readonly applicationCodeConfigurationProperty: ka.CfnApplicationV2.ApplicationConfigurationProperty;
    /**
     * (experimental) S3 Bucket that stores the Flink application code.
     *
     * @experimental
     */
    readonly bucket: s3.IBucket;
}
/**
 * (experimental) Code configuration providing the location to a Flink application JAR file.
 *
 * @experimental
 */
export declare abstract class ApplicationCode {
    /**
     * (experimental) Reference code from an S3 bucket.
     *
     * @param bucket - an s3 bucket.
     * @param fileKey - a key pointing to a Flink JAR file.
     * @param objectVersion - an optional version string for the provided fileKey.
     * @experimental
     */
    static fromBucket(bucket: s3.IBucket, fileKey: string, objectVersion?: string): ApplicationCode;
    /**
     * (experimental) Reference code from a local directory containing a Flink JAR file.
     *
     * @param path - a local directory path.
     * @experimental
     * @parm options - standard s3 AssetOptions
     */
    static fromAsset(path: string, options?: s3_assets.AssetOptions): ApplicationCode;
    /**
     * (experimental) A method to lazily bind asset resources to the parent FlinkApplication.
     *
     * @experimental
     */
    abstract bind(scope: Construct): ApplicationCodeConfig;
}
