import * as cloudwatch from "../../aws-cloudwatch";
import * as iam from "../../aws-iam";
import * as kms from "../../aws-kms";
import { Duration, IResource, Resource } from "../../core";
import { Construct } from 'constructs';
/**
 * (experimental) A Kinesis Stream.
 *
 * @experimental
 */
export interface IStream extends IResource {
    /**
     * (experimental) The ARN of the stream.
     *
     * @experimental
     * @attribute true
     */
    readonly streamArn: string;
    /**
     * (experimental) The name of the stream.
     *
     * @experimental
     * @attribute true
     */
    readonly streamName: string;
    /**
     * (experimental) Optional KMS encryption key associated with this stream.
     *
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) Grant read permissions for this stream and its contents to an IAM principal (Role/Group/User).
     *
     * If an encryption key is used, permission to ues the key to decrypt the
     * contents of the stream will also be granted.
     *
     * @experimental
     */
    grantRead(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant write permissions for this stream and its contents to an IAM principal (Role/Group/User).
     *
     * If an encryption key is used, permission to ues the key to encrypt the
     * contents of the stream will also be granted.
     *
     * @experimental
     */
    grantWrite(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grants read/write permissions for this stream and its contents to an IAM principal (Role/Group/User).
     *
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     *
     * @experimental
     */
    grantReadWrite(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant the indicated permissions on this stream to the provided IAM principal.
     *
     * @experimental
     */
    grant(grantee: iam.IGrantable, ...actions: string[]): iam.Grant;
    /**
     * (experimental) Return stream metric based from its metric name.
     *
     * @param metricName name of the stream metric.
     * @param props properties of the metric.
     * @experimental
     */
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of bytes retrieved from the Kinesis stream, measured over the specified time period.
     *
     * Minimum, Maximum,
     * and Average statistics represent the bytes in a single GetRecords operation for the stream in the specified time
     * period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricGetRecordsBytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The age of the last record in all GetRecords calls made against a Kinesis stream, measured over the specified time period.
     *
     * Age is the difference between the current time and when the last record of the GetRecords call was written
     * to the stream. The Minimum and Maximum statistics can be used to track the progress of Kinesis consumer
     * applications. A value of zero indicates that the records being read are completely caught up with the stream.
     *
     * The metric defaults to maximum over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricGetRecordsIteratorAgeMilliseconds(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The time taken per GetRecords operation, measured over the specified time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricGetRecordsLatency(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of records retrieved from the shard, measured over the specified time period.
     *
     * Minimum, Maximum, and
     * Average statistics represent the records in a single GetRecords operation for the stream in the specified time
     * period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricGetRecords(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of successful GetRecords operations per stream, measured over the specified time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricGetRecordsSuccess(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of bytes successfully put to the Kinesis stream over the specified time period.
     *
     * This metric includes
     * bytes from PutRecord and PutRecords operations. Minimum, Maximum, and Average statistics represent the bytes in a
     * single put operation for the stream in the specified time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricIncomingBytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of records successfully put to the Kinesis stream over the specified time period.
     *
     * This metric includes
     * record counts from PutRecord and PutRecords operations. Minimum, Maximum, and Average statistics represent the
     * records in a single put operation for the stream in the specified time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricIncomingRecords(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of bytes put to the Kinesis stream using the PutRecord operation over the specified time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricPutRecordBytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The time taken per PutRecord operation, measured over the specified time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricPutRecordLatency(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of successful PutRecord operations per Kinesis stream, measured over the specified time period.
     *
     * Average
     * reflects the percentage of successful writes to a stream.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricPutRecordSuccess(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of bytes put to the Kinesis stream using the PutRecords operation over the specified time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricPutRecordsBytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The time taken per PutRecords operation, measured over the specified time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricPutRecordsLatency(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of PutRecords operations where at least one record succeeded, per Kinesis stream, measured over the specified time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricPutRecordsSuccess(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The total number of records sent in a PutRecords operation per Kinesis data stream, measured over the specified time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricPutRecordsTotalRecords(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of successful records in a PutRecords operation per Kinesis data stream, measured over the specified time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricPutRecordsSuccessfulRecords(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of records rejected due to internal failures in a PutRecords operation per Kinesis data stream, measured over the specified time period.
     *
     * Occasional internal failures are to be expected and should be retried.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricPutRecordsFailedRecords(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of records rejected due to throttling in a PutRecords operation per Kinesis data stream, measured over the specified time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricPutRecordsThrottledRecords(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of GetRecords calls throttled for the stream over the specified time period.
     *
     * The most commonly used
     * statistic for this metric is Average.
     *
     * When the Minimum statistic has a value of 1, all records were throttled for the stream during the specified time
     * period.
     *
     * When the Maximum statistic has a value of 0 (zero), no records were throttled for the stream during the specified
     * time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricReadProvisionedThroughputExceeded(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of records rejected due to throttling for the stream over the specified time period.
     *
     * This metric
     * includes throttling from PutRecord and PutRecords operations.
     *
     * When the Minimum statistic has a non-zero value, records were being throttled for the stream during the specified
     * time period.
     *
     * When the Maximum statistic has a value of 0 (zero), no records were being throttled for the stream during the
     * specified time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricWriteProvisionedThroughputExceeded(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
}
/**
 * (experimental) A reference to a stream.
 *
 * The easiest way to instantiate is to call
 * `stream.export()`. Then, the consumer can use `Stream.import(this, ref)` and
 * get a `Stream`.
 *
 * @experimental
 */
export interface StreamAttributes {
    /**
     * (experimental) The ARN of the stream.
     *
     * @experimental
     */
    readonly streamArn: string;
    /**
     * (experimental) The KMS key securing the contents of the stream if encryption is enabled.
     *
     * @default - No encryption
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
}
/**
 * Represents a Kinesis Stream.
 */
declare abstract class StreamBase extends Resource implements IStream {
    /**
     * The ARN of the stream.
     */
    abstract readonly streamArn: string;
    /**
     * The name of the stream
     */
    abstract readonly streamName: string;
    /**
     * Optional KMS encryption key associated with this stream.
     */
    abstract readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) Grant read permissions for this stream and its contents to an IAM principal (Role/Group/User).
     *
     * If an encryption key is used, permission to ues the key to decrypt the
     * contents of the stream will also be granted.
     *
     * @experimental
     */
    grantRead(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant write permissions for this stream and its contents to an IAM principal (Role/Group/User).
     *
     * If an encryption key is used, permission to ues the key to encrypt the
     * contents of the stream will also be granted.
     *
     * @experimental
     */
    grantWrite(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grants read/write permissions for this stream and its contents to an IAM principal (Role/Group/User).
     *
     * If an encryption key is used, permission to use the key for
     * encrypt/decrypt will also be granted.
     *
     * @experimental
     */
    grantReadWrite(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Grant the indicated permissions on this stream to the given IAM principal (Role/Group/User).
     *
     * @experimental
     */
    grant(grantee: iam.IGrantable, ...actions: string[]): iam.Grant;
    /**
     * (experimental) Return stream metric based from its metric name.
     *
     * @param metricName name of the stream metric.
     * @param props properties of the metric.
     * @experimental
     */
    metric(metricName: string, props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of bytes retrieved from the Kinesis stream, measured over the specified time period.
     *
     * Minimum, Maximum,
     * and Average statistics represent the bytes in a single GetRecords operation for the stream in the specified time
     * period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricGetRecordsBytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The age of the last record in all GetRecords calls made against a Kinesis stream, measured over the specified time period.
     *
     * Age is the difference between the current time and when the last record of the GetRecords call was written
     * to the stream. The Minimum and Maximum statistics can be used to track the progress of Kinesis consumer
     * applications. A value of zero indicates that the records being read are completely caught up with the stream.
     *
     * The metric defaults to maximum over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricGetRecordsIteratorAgeMilliseconds(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of successful GetRecords operations per stream, measured over the specified time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricGetRecordsSuccess(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of records retrieved from the shard, measured over the specified time period.
     *
     * Minimum, Maximum, and
     * Average statistics represent the records in a single GetRecords operation for the stream in the specified time
     * period.
     *
     * average
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricGetRecords(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of successful GetRecords operations per stream, measured over the specified time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricGetRecordsLatency(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of bytes put to the Kinesis stream using the PutRecord operation over the specified time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricPutRecordBytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The time taken per PutRecord operation, measured over the specified time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricPutRecordLatency(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of successful PutRecord operations per Kinesis stream, measured over the specified time period.
     *
     * Average
     * reflects the percentage of successful writes to a stream.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricPutRecordSuccess(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of bytes put to the Kinesis stream using the PutRecords operation over the specified time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricPutRecordsBytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The time taken per PutRecords operation, measured over the specified time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricPutRecordsLatency(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of PutRecords operations where at least one record succeeded, per Kinesis stream, measured over the specified time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricPutRecordsSuccess(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The total number of records sent in a PutRecords operation per Kinesis data stream, measured over the specified time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricPutRecordsTotalRecords(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of successful records in a PutRecords operation per Kinesis data stream, measured over the specified time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricPutRecordsSuccessfulRecords(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of records rejected due to internal failures in a PutRecords operation per Kinesis data stream, measured over the specified time period.
     *
     * Occasional internal failures are to be expected and should be retried.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricPutRecordsFailedRecords(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of records rejected due to throttling in a PutRecords operation per Kinesis data stream, measured over the specified time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricPutRecordsThrottledRecords(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of bytes successfully put to the Kinesis stream over the specified time period.
     *
     * This metric includes
     * bytes from PutRecord and PutRecords operations. Minimum, Maximum, and Average statistics represent the bytes in a
     * single put operation for the stream in the specified time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricIncomingBytes(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of records successfully put to the Kinesis stream over the specified time period.
     *
     * This metric includes
     * record counts from PutRecord and PutRecords operations. Minimum, Maximum, and Average statistics represent the
     * records in a single put operation for the stream in the specified time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricIncomingRecords(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of GetRecords calls throttled for the stream over the specified time period.
     *
     * The most commonly used
     * statistic for this metric is Average.
     *
     * When the Minimum statistic has a value of 1, all records were throttled for the stream during the specified time
     * period.
     *
     * When the Maximum statistic has a value of 0 (zero), no records were throttled for the stream during the specified
     * time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricReadProvisionedThroughputExceeded(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    /**
     * (experimental) The number of records rejected due to throttling for the stream over the specified time period.
     *
     * This metric
     * includes throttling from PutRecord and PutRecords operations.
     *
     * When the Minimum statistic has a non-zero value, records were being throttled for the stream during the specified
     * time period.
     *
     * When the Maximum statistic has a value of 0 (zero), no records were being throttled for the stream during the
     * specified time period.
     *
     * The metric defaults to average over 5 minutes, it can be changed by passing `statistic` and `period` properties.
     *
     * @param props properties of the metric.
     * @experimental
     */
    metricWriteProvisionedThroughputExceeded(props?: cloudwatch.MetricOptions): cloudwatch.Metric;
    private metricFromCannedFunction;
}
/**
 * (experimental) Properties for a Kinesis Stream.
 *
 * @experimental
 */
export interface StreamProps {
    /**
     * (experimental) Enforces a particular physical stream name.
     *
     * @default <generated>
     * @experimental
     */
    readonly streamName?: string;
    /**
     * (experimental) The number of hours for the data records that are stored in shards to remain accessible.
     *
     * @default Duration.hours(24)
     * @experimental
     */
    readonly retentionPeriod?: Duration;
    /**
     * (experimental) The number of shards for the stream.
     *
     * @default 1
     * @experimental
     */
    readonly shardCount?: number;
    /**
     * (experimental) The kind of server-side encryption to apply to this stream.
     *
     * If you choose KMS, you can specify a KMS key via `encryptionKey`. If
     * encryption key is not specified, a key will automatically be created.
     *
     * @default - StreamEncryption.KMS if encrypted Streams are supported in the region
     * or StreamEncryption.UNENCRYPTED otherwise.
     * StreamEncryption.KMS if an encryption key is supplied through the encryptionKey property
     * @experimental
     */
    readonly encryption?: StreamEncryption;
    /**
     * (experimental) External KMS key to use for stream encryption.
     *
     * The 'encryption' property must be set to "Kms".
     *
     * @default - Kinesis Data Streams master key ('/alias/aws/kinesis').
     * If encryption is set to StreamEncryption.KMS and this property is undefined, a new KMS key
     * will be created and associated with this stream.
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
}
/**
 * (experimental) A Kinesis stream.
 *
 * Can be encrypted with a KMS key.
 *
 * @experimental
 */
export declare class Stream extends StreamBase {
    /**
     * (experimental) Import an existing Kinesis Stream provided an ARN.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param streamArn Stream ARN (i.e. arn:aws:kinesis:<region>:<account-id>:stream/Foo).
     * @experimental
     */
    static fromStreamArn(scope: Construct, id: string, streamArn: string): IStream;
    /**
     * (experimental) Creates a Stream construct that represents an external stream.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param attrs Stream import properties.
     * @experimental
     */
    static fromStreamAttributes(scope: Construct, id: string, attrs: StreamAttributes): IStream;
    /**
     * (experimental) The ARN of the stream.
     *
     * @experimental
     */
    readonly streamArn: string;
    /**
     * (experimental) The name of the stream.
     *
     * @experimental
     */
    readonly streamName: string;
    /**
     * (experimental) Optional KMS encryption key associated with this stream.
     *
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    private readonly stream;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: StreamProps);
    /**
     * Set up key properties and return the Stream encryption property from the
     * user's configuration.
     */
    private parseEncryption;
}
/**
 * (experimental) What kind of server-side encryption to apply to this stream.
 *
 * @experimental
 */
export declare enum StreamEncryption {
    /**
     * (experimental) Records in the stream are not encrypted.
     *
     * @experimental
     */
    UNENCRYPTED = "NONE",
    /**
     * (experimental) Server-side encryption with a KMS key managed by the user.
     *
     * If `encryptionKey` is specified, this key will be used, otherwise, one will be defined.
     *
     * @experimental
     */
    KMS = "KMS",
    /**
     * (experimental) Server-side encryption with a master key managed by Amazon Kinesis.
     *
     * @experimental
     */
    MANAGED = "MANAGED"
}
export {};
