"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisMetrics = void 0;
const kinesis_canned_metrics_generated_1 = require("./kinesis-canned-metrics.generated");
/**
 * This class is to consolidate all the metrics from Stream in just one place.
 *
 * Current generated canned metrics don't match the proper metrics from the service. If it is fixed
 * at the source this class can be removed and just use the generated one directly.
 *
 * Stream Metrics reference: https://docs.aws.amazon.com/streams/latest/dev/monitoring-with-cloudwatch.html
 */
class KinesisMetrics {
    static getRecordsBytesAverage(dimensions) {
        return {
            namespace: 'AWS/Kinesis',
            metricName: 'GetRecords.Bytes',
            dimensions,
            statistic: 'Average',
        };
    }
    static getRecordsSuccessAverage(dimensions) {
        return {
            namespace: 'AWS/Kinesis',
            metricName: 'GetRecords.Success',
            dimensions,
            statistic: 'Average',
        };
    }
    static getRecordsRecordsAverage(dimensions) {
        return {
            namespace: 'AWS/Kinesis',
            metricName: 'GetRecords.Records',
            dimensions,
            statistic: 'Average',
        };
    }
    static getRecordsLatencyAverage(dimensions) {
        return {
            namespace: 'AWS/Kinesis',
            metricName: 'GetRecords.Latency',
            dimensions,
            statistic: 'Average',
        };
    }
    static putRecordBytesAverage(dimensions) {
        return {
            namespace: 'AWS/Kinesis',
            metricName: 'PutRecord.Bytes',
            dimensions,
            statistic: 'Average',
        };
    }
    static putRecordLatencyAverage(dimensions) {
        return {
            namespace: 'AWS/Kinesis',
            metricName: 'PutRecord.Latency',
            dimensions,
            statistic: 'Average',
        };
    }
    static getRecordsIteratorAgeMillisecondsMaximum(dimensions) {
        return kinesis_canned_metrics_generated_1.KinesisMetrics.getRecordsIteratorAgeMillisecondsMaximum(dimensions);
    }
    static putRecordSuccessAverage(dimensions) {
        return kinesis_canned_metrics_generated_1.KinesisMetrics.putRecordSuccessAverage(dimensions);
    }
    static putRecordsBytesAverage(dimensions) {
        return kinesis_canned_metrics_generated_1.KinesisMetrics.putRecordsBytesAverage(dimensions);
    }
    static putRecordsLatencyAverage(dimensions) {
        return {
            namespace: 'AWS/Kinesis',
            metricName: 'PutRecords.Latency',
            dimensions,
            statistic: 'Average',
        };
    }
    static putRecordsSuccessAverage(dimensions) {
        return {
            namespace: 'AWS/Kinesis',
            metricName: 'PutRecords.Success',
            dimensions,
            statistic: 'Average',
        };
    }
    static putRecordsTotalRecordsAverage(dimensions) {
        return {
            namespace: 'AWS/Kinesis',
            metricName: 'PutRecords.TotalRecords',
            dimensions,
            statistic: 'Average',
        };
    }
    static putRecordsSuccessfulRecordsAverage(dimensions) {
        return {
            namespace: 'AWS/Kinesis',
            metricName: 'PutRecords.SuccessfulRecords',
            dimensions,
            statistic: 'Average',
        };
    }
    static putRecordsFailedRecordsAverage(dimensions) {
        return {
            namespace: 'AWS/Kinesis',
            metricName: 'PutRecords.FailedRecords',
            dimensions,
            statistic: 'Average',
        };
    }
    static putRecordsThrottledRecordsAverage(dimensions) {
        return {
            namespace: 'AWS/Kinesis',
            metricName: 'PutRecords.ThrottledRecords',
            dimensions,
            statistic: 'Average',
        };
    }
    static incomingBytesAverage(dimensions) {
        return kinesis_canned_metrics_generated_1.KinesisMetrics.incomingBytesAverage(dimensions);
    }
    static incomingRecordsAverage(dimensions) {
        return kinesis_canned_metrics_generated_1.KinesisMetrics.incomingRecordsAverage(dimensions);
    }
    static readProvisionedThroughputExceededAverage(dimensions) {
        return kinesis_canned_metrics_generated_1.KinesisMetrics.readProvisionedThroughputExceededAverage(dimensions);
    }
    static writeProvisionedThroughputExceededAverage(dimensions) {
        return kinesis_canned_metrics_generated_1.KinesisMetrics.writeProvisionedThroughputExceededAverage(dimensions);
    }
}
exports.KinesisMetrics = KinesisMetrics;
//# sourceMappingURL=data:application/json;base64,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