import * as core from "../../core";
import { Construct } from 'constructs';
import { IChannel } from './channel';
/**
 * (experimental) Represents an IVS Stream Key.
 *
 * @experimental
 */
export interface IStreamKey extends core.IResource {
    /**
     * (experimental) The stream-key ARN.
     *
     * For example: arn:aws:ivs:us-west-2:123456789012:stream-key/g1H2I3j4k5L6
     *
     * @experimental
     * @attribute true
     */
    readonly streamKeyArn: string;
}
/**
 * (experimental) Properties for creating a new Stream Key.
 *
 * @experimental
 */
export interface StreamKeyProps {
    /**
     * (experimental) Channel ARN for the stream.
     *
     * @experimental
     */
    readonly channel: IChannel;
}
/**
 * (experimental) A new IVS Stream Key.
 *
 * @experimental
 */
export declare class StreamKey extends core.Resource implements IStreamKey {
    /**
     * (experimental) The stream-key ARN.
     *
     * For example: arn:aws:ivs:us-west-2:123456789012:stream-key/g1H2I3j4k5L6
     *
     * @experimental
     */
    readonly streamKeyArn: string;
    /**
     * (experimental) The stream-key value.
     *
     * For example: sk_us-west-2_abcdABCDefgh_567890abcdef
     *
     * @experimental
     * @attribute true
     */
    readonly streamKeyValue: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: StreamKeyProps);
}
