"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlaybackKeyPair = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const ivs_generated_1 = require("./ivs.generated");
/**
 * Reference to a new or existing IVS Playback Key Pair
 */
class PlaybackKeyPairBase extends core.Resource {
}
/**
 * (experimental) A new IVS Playback Key Pair.
 *
 * @experimental
 */
class PlaybackKeyPair extends PlaybackKeyPairBase {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, {});
        if (props.name && !core.Token.isUnresolved(props.name) && !/^[a-zA-Z0-9-_]*$/.test(props.name)) {
            throw new Error(`name must contain only numbers, letters, hyphens and underscores, got: '${props.name}'`);
        }
        const resource = new ivs_generated_1.CfnPlaybackKeyPair(this, 'Resource', {
            publicKeyMaterial: props.publicKeyMaterial,
            name: props.name,
        });
        this.playbackKeyPairArn = resource.attrArn;
        this.playbackKeyPairFingerprint = resource.attrFingerprint;
    }
}
exports.PlaybackKeyPair = PlaybackKeyPair;
_a = JSII_RTTI_SYMBOL_1;
PlaybackKeyPair[_a] = { fqn: "monocdk.aws_ivs.PlaybackKeyPair", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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