"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Channel = exports.ChannelType = exports.LatencyMode = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const ivs_generated_1 = require("./ivs.generated");
const stream_key_1 = require("./stream-key");
/**
 * Reference to a new or existing IVS Channel
 */
class ChannelBase extends core.Resource {
    /**
     * (experimental) Adds a stream key for this IVS Channel.
     *
     * @experimental
     */
    addStreamKey(id) {
        return new stream_key_1.StreamKey(this, id, {
            channel: this,
        });
    }
}
/**
 * (experimental) Channel latency mode.
 *
 * @experimental
 */
var LatencyMode;
(function (LatencyMode) {
    LatencyMode["LOW"] = "LOW";
    LatencyMode["NORMAL"] = "NORMAL";
})(LatencyMode = exports.LatencyMode || (exports.LatencyMode = {}));
/**
 * (experimental) The channel type, which determines the allowable resolution and bitrate.
 *
 * If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately.
 *
 * @experimental
 */
var ChannelType;
(function (ChannelType) {
    ChannelType["STANDARD"] = "STANDARD";
    ChannelType["BASIC"] = "BASIC";
})(ChannelType = exports.ChannelType || (exports.ChannelType = {}));
/**
 * (experimental) A new IVS channel.
 *
 * @experimental
 */
class Channel extends ChannelBase {
    /**
     * @experimental
     */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            physicalName: props.name,
        });
        if (props.name && !core.Token.isUnresolved(props.name) && !/^[a-zA-Z0-9-_]*$/.test(props.name)) {
            throw new Error(`name must contain only numbers, letters, hyphens and underscores, got: '${props.name}'`);
        }
        const resource = new ivs_generated_1.CfnChannel(this, 'Resource', {
            authorized: props.authorized,
            latencyMode: props.latencyMode,
            name: props.name,
            type: props.type,
        });
        this.channelArn = resource.attrArn;
        this.channelIngestEndpoint = resource.attrIngestEndpoint;
        this.channelPlaybackUrl = resource.attrPlaybackUrl;
    }
    /**
     * (experimental) Import an existing channel.
     *
     * @experimental
     */
    static fromChannelArn(scope, id, channelArn) {
        // This will throw an error if the arn cannot be parsed
        let arnComponents = core.Arn.parse(channelArn);
        if (!core.Token.isUnresolved(arnComponents.service) && arnComponents.service !== 'ivs') {
            throw new Error(`Invalid service, expected 'ivs', got '${arnComponents.service}'`);
        }
        if (!core.Token.isUnresolved(arnComponents.resource) && arnComponents.resource !== 'channel') {
            throw new Error(`Invalid resource, expected 'channel', got '${arnComponents.resource}'`);
        }
        class Import extends ChannelBase {
            constructor() {
                super(...arguments);
                this.channelArn = channelArn;
            }
        }
        return new Import(scope, id);
    }
}
exports.Channel = Channel;
_a = JSII_RTTI_SYMBOL_1;
Channel[_a] = { fqn: "monocdk.aws_ivs.Channel", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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