import * as core from "../../core";
import { Construct } from 'constructs';
import { StreamKey } from './stream-key';
/**
 * (experimental) Represents an IVS Channel.
 *
 * @experimental
 */
export interface IChannel extends core.IResource {
    /**
     * (experimental) The channel ARN.
     *
     * For example: arn:aws:ivs:us-west-2:123456789012:channel/abcdABCDefgh
     *
     * @experimental
     * @attribute true
     */
    readonly channelArn: string;
    /**
     * (experimental) Adds a stream key for this IVS Channel.
     *
     * @param id construct ID.
     * @experimental
     */
    addStreamKey(id: string): StreamKey;
}
/**
 * Reference to a new or existing IVS Channel
 */
declare abstract class ChannelBase extends core.Resource implements IChannel {
    abstract readonly channelArn: string;
    /**
     * (experimental) Adds a stream key for this IVS Channel.
     *
     * @experimental
     */
    addStreamKey(id: string): StreamKey;
}
/**
 * (experimental) Channel latency mode.
 *
 * @experimental
 */
export declare enum LatencyMode {
    /**
     * (experimental) Use LOW to minimize broadcaster-to-viewer latency for interactive broadcasts.
     *
     * @experimental
     */
    LOW = "LOW",
    /**
     * (experimental) Use NORMAL for broadcasts that do not require viewer interaction.
     *
     * @experimental
     */
    NORMAL = "NORMAL"
}
/**
 * (experimental) The channel type, which determines the allowable resolution and bitrate.
 *
 * If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately.
 *
 * @experimental
 */
export declare enum ChannelType {
    /**
     * (experimental) Multiple qualities are generated from the original input, to automatically give viewers the best experience for their devices and network conditions.
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html
     * @experimental
     */
    STANDARD = "STANDARD",
    /**
     * (experimental) delivers the original input to viewers.
     *
     * The viewer’s video-quality choice is limited to the original input.
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-channel.html
     * @experimental
     */
    BASIC = "BASIC"
}
/**
 * (experimental) Properties for creating a new Channel.
 *
 * @experimental
 */
export interface ChannelProps {
    /**
     * (experimental) Whether the channel is authorized.
     *
     * If you wish to make an authorized channel, you will need to ensure that
     * a PlaybackKeyPair has been uploaded to your account as this is used to
     * validate the signed JWT that is required for authorization
     *
     * @default false
     * @experimental
     */
    readonly authorized?: boolean;
    /**
     * (experimental) Channel latency mode.
     *
     * @default LatencyMode.LOW
     * @experimental
     */
    readonly latencyMode?: LatencyMode;
    /**
     * (experimental) Channel name.
     *
     * @default - None
     * @experimental
     */
    readonly name?: string;
    /**
     * (experimental) The channel type, which determines the allowable resolution and bitrate.
     *
     * If you exceed the allowable resolution or bitrate, the stream will disconnect immediately
     *
     * @default ChannelType.STANDARD
     * @experimental
     */
    readonly type?: ChannelType;
}
/**
 * (experimental) A new IVS channel.
 *
 * @experimental
 */
export declare class Channel extends ChannelBase {
    /**
     * (experimental) Import an existing channel.
     *
     * @experimental
     */
    static fromChannelArn(scope: Construct, id: string, channelArn: string): IChannel;
    /**
     * (experimental) The channel ARN.
     *
     * For example: arn:aws:ivs:us-west-2:123456789012:channel/abcdABCDefgh
     *
     * @experimental
     */
    readonly channelArn: string;
    /**
     * (experimental) Channel ingest endpoint, part of the definition of an ingest server, used when you set up streaming software.
     *
     * For example: a1b2c3d4e5f6.global-contribute.live-video.net
     *
     * @experimental
     * @attribute true
     */
    readonly channelIngestEndpoint: string;
    /**
     * (experimental) Channel playback URL.
     *
     * For example:
     * https://a1b2c3d4e5f6.us-west-2.playback.live-video.net/api/video/v1/us-west-2.123456789012.channel.abcdEFGH.m3u8
     *
     * @experimental
     * @attribute true
     */
    readonly channelPlaybackUrl: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: ChannelProps);
}
export {};
