import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::IoTEvents::DetectorModel`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export interface CfnDetectorModelProps {
    /**
     * `AWS::IoTEvents::DetectorModel.DetectorModelDefinition`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodeldefinition
     */
    readonly detectorModelDefinition: CfnDetectorModel.DetectorModelDefinitionProperty | cdk.IResolvable;
    /**
     * `AWS::IoTEvents::DetectorModel.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-rolearn
     */
    readonly roleArn: string;
    /**
     * `AWS::IoTEvents::DetectorModel.DetectorModelDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodeldescription
     */
    readonly detectorModelDescription?: string;
    /**
     * `AWS::IoTEvents::DetectorModel.DetectorModelName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodelname
     */
    readonly detectorModelName?: string;
    /**
     * `AWS::IoTEvents::DetectorModel.EvaluationMethod`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-evaluationmethod
     */
    readonly evaluationMethod?: string;
    /**
     * `AWS::IoTEvents::DetectorModel.Key`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-key
     */
    readonly key?: string;
    /**
     * `AWS::IoTEvents::DetectorModel.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export declare class CfnDetectorModel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTEvents::DetectorModel";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDetectorModel;
    /**
     * `AWS::IoTEvents::DetectorModel.DetectorModelDefinition`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodeldefinition
     */
    detectorModelDefinition: CfnDetectorModel.DetectorModelDefinitionProperty | cdk.IResolvable;
    /**
     * `AWS::IoTEvents::DetectorModel.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-rolearn
     */
    roleArn: string;
    /**
     * `AWS::IoTEvents::DetectorModel.DetectorModelDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodeldescription
     */
    detectorModelDescription: string | undefined;
    /**
     * `AWS::IoTEvents::DetectorModel.DetectorModelName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodelname
     */
    detectorModelName: string | undefined;
    /**
     * `AWS::IoTEvents::DetectorModel.EvaluationMethod`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-evaluationmethod
     */
    evaluationMethod: string | undefined;
    /**
     * `AWS::IoTEvents::DetectorModel.Key`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-key
     */
    key: string | undefined;
    /**
     * `AWS::IoTEvents::DetectorModel.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTEvents::DetectorModel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDetectorModelProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export declare namespace CfnDetectorModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html
     */
    interface ActionProperty {
        /**
         * `CfnDetectorModel.ActionProperty.ClearTimer`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-cleartimer
         */
        readonly clearTimer?: CfnDetectorModel.ClearTimerProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.DynamoDB`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-dynamodb
         */
        readonly dynamoDb?: CfnDetectorModel.DynamoDBProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.DynamoDBv2`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-dynamodbv2
         */
        readonly dynamoDBv2?: CfnDetectorModel.DynamoDBv2Property | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.Firehose`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-firehose
         */
        readonly firehose?: CfnDetectorModel.FirehoseProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.IotEvents`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-iotevents
         */
        readonly iotEvents?: CfnDetectorModel.IotEventsProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.IotSiteWise`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-iotsitewise
         */
        readonly iotSiteWise?: CfnDetectorModel.IotSiteWiseProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.IotTopicPublish`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-iottopicpublish
         */
        readonly iotTopicPublish?: CfnDetectorModel.IotTopicPublishProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.Lambda`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-lambda
         */
        readonly lambda?: CfnDetectorModel.LambdaProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.ResetTimer`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-resettimer
         */
        readonly resetTimer?: CfnDetectorModel.ResetTimerProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.SetTimer`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-settimer
         */
        readonly setTimer?: CfnDetectorModel.SetTimerProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.SetVariable`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-setvariable
         */
        readonly setVariable?: CfnDetectorModel.SetVariableProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.Sns`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-sns
         */
        readonly sns?: CfnDetectorModel.SnsProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.Sqs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-sqs
         */
        readonly sqs?: CfnDetectorModel.SqsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export declare namespace CfnDetectorModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertytimestamp.html
     */
    interface AssetPropertyTimestampProperty {
        /**
         * `CfnDetectorModel.AssetPropertyTimestampProperty.OffsetInNanos`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertytimestamp.html#cfn-iotevents-detectormodel-assetpropertytimestamp-offsetinnanos
         */
        readonly offsetInNanos?: string;
        /**
         * `CfnDetectorModel.AssetPropertyTimestampProperty.TimeInSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertytimestamp.html#cfn-iotevents-detectormodel-assetpropertytimestamp-timeinseconds
         */
        readonly timeInSeconds: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export declare namespace CfnDetectorModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvalue.html
     */
    interface AssetPropertyValueProperty {
        /**
         * `CfnDetectorModel.AssetPropertyValueProperty.Quality`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvalue.html#cfn-iotevents-detectormodel-assetpropertyvalue-quality
         */
        readonly quality?: string;
        /**
         * `CfnDetectorModel.AssetPropertyValueProperty.Timestamp`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvalue.html#cfn-iotevents-detectormodel-assetpropertyvalue-timestamp
         */
        readonly timestamp?: CfnDetectorModel.AssetPropertyTimestampProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.AssetPropertyValueProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvalue.html#cfn-iotevents-detectormodel-assetpropertyvalue-value
         */
        readonly value: CfnDetectorModel.AssetPropertyVariantProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export declare namespace CfnDetectorModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvariant.html
     */
    interface AssetPropertyVariantProperty {
        /**
         * `CfnDetectorModel.AssetPropertyVariantProperty.BooleanValue`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvariant.html#cfn-iotevents-detectormodel-assetpropertyvariant-booleanvalue
         */
        readonly booleanValue?: string;
        /**
         * `CfnDetectorModel.AssetPropertyVariantProperty.DoubleValue`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvariant.html#cfn-iotevents-detectormodel-assetpropertyvariant-doublevalue
         */
        readonly doubleValue?: string;
        /**
         * `CfnDetectorModel.AssetPropertyVariantProperty.IntegerValue`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvariant.html#cfn-iotevents-detectormodel-assetpropertyvariant-integervalue
         */
        readonly integerValue?: string;
        /**
         * `CfnDetectorModel.AssetPropertyVariantProperty.StringValue`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvariant.html#cfn-iotevents-detectormodel-assetpropertyvariant-stringvalue
         */
        readonly stringValue?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export declare namespace CfnDetectorModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-cleartimer.html
     */
    interface ClearTimerProperty {
        /**
         * `CfnDetectorModel.ClearTimerProperty.TimerName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-cleartimer.html#cfn-iotevents-detectormodel-cleartimer-timername
         */
        readonly timerName: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export declare namespace CfnDetectorModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-detectormodeldefinition.html
     */
    interface DetectorModelDefinitionProperty {
        /**
         * `CfnDetectorModel.DetectorModelDefinitionProperty.InitialStateName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-detectormodeldefinition.html#cfn-iotevents-detectormodel-detectormodeldefinition-initialstatename
         */
        readonly initialStateName: string;
        /**
         * `CfnDetectorModel.DetectorModelDefinitionProperty.States`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-detectormodeldefinition.html#cfn-iotevents-detectormodel-detectormodeldefinition-states
         */
        readonly states: Array<CfnDetectorModel.StateProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export declare namespace CfnDetectorModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html
     */
    interface DynamoDBProperty {
        /**
         * `CfnDetectorModel.DynamoDBProperty.HashKeyField`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-hashkeyfield
         */
        readonly hashKeyField: string;
        /**
         * `CfnDetectorModel.DynamoDBProperty.HashKeyType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-hashkeytype
         */
        readonly hashKeyType?: string;
        /**
         * `CfnDetectorModel.DynamoDBProperty.HashKeyValue`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-hashkeyvalue
         */
        readonly hashKeyValue: string;
        /**
         * `CfnDetectorModel.DynamoDBProperty.Operation`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-operation
         */
        readonly operation?: string;
        /**
         * `CfnDetectorModel.DynamoDBProperty.Payload`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-payload
         */
        readonly payload?: CfnDetectorModel.PayloadProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.DynamoDBProperty.PayloadField`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-payloadfield
         */
        readonly payloadField?: string;
        /**
         * `CfnDetectorModel.DynamoDBProperty.RangeKeyField`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-rangekeyfield
         */
        readonly rangeKeyField?: string;
        /**
         * `CfnDetectorModel.DynamoDBProperty.RangeKeyType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-rangekeytype
         */
        readonly rangeKeyType?: string;
        /**
         * `CfnDetectorModel.DynamoDBProperty.RangeKeyValue`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-rangekeyvalue
         */
        readonly rangeKeyValue?: string;
        /**
         * `CfnDetectorModel.DynamoDBProperty.TableName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-tablename
         */
        readonly tableName: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export declare namespace CfnDetectorModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodbv2.html
     */
    interface DynamoDBv2Property {
        /**
         * `CfnDetectorModel.DynamoDBv2Property.Payload`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodbv2.html#cfn-iotevents-detectormodel-dynamodbv2-payload
         */
        readonly payload?: CfnDetectorModel.PayloadProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.DynamoDBv2Property.TableName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodbv2.html#cfn-iotevents-detectormodel-dynamodbv2-tablename
         */
        readonly tableName: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export declare namespace CfnDetectorModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-event.html
     */
    interface EventProperty {
        /**
         * `CfnDetectorModel.EventProperty.Actions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-event.html#cfn-iotevents-detectormodel-event-actions
         */
        readonly actions?: Array<CfnDetectorModel.ActionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDetectorModel.EventProperty.Condition`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-event.html#cfn-iotevents-detectormodel-event-condition
         */
        readonly condition?: string;
        /**
         * `CfnDetectorModel.EventProperty.EventName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-event.html#cfn-iotevents-detectormodel-event-eventname
         */
        readonly eventName: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export declare namespace CfnDetectorModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-firehose.html
     */
    interface FirehoseProperty {
        /**
         * `CfnDetectorModel.FirehoseProperty.DeliveryStreamName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-firehose.html#cfn-iotevents-detectormodel-firehose-deliverystreamname
         */
        readonly deliveryStreamName: string;
        /**
         * `CfnDetectorModel.FirehoseProperty.Payload`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-firehose.html#cfn-iotevents-detectormodel-firehose-payload
         */
        readonly payload?: CfnDetectorModel.PayloadProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.FirehoseProperty.Separator`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-firehose.html#cfn-iotevents-detectormodel-firehose-separator
         */
        readonly separator?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export declare namespace CfnDetectorModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotevents.html
     */
    interface IotEventsProperty {
        /**
         * `CfnDetectorModel.IotEventsProperty.InputName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotevents.html#cfn-iotevents-detectormodel-iotevents-inputname
         */
        readonly inputName: string;
        /**
         * `CfnDetectorModel.IotEventsProperty.Payload`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotevents.html#cfn-iotevents-detectormodel-iotevents-payload
         */
        readonly payload?: CfnDetectorModel.PayloadProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export declare namespace CfnDetectorModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html
     */
    interface IotSiteWiseProperty {
        /**
         * `CfnDetectorModel.IotSiteWiseProperty.AssetId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html#cfn-iotevents-detectormodel-iotsitewise-assetid
         */
        readonly assetId?: string;
        /**
         * `CfnDetectorModel.IotSiteWiseProperty.EntryId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html#cfn-iotevents-detectormodel-iotsitewise-entryid
         */
        readonly entryId?: string;
        /**
         * `CfnDetectorModel.IotSiteWiseProperty.PropertyAlias`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html#cfn-iotevents-detectormodel-iotsitewise-propertyalias
         */
        readonly propertyAlias?: string;
        /**
         * `CfnDetectorModel.IotSiteWiseProperty.PropertyId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html#cfn-iotevents-detectormodel-iotsitewise-propertyid
         */
        readonly propertyId?: string;
        /**
         * `CfnDetectorModel.IotSiteWiseProperty.PropertyValue`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html#cfn-iotevents-detectormodel-iotsitewise-propertyvalue
         */
        readonly propertyValue: CfnDetectorModel.AssetPropertyValueProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export declare namespace CfnDetectorModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iottopicpublish.html
     */
    interface IotTopicPublishProperty {
        /**
         * `CfnDetectorModel.IotTopicPublishProperty.MqttTopic`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iottopicpublish.html#cfn-iotevents-detectormodel-iottopicpublish-mqtttopic
         */
        readonly mqttTopic: string;
        /**
         * `CfnDetectorModel.IotTopicPublishProperty.Payload`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iottopicpublish.html#cfn-iotevents-detectormodel-iottopicpublish-payload
         */
        readonly payload?: CfnDetectorModel.PayloadProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export declare namespace CfnDetectorModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-lambda.html
     */
    interface LambdaProperty {
        /**
         * `CfnDetectorModel.LambdaProperty.FunctionArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-lambda.html#cfn-iotevents-detectormodel-lambda-functionarn
         */
        readonly functionArn: string;
        /**
         * `CfnDetectorModel.LambdaProperty.Payload`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-lambda.html#cfn-iotevents-detectormodel-lambda-payload
         */
        readonly payload?: CfnDetectorModel.PayloadProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export declare namespace CfnDetectorModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-onenter.html
     */
    interface OnEnterProperty {
        /**
         * `CfnDetectorModel.OnEnterProperty.Events`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-onenter.html#cfn-iotevents-detectormodel-onenter-events
         */
        readonly events?: Array<CfnDetectorModel.EventProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export declare namespace CfnDetectorModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-onexit.html
     */
    interface OnExitProperty {
        /**
         * `CfnDetectorModel.OnExitProperty.Events`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-onexit.html#cfn-iotevents-detectormodel-onexit-events
         */
        readonly events?: Array<CfnDetectorModel.EventProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export declare namespace CfnDetectorModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-oninput.html
     */
    interface OnInputProperty {
        /**
         * `CfnDetectorModel.OnInputProperty.Events`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-oninput.html#cfn-iotevents-detectormodel-oninput-events
         */
        readonly events?: Array<CfnDetectorModel.EventProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDetectorModel.OnInputProperty.TransitionEvents`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-oninput.html#cfn-iotevents-detectormodel-oninput-transitionevents
         */
        readonly transitionEvents?: Array<CfnDetectorModel.TransitionEventProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export declare namespace CfnDetectorModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-payload.html
     */
    interface PayloadProperty {
        /**
         * `CfnDetectorModel.PayloadProperty.ContentExpression`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-payload.html#cfn-iotevents-detectormodel-payload-contentexpression
         */
        readonly contentExpression: string;
        /**
         * `CfnDetectorModel.PayloadProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-payload.html#cfn-iotevents-detectormodel-payload-type
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export declare namespace CfnDetectorModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-resettimer.html
     */
    interface ResetTimerProperty {
        /**
         * `CfnDetectorModel.ResetTimerProperty.TimerName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-resettimer.html#cfn-iotevents-detectormodel-resettimer-timername
         */
        readonly timerName: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export declare namespace CfnDetectorModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-settimer.html
     */
    interface SetTimerProperty {
        /**
         * `CfnDetectorModel.SetTimerProperty.DurationExpression`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-settimer.html#cfn-iotevents-detectormodel-settimer-durationexpression
         */
        readonly durationExpression?: string;
        /**
         * `CfnDetectorModel.SetTimerProperty.Seconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-settimer.html#cfn-iotevents-detectormodel-settimer-seconds
         */
        readonly seconds?: number;
        /**
         * `CfnDetectorModel.SetTimerProperty.TimerName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-settimer.html#cfn-iotevents-detectormodel-settimer-timername
         */
        readonly timerName: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export declare namespace CfnDetectorModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-setvariable.html
     */
    interface SetVariableProperty {
        /**
         * `CfnDetectorModel.SetVariableProperty.Value`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-setvariable.html#cfn-iotevents-detectormodel-setvariable-value
         */
        readonly value: string;
        /**
         * `CfnDetectorModel.SetVariableProperty.VariableName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-setvariable.html#cfn-iotevents-detectormodel-setvariable-variablename
         */
        readonly variableName: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export declare namespace CfnDetectorModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sns.html
     */
    interface SnsProperty {
        /**
         * `CfnDetectorModel.SnsProperty.Payload`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sns.html#cfn-iotevents-detectormodel-sns-payload
         */
        readonly payload?: CfnDetectorModel.PayloadProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.SnsProperty.TargetArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sns.html#cfn-iotevents-detectormodel-sns-targetarn
         */
        readonly targetArn: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export declare namespace CfnDetectorModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sqs.html
     */
    interface SqsProperty {
        /**
         * `CfnDetectorModel.SqsProperty.Payload`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sqs.html#cfn-iotevents-detectormodel-sqs-payload
         */
        readonly payload?: CfnDetectorModel.PayloadProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.SqsProperty.QueueUrl`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sqs.html#cfn-iotevents-detectormodel-sqs-queueurl
         */
        readonly queueUrl: string;
        /**
         * `CfnDetectorModel.SqsProperty.UseBase64`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sqs.html#cfn-iotevents-detectormodel-sqs-usebase64
         */
        readonly useBase64?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export declare namespace CfnDetectorModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-state.html
     */
    interface StateProperty {
        /**
         * `CfnDetectorModel.StateProperty.OnEnter`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-state.html#cfn-iotevents-detectormodel-state-onenter
         */
        readonly onEnter?: CfnDetectorModel.OnEnterProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.StateProperty.OnExit`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-state.html#cfn-iotevents-detectormodel-state-onexit
         */
        readonly onExit?: CfnDetectorModel.OnExitProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.StateProperty.OnInput`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-state.html#cfn-iotevents-detectormodel-state-oninput
         */
        readonly onInput?: CfnDetectorModel.OnInputProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.StateProperty.StateName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-state.html#cfn-iotevents-detectormodel-state-statename
         */
        readonly stateName: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 */
export declare namespace CfnDetectorModel {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-transitionevent.html
     */
    interface TransitionEventProperty {
        /**
         * `CfnDetectorModel.TransitionEventProperty.Actions`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-transitionevent.html#cfn-iotevents-detectormodel-transitionevent-actions
         */
        readonly actions?: Array<CfnDetectorModel.ActionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDetectorModel.TransitionEventProperty.Condition`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-transitionevent.html#cfn-iotevents-detectormodel-transitionevent-condition
         */
        readonly condition: string;
        /**
         * `CfnDetectorModel.TransitionEventProperty.EventName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-transitionevent.html#cfn-iotevents-detectormodel-transitionevent-eventname
         */
        readonly eventName: string;
        /**
         * `CfnDetectorModel.TransitionEventProperty.NextState`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-transitionevent.html#cfn-iotevents-detectormodel-transitionevent-nextstate
         */
        readonly nextState: string;
    }
}
/**
 * Properties for defining a `AWS::IoTEvents::Input`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html
 */
export interface CfnInputProps {
    /**
     * `AWS::IoTEvents::Input.InputDefinition`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-inputdefinition
     */
    readonly inputDefinition: CfnInput.InputDefinitionProperty | cdk.IResolvable;
    /**
     * `AWS::IoTEvents::Input.InputDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-inputdescription
     */
    readonly inputDescription?: string;
    /**
     * `AWS::IoTEvents::Input.InputName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-inputname
     */
    readonly inputName?: string;
    /**
     * `AWS::IoTEvents::Input.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTEvents::Input`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::Input
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html
 */
export declare class CfnInput extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTEvents::Input";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnInput;
    /**
     * `AWS::IoTEvents::Input.InputDefinition`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-inputdefinition
     */
    inputDefinition: CfnInput.InputDefinitionProperty | cdk.IResolvable;
    /**
     * `AWS::IoTEvents::Input.InputDescription`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-inputdescription
     */
    inputDescription: string | undefined;
    /**
     * `AWS::IoTEvents::Input.InputName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-inputname
     */
    inputName: string | undefined;
    /**
     * `AWS::IoTEvents::Input.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTEvents::Input`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnInputProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::IoTEvents::Input`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::Input
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html
 */
export declare namespace CfnInput {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-input-attribute.html
     */
    interface AttributeProperty {
        /**
         * `CfnInput.AttributeProperty.JsonPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-input-attribute.html#cfn-iotevents-input-attribute-jsonpath
         */
        readonly jsonPath: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::Input`.
 *
 * @external
 * @cloudformationResource AWS::IoTEvents::Input
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html
 */
export declare namespace CfnInput {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-input-inputdefinition.html
     */
    interface InputDefinitionProperty {
        /**
         * `CfnInput.InputDefinitionProperty.Attributes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-input-inputdefinition.html#cfn-iotevents-input-inputdefinition-attributes
         */
        readonly attributes: Array<CfnInput.AttributeProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
