import { Resource, SecretValue } from "../../core";
import { Construct } from 'constructs';
import { IGroup } from './group';
import { IIdentity } from './identity-base';
import { IManagedPolicy } from './managed-policy';
import { Policy } from './policy';
import { PolicyStatement } from './policy-statement';
import { AddToPrincipalPolicyResult, IPrincipal, PrincipalPolicyFragment } from './principals';
/**
 * (experimental) Represents an IAM user.
 *
 * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users.html
 * @experimental
 */
export interface IUser extends IIdentity {
    /**
     * (experimental) The user's name.
     *
     * @experimental
     * @attribute true
     */
    readonly userName: string;
    /**
     * (experimental) The user's ARN.
     *
     * @experimental
     * @attribute true
     */
    readonly userArn: string;
    /**
     * (experimental) Adds this user to a group.
     *
     * @experimental
     */
    addToGroup(group: IGroup): void;
}
/**
 * (experimental) Properties for defining an IAM user.
 *
 * @experimental
 */
export interface UserProps {
    /**
     * (experimental) Groups to add this user to.
     *
     * You can also use `addToGroup` to add this
     * user to a group.
     *
     * @default - No groups.
     * @experimental
     */
    readonly groups?: IGroup[];
    /**
     * (experimental) A list of managed policies associated with this role.
     *
     * You can add managed policies later using
     * `addManagedPolicy(ManagedPolicy.fromAwsManagedPolicyName(policyName))`.
     *
     * @default - No managed policies.
     * @experimental
     */
    readonly managedPolicies?: IManagedPolicy[];
    /**
     * (experimental) The path for the user name.
     *
     * For more information about paths, see IAM
     * Identifiers in the IAM User Guide.
     *
     * @default /
     * @experimental
     */
    readonly path?: string;
    /**
     * (experimental) AWS supports permissions boundaries for IAM entities (users or roles).
     *
     * A permissions boundary is an advanced feature for using a managed policy
     * to set the maximum permissions that an identity-based policy can grant to
     * an IAM entity. An entity's permissions boundary allows it to perform only
     * the actions that are allowed by both its identity-based policies and its
     * permissions boundaries.
     *
     * @default - No permissions boundary.
     * @experimental
     * @link https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html
     */
    readonly permissionsBoundary?: IManagedPolicy;
    /**
     * (experimental) A name for the IAM user.
     *
     * For valid values, see the UserName parameter for
     * the CreateUser action in the IAM API Reference. If you don't specify a
     * name, AWS CloudFormation generates a unique physical ID and uses that ID
     * for the user name.
     *
     * If you specify a name, you cannot perform updates that require
     * replacement of this resource. You can perform updates that require no or
     * some interruption. If you must replace the resource, specify a new name.
     *
     * If you specify a name, you must specify the CAPABILITY_NAMED_IAM value to
     * acknowledge your template's capabilities. For more information, see
     * Acknowledging IAM Resources in AWS CloudFormation Templates.
     *
     * @default - Generated by CloudFormation (recommended)
     * @experimental
     */
    readonly userName?: string;
    /**
     * (experimental) The password for the user. This is required so the user can access the AWS Management Console.
     *
     * You can use `SecretValue.plainText` to specify a password in plain text or
     * use `secretsmanager.Secret.fromSecretAttributes` to reference a secret in
     * Secrets Manager.
     *
     * @default - User won't be able to access the management console without a password.
     * @experimental
     */
    readonly password?: SecretValue;
    /**
     * (experimental) Specifies whether the user is required to set a new password the next time the user logs in to the AWS Management Console.
     *
     * If this is set to 'true', you must also specify "initialPassword".
     *
     * @default false
     * @experimental
     */
    readonly passwordResetRequired?: boolean;
}
/**
 * (experimental) Represents a user defined outside of this stack.
 *
 * @experimental
 */
export interface UserAttributes {
    /**
     * (experimental) The ARN of the user.
     *
     * Format: arn:<partition>:iam::<account-id>:user/<user-name-with-path>
     *
     * @experimental
     */
    readonly userArn: string;
}
/**
 * (experimental) Define a new IAM user.
 *
 * @experimental
 */
export declare class User extends Resource implements IIdentity, IUser {
    /**
     * (experimental) Import an existing user given a username.
     *
     * @param scope construct scope.
     * @param id construct id.
     * @param userName the username of the existing user to import.
     * @experimental
     */
    static fromUserName(scope: Construct, id: string, userName: string): IUser;
    /**
     * (experimental) Import an existing user given a user ARN.
     *
     * @param scope construct scope.
     * @param id construct id.
     * @param userArn the ARN of an existing user to import.
     * @experimental
     */
    static fromUserArn(scope: Construct, id: string, userArn: string): IUser;
    /**
     * (experimental) Import an existing user given user attributes.
     *
     * @param scope construct scope.
     * @param id construct id.
     * @param attrs the attributes of the user to import.
     * @experimental
     */
    static fromUserAttributes(scope: Construct, id: string, attrs: UserAttributes): IUser;
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    readonly grantPrincipal: IPrincipal;
    /**
     * (experimental) The AWS account ID of this principal.
     *
     * Can be undefined when the account is not known
     * (for example, for service principals).
     * Can be a Token - in that case,
     * it's assumed to be AWS::AccountId.
     *
     * @experimental
     */
    readonly principalAccount: string | undefined;
    /**
     * (experimental) When this Principal is used in an AssumeRole policy, the action to use.
     *
     * @experimental
     */
    readonly assumeRoleAction: string;
    /**
     * (experimental) An attribute that represents the user name.
     *
     * @experimental
     * @attribute true
     */
    readonly userName: string;
    /**
     * (experimental) An attribute that represents the user's ARN.
     *
     * @experimental
     * @attribute true
     */
    readonly userArn: string;
    /**
     * (experimental) Returns the permissions boundary attached  to this user.
     *
     * @experimental
     */
    readonly permissionsBoundary?: IManagedPolicy;
    /**
     * (experimental) Return the policy fragment that identifies this principal in a Policy.
     *
     * @experimental
     */
    readonly policyFragment: PrincipalPolicyFragment;
    private readonly groups;
    private readonly managedPolicies;
    private readonly attachedPolicies;
    private defaultPolicy?;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: UserProps);
    /**
     * (experimental) Adds this user to a group.
     *
     * @experimental
     */
    addToGroup(group: IGroup): void;
    /**
     * (experimental) Attaches a managed policy to the user.
     *
     * @param policy The managed policy to attach.
     * @experimental
     */
    addManagedPolicy(policy: IManagedPolicy): void;
    /**
     * (experimental) Attaches a policy to this user.
     *
     * @experimental
     */
    attachInlinePolicy(policy: Policy): void;
    /**
     * (experimental) Adds an IAM statement to the default policy.
     *
     * @returns true
     * @experimental
     */
    addToPrincipalPolicy(statement: PolicyStatement): AddToPrincipalPolicyResult;
    /**
     * (experimental) Add to the policy of this principal.
     *
     * @experimental
     */
    addToPolicy(statement: PolicyStatement): boolean;
    private parseLoginProfile;
}
