"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SamlProvider = exports.SamlMetadataDocument = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const iam_generated_1 = require("./iam.generated");
/**
 * (experimental) A SAML metadata document.
 *
 * @experimental
 */
class SamlMetadataDocument {
    /**
     * (experimental) Create a SAML metadata document from a XML string.
     *
     * @experimental
     */
    static fromXml(xml) {
        return { xml };
    }
    /**
     * (experimental) Create a SAML metadata document from a XML file.
     *
     * @experimental
     */
    static fromFile(path) {
        return { xml: fs.readFileSync(path, 'utf-8') };
    }
}
exports.SamlMetadataDocument = SamlMetadataDocument;
_a = JSII_RTTI_SYMBOL_1;
SamlMetadataDocument[_a] = { fqn: "monocdk.aws_iam.SamlMetadataDocument", version: "1.106.1" };
/**
 * (experimental) A SAML provider.
 *
 * @experimental
 */
class SamlProvider extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        if (props.name && !core_1.Token.isUnresolved(props.name) && !/^[\w+=,.@-]{1,128}$/.test(props.name)) {
            throw new Error('Invalid SAML provider name. The name must be a string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of the following characters: _+=,.@-. Length must be between 1 and 128 characters.');
        }
        const samlProvider = new iam_generated_1.CfnSAMLProvider(this, 'Resource', {
            name: props.name,
            samlMetadataDocument: props.metadataDocument.xml,
        });
        this.samlProviderArn = samlProvider.ref;
    }
    /**
     * (experimental) Import an existing provider.
     *
     * @experimental
     */
    static fromSamlProviderArn(scope, id, samlProviderArn) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.samlProviderArn = samlProviderArn;
            }
        }
        return new Import(scope, id);
    }
}
exports.SamlProvider = SamlProvider;
_b = JSII_RTTI_SYMBOL_1;
SamlProvider[_b] = { fqn: "monocdk.aws_iam.SamlProvider", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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