import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
/**
 * (experimental) A SAML provider.
 *
 * @experimental
 */
export interface ISamlProvider extends IResource {
    /**
     * (experimental) The Amazon Resource Name (ARN) of the provider.
     *
     * @experimental
     * @attribute true
     */
    readonly samlProviderArn: string;
}
/**
 * (experimental) Properties for a SAML provider.
 *
 * @experimental
 */
export interface SamlProviderProps {
    /**
     * (experimental) The name of the provider to create.
     *
     * This parameter allows a string of characters consisting of upper and
     * lowercase alphanumeric characters with no spaces. You can also include
     * any of the following characters: _+=,.@-
     *
     * Length must be between 1 and 128 characters.
     *
     * @default - a CloudFormation generated name
     * @experimental
     */
    readonly name?: string;
    /**
     * (experimental) An XML document generated by an identity provider (IdP) that supports SAML 2.0. The document includes the issuer's name, expiration information, and keys that can be used to validate the SAML authentication response (assertions) that are received from the IdP. You must generate the metadata document using the identity management software that is used as your organization's IdP.
     *
     * @experimental
     */
    readonly metadataDocument: SamlMetadataDocument;
}
/**
 * (experimental) A SAML metadata document.
 *
 * @experimental
 */
export declare abstract class SamlMetadataDocument {
    /**
     * (experimental) Create a SAML metadata document from a XML string.
     *
     * @experimental
     */
    static fromXml(xml: string): SamlMetadataDocument;
    /**
     * (experimental) Create a SAML metadata document from a XML file.
     *
     * @experimental
     */
    static fromFile(path: string): SamlMetadataDocument;
    /**
     * (experimental) The XML content of the metadata document.
     *
     * @experimental
     */
    abstract readonly xml: string;
}
/**
 * (experimental) A SAML provider.
 *
 * @experimental
 */
export declare class SamlProvider extends Resource implements ISamlProvider {
    /**
     * (experimental) Import an existing provider.
     *
     * @experimental
     */
    static fromSamlProviderArn(scope: Construct, id: string, samlProviderArn: string): ISamlProvider;
    /**
     * (experimental) The Amazon Resource Name (ARN) of the provider.
     *
     * @experimental
     */
    readonly samlProviderArn: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: SamlProviderProps);
}
