import * as cdk from "../../core";
import { IOpenIdConnectProvider } from './oidc-provider';
import { Condition, Conditions, PolicyStatement } from './policy-statement';
import { ISamlProvider } from './saml-provider';
/**
 * (experimental) Any object that has an associated principal that a permission can be granted to.
 *
 * @experimental
 */
export interface IGrantable {
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    readonly grantPrincipal: IPrincipal;
}
/**
 * (experimental) Represents a logical IAM principal.
 *
 * An IPrincipal describes a logical entity that can perform AWS API calls
 * against sets of resources, optionally under certain conditions.
 *
 * Examples of simple principals are IAM objects that you create, such
 * as Users or Roles.
 *
 * An example of a more complex principals is a `ServicePrincipal` (such as
 * `new ServicePrincipal("sns.amazonaws.com")`, which represents the Simple
 * Notifications Service).
 *
 * A single logical Principal may also map to a set of physical principals.
 * For example, `new OrganizationPrincipal('o-1234')` represents all
 * identities that are part of the given AWS Organization.
 *
 * @experimental
 */
export interface IPrincipal extends IGrantable {
    /**
     * (experimental) When this Principal is used in an AssumeRole policy, the action to use.
     *
     * @experimental
     */
    readonly assumeRoleAction: string;
    /**
     * (experimental) Return the policy fragment that identifies this principal in a Policy.
     *
     * @experimental
     */
    readonly policyFragment: PrincipalPolicyFragment;
    /**
     * (experimental) The AWS account ID of this principal.
     *
     * Can be undefined when the account is not known
     * (for example, for service principals).
     * Can be a Token - in that case,
     * it's assumed to be AWS::AccountId.
     *
     * @experimental
     */
    readonly principalAccount?: string;
    /**
     * (deprecated) Add to the policy of this principal.
     *
     * @returns true if the statement was added, false if the principal in
     * question does not have a policy document to add the statement to.
     * @deprecated Use `addToPrincipalPolicy` instead.
     */
    addToPolicy(statement: PolicyStatement): boolean;
    /**
     * (experimental) Add to the policy of this principal.
     *
     * @experimental
     */
    addToPrincipalPolicy(statement: PolicyStatement): AddToPrincipalPolicyResult;
}
/**
 * (experimental) Result of calling `addToPrincipalPolicy`.
 *
 * @experimental
 */
export interface AddToPrincipalPolicyResult {
    /**
     * (experimental) Whether the statement was added to the identity's policies.
     *
     * @experimental
     */
    readonly statementAdded: boolean;
    /**
     * (experimental) Dependable which allows depending on the policy change being applied.
     *
     * @default - Required if `statementAdded` is true.
     * @experimental
     */
    readonly policyDependable?: cdk.IDependable;
}
/**
 * (experimental) Base class for policy principals.
 *
 * @experimental
 */
export declare abstract class PrincipalBase implements IPrincipal {
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    readonly grantPrincipal: IPrincipal;
    /**
     * (experimental) The AWS account ID of this principal.
     *
     * Can be undefined when the account is not known
     * (for example, for service principals).
     * Can be a Token - in that case,
     * it's assumed to be AWS::AccountId.
     *
     * @experimental
     */
    readonly principalAccount: string | undefined;
    /**
     * (experimental) Return the policy fragment that identifies this principal in a Policy.
     *
     * @experimental
     */
    abstract readonly policyFragment: PrincipalPolicyFragment;
    /**
     * (experimental) When this Principal is used in an AssumeRole policy, the action to use.
     *
     * @experimental
     */
    readonly assumeRoleAction: string;
    /**
     * (experimental) Add to the policy of this principal.
     *
     * @experimental
     */
    addToPolicy(statement: PolicyStatement): boolean;
    /**
     * (experimental) Add to the policy of this principal.
     *
     * @experimental
     */
    addToPrincipalPolicy(_statement: PolicyStatement): AddToPrincipalPolicyResult;
    /**
     * (experimental) Returns a string representation of an object.
     *
     * @experimental
     */
    toString(): string;
    /**
     * (experimental) JSON-ify the principal.
     *
     * Used when JSON.stringify() is called
     *
     * @experimental
     */
    toJSON(): {
        [key: string]: string[];
    };
    /**
     * (experimental) Returns a new PrincipalWithConditions using this principal as the base, with the passed conditions added.
     *
     * When there is a value for the same operator and key in both the principal and the
     * conditions parameter, the value from the conditions parameter will be used.
     *
     * @returns a new PrincipalWithConditions object.
     * @experimental
     */
    withConditions(conditions: Conditions): IPrincipal;
}
/**
 * (experimental) An IAM principal with additional conditions specifying when the policy is in effect.
 *
 * For more information about conditions, see:
 * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html
 *
 * @experimental
 */
export declare class PrincipalWithConditions implements IPrincipal {
    private readonly principal;
    /**
     * (experimental) The principal to grant permissions to.
     *
     * @experimental
     */
    readonly grantPrincipal: IPrincipal;
    /**
     * (experimental) When this Principal is used in an AssumeRole policy, the action to use.
     *
     * @experimental
     */
    readonly assumeRoleAction: string;
    private additionalConditions;
    /**
     * @experimental
     */
    constructor(principal: IPrincipal, conditions: Conditions);
    /**
     * (experimental) Add a condition to the principal.
     *
     * @experimental
     */
    addCondition(key: string, value: Condition): void;
    /**
     * (experimental) Adds multiple conditions to the principal.
     *
     * Values from the conditions parameter will overwrite existing values with the same operator
     * and key.
     *
     * @experimental
     */
    addConditions(conditions: Conditions): void;
    /**
     * (experimental) The conditions under which the policy is in effect.
     *
     * See [the IAM documentation](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html).
     *
     * @experimental
     */
    get conditions(): Record<string, any>;
    /**
     * (experimental) Return the policy fragment that identifies this principal in a Policy.
     *
     * @experimental
     */
    get policyFragment(): PrincipalPolicyFragment;
    /**
     * (experimental) Add to the policy of this principal.
     *
     * @experimental
     */
    addToPolicy(statement: PolicyStatement): boolean;
    /**
     * (experimental) Add to the policy of this principal.
     *
     * @experimental
     */
    addToPrincipalPolicy(statement: PolicyStatement): AddToPrincipalPolicyResult;
    /**
     * (experimental) Returns a string representation of an object.
     *
     * @experimental
     */
    toString(): string;
    /**
     * (experimental) JSON-ify the principal.
     *
     * Used when JSON.stringify() is called
     *
     * @experimental
     */
    toJSON(): {
        [key: string]: string[];
    };
    private mergeConditions;
}
/**
 * (experimental) A collection of the fields in a PolicyStatement that can be used to identify a principal.
 *
 * This consists of the JSON used in the "Principal" field, and optionally a
 * set of "Condition"s that need to be applied to the policy.
 *
 * @experimental
 */
export declare class PrincipalPolicyFragment {
    readonly principalJson: {
        [key: string]: string[];
    };
    /**
     * The conditions under which the policy is in effect.
     * See [the IAM documentation](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html).
     */
    readonly conditions: Conditions;
    /**
     * @param principalJson JSON of the "Principal" section in a policy statement.
     * @param conditions The conditions under which the policy is in effect.
     * @experimental
     */
    constructor(principalJson: {
        [key: string]: string[];
    }, 
    /**
     * The conditions under which the policy is in effect.
     * See [the IAM documentation](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html).
     */
    conditions?: Conditions);
}
/**
 * (experimental) Specify a principal by the Amazon Resource Name (ARN).
 *
 * You can specify AWS accounts, IAM users, Federated SAML users, IAM roles, and specific assumed-role sessions.
 * You cannot specify IAM groups or instance profiles as principals
 *
 * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html
 * @experimental
 */
export declare class ArnPrincipal extends PrincipalBase {
    readonly arn: string;
    /**
     * @param arn Amazon Resource Name (ARN) of the principal entity (i.e. arn:aws:iam::123456789012:user/user-name).
     * @experimental
     */
    constructor(arn: string);
    /**
     * (experimental) Return the policy fragment that identifies this principal in a Policy.
     *
     * @experimental
     */
    get policyFragment(): PrincipalPolicyFragment;
    /**
     * (experimental) Returns a string representation of an object.
     *
     * @experimental
     */
    toString(): string;
}
/**
 * (experimental) Specify AWS account ID as the principal entity in a policy to delegate authority to the account.
 *
 * @experimental
 */
export declare class AccountPrincipal extends ArnPrincipal {
    readonly accountId: any;
    /**
     * @param accountId AWS account ID (i.e. 123456789012).
     * @experimental
     */
    constructor(accountId: any);
    /**
     * (experimental) Returns a string representation of an object.
     *
     * @experimental
     */
    toString(): string;
}
/**
 * (experimental) Options for a service principal.
 *
 * @experimental
 */
export interface ServicePrincipalOpts {
    /**
     * (experimental) The region in which the service is operating.
     *
     * @default the current Stack's region.
     * @experimental
     */
    readonly region?: string;
    /**
     * (experimental) Additional conditions to add to the Service Principal.
     *
     * @default - No conditions
     * @experimental
     */
    readonly conditions?: {
        [key: string]: any;
    };
}
/**
 * (experimental) An IAM principal that represents an AWS service (i.e. sqs.amazonaws.com).
 *
 * @experimental
 */
export declare class ServicePrincipal extends PrincipalBase {
    readonly service: string;
    private readonly opts;
    /**
     * @param service AWS service (i.e. sqs.amazonaws.com).
     * @experimental
     */
    constructor(service: string, opts?: ServicePrincipalOpts);
    /**
     * (experimental) Return the policy fragment that identifies this principal in a Policy.
     *
     * @experimental
     */
    get policyFragment(): PrincipalPolicyFragment;
    /**
     * (experimental) Returns a string representation of an object.
     *
     * @experimental
     */
    toString(): string;
}
/**
 * (experimental) A principal that represents an AWS Organization.
 *
 * @experimental
 */
export declare class OrganizationPrincipal extends PrincipalBase {
    readonly organizationId: string;
    /**
     * @param organizationId The unique identifier (ID) of an organization (i.e. o-12345abcde).
     * @experimental
     */
    constructor(organizationId: string);
    /**
     * (experimental) Return the policy fragment that identifies this principal in a Policy.
     *
     * @experimental
     */
    get policyFragment(): PrincipalPolicyFragment;
    /**
     * (experimental) Returns a string representation of an object.
     *
     * @experimental
     */
    toString(): string;
}
/**
 * (experimental) A policy principal for canonicalUserIds - useful for S3 bucket policies that use Origin Access identities.
 *
 * See https://docs.aws.amazon.com/general/latest/gr/acct-identifiers.html
 *
 * and
 *
 * https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html
 *
 * for more details.
 *
 * @experimental
 */
export declare class CanonicalUserPrincipal extends PrincipalBase {
    readonly canonicalUserId: string;
    /**
     * @param canonicalUserId unique identifier assigned by AWS for every account.
     * @experimental
     */
    constructor(canonicalUserId: string);
    /**
     * (experimental) Return the policy fragment that identifies this principal in a Policy.
     *
     * @experimental
     */
    get policyFragment(): PrincipalPolicyFragment;
    /**
     * (experimental) Returns a string representation of an object.
     *
     * @experimental
     */
    toString(): string;
}
/**
 * (experimental) Principal entity that represents a federated identity provider such as Amazon Cognito, that can be used to provide temporary security credentials to users who have been authenticated.
 *
 * Additional condition keys are available when the temporary security credentials are used to make a request.
 * You can use these keys to write policies that limit the access of federated users.
 *
 * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_iam-condition-keys.html#condition-keys-wif
 * @experimental
 */
export declare class FederatedPrincipal extends PrincipalBase {
    readonly federated: string;
    readonly conditions: Conditions;
    /**
     * (experimental) When this Principal is used in an AssumeRole policy, the action to use.
     *
     * @experimental
     */
    readonly assumeRoleAction: string;
    /**
     * @param federated federated identity provider (i.e. 'cognito-identity.amazonaws.com' for users authenticated through Cognito).
     * @param conditions The conditions under which the policy is in effect.
     * @experimental
     */
    constructor(federated: string, conditions: Conditions, assumeRoleAction?: string);
    /**
     * (experimental) Return the policy fragment that identifies this principal in a Policy.
     *
     * @experimental
     */
    get policyFragment(): PrincipalPolicyFragment;
    /**
     * (experimental) Returns a string representation of an object.
     *
     * @experimental
     */
    toString(): string;
}
/**
 * (experimental) A principal that represents a federated identity provider as Web Identity such as Cognito, Amazon, Facebook, Google, etc.
 *
 * @experimental
 */
export declare class WebIdentityPrincipal extends FederatedPrincipal {
    /**
     * @param identityProvider identity provider (i.e. 'cognito-identity.amazonaws.com' for users authenticated through Cognito).
     * @param conditions The conditions under which the policy is in effect.
     * @experimental
     */
    constructor(identityProvider: string, conditions?: Conditions);
    /**
     * (experimental) Return the policy fragment that identifies this principal in a Policy.
     *
     * @experimental
     */
    get policyFragment(): PrincipalPolicyFragment;
    /**
     * (experimental) Returns a string representation of an object.
     *
     * @experimental
     */
    toString(): string;
}
/**
 * (experimental) A principal that represents a federated identity provider as from a OpenID Connect provider.
 *
 * @experimental
 */
export declare class OpenIdConnectPrincipal extends WebIdentityPrincipal {
    /**
     * @param openIdConnectProvider OpenID Connect provider.
     * @param conditions The conditions under which the policy is in effect.
     * @experimental
     */
    constructor(openIdConnectProvider: IOpenIdConnectProvider, conditions?: Conditions);
    /**
     * (experimental) Return the policy fragment that identifies this principal in a Policy.
     *
     * @experimental
     */
    get policyFragment(): PrincipalPolicyFragment;
    /**
     * (experimental) Returns a string representation of an object.
     *
     * @experimental
     */
    toString(): string;
}
/**
 * (experimental) Principal entity that represents a SAML federated identity provider.
 *
 * @experimental
 */
export declare class SamlPrincipal extends FederatedPrincipal {
    /**
     * @experimental
     */
    constructor(samlProvider: ISamlProvider, conditions: Conditions);
    /**
     * (experimental) Returns a string representation of an object.
     *
     * @experimental
     */
    toString(): string;
}
/**
 * (experimental) Principal entity that represents a SAML federated identity provider for programmatic and AWS Management Console access.
 *
 * @experimental
 */
export declare class SamlConsolePrincipal extends SamlPrincipal {
    /**
     * @experimental
     */
    constructor(samlProvider: ISamlProvider, conditions?: Conditions);
    /**
     * (experimental) Returns a string representation of an object.
     *
     * @experimental
     */
    toString(): string;
}
/**
 * (experimental) Use the AWS account into which a stack is deployed as the principal entity in a policy.
 *
 * @experimental
 */
export declare class AccountRootPrincipal extends AccountPrincipal {
    /**
     * @experimental
     */
    constructor();
    /**
     * (experimental) Returns a string representation of an object.
     *
     * @experimental
     */
    toString(): string;
}
/**
 * (experimental) A principal representing all identities in all accounts.
 *
 * @experimental
 */
export declare class AnyPrincipal extends ArnPrincipal {
    /**
     * @experimental
     */
    constructor();
    /**
     * (experimental) Returns a string representation of an object.
     *
     * @experimental
     */
    toString(): string;
}
/**
 * (deprecated) A principal representing all identities in all accounts.
 *
 * @deprecated use `AnyPrincipal`
 */
export declare class Anyone extends AnyPrincipal {
}
/**
 * (experimental) Represents a principal that has multiple types of principals.
 *
 * A composite principal cannot
 * have conditions. i.e. multiple ServicePrincipals that form a composite principal
 *
 * @experimental
 */
export declare class CompositePrincipal extends PrincipalBase {
    /**
     * (experimental) When this Principal is used in an AssumeRole policy, the action to use.
     *
     * @experimental
     */
    readonly assumeRoleAction: string;
    private readonly principals;
    /**
     * @experimental
     */
    constructor(...principals: PrincipalBase[]);
    /**
     * (experimental) Adds IAM principals to the composite principal.
     *
     * Composite principals cannot have
     * conditions.
     *
     * @param principals IAM principals that will be added to the composite principal.
     * @experimental
     */
    addPrincipals(...principals: PrincipalBase[]): this;
    /**
     * (experimental) Return the policy fragment that identifies this principal in a Policy.
     *
     * @experimental
     */
    get policyFragment(): PrincipalPolicyFragment;
    /**
     * (experimental) Returns a string representation of an object.
     *
     * @experimental
     */
    toString(): string;
}
