import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { IGroup } from './group';
import { PolicyDocument } from './policy-document';
import { PolicyStatement } from './policy-statement';
import { IRole } from './role';
import { IUser } from './user';
/**
 * (experimental) Represents an IAM Policy.
 *
 * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_manage.html
 * @experimental
 */
export interface IPolicy extends IResource {
    /**
     * (experimental) The name of this policy.
     *
     * @experimental
     * @attribute true
     */
    readonly policyName: string;
}
/**
 * (experimental) Properties for defining an IAM inline policy document.
 *
 * @experimental
 */
export interface PolicyProps {
    /**
     * (experimental) The name of the policy.
     *
     * If you specify multiple policies for an entity,
     * specify unique names. For example, if you specify a list of policies for
     * an IAM role, each policy must have a unique name.
     *
     * @default - Uses the logical ID of the policy resource, which is ensured
     * to be unique within the stack.
     * @experimental
     */
    readonly policyName?: string;
    /**
     * (experimental) Users to attach this policy to.
     *
     * You can also use `attachToUser(user)` to attach this policy to a user.
     *
     * @default - No users.
     * @experimental
     */
    readonly users?: IUser[];
    /**
     * (experimental) Roles to attach this policy to.
     *
     * You can also use `attachToRole(role)` to attach this policy to a role.
     *
     * @default - No roles.
     * @experimental
     */
    readonly roles?: IRole[];
    /**
     * (experimental) Groups to attach this policy to.
     *
     * You can also use `attachToGroup(group)` to attach this policy to a group.
     *
     * @default - No groups.
     * @experimental
     */
    readonly groups?: IGroup[];
    /**
     * (experimental) Initial set of permissions to add to this policy document.
     *
     * You can also use `addStatements(...statement)` to add permissions later.
     *
     * @default - No statements.
     * @experimental
     */
    readonly statements?: PolicyStatement[];
    /**
     * (experimental) Force creation of an `AWS::IAM::Policy`.
     *
     * Unless set to `true`, this `Policy` construct will not materialize to an
     * `AWS::IAM::Policy` CloudFormation resource in case it would have no effect
     * (for example, if it remains unattached to an IAM identity or if it has no
     * statements). This is generally desired behavior, since it prevents
     * creating invalid--and hence undeployable--CloudFormation templates.
     *
     * In cases where you know the policy must be created and it is actually
     * an error if no statements have been added to it, you can set this to `true`.
     *
     * @default false
     * @experimental
     */
    readonly force?: boolean;
    /**
     * (experimental) Initial PolicyDocument to use for this Policy.
     *
     * If omited, any
     * `PolicyStatement` provided in the `statements` property will be applied
     * against the empty default `PolicyDocument`.
     *
     * @default - An empty policy.
     * @experimental
     */
    readonly document?: PolicyDocument;
}
/**
 * (experimental) The AWS::IAM::Policy resource associates an IAM policy with IAM users, roles, or groups.
 *
 * For more information about IAM policies, see [Overview of IAM
 * Policies](http://docs.aws.amazon.com/IAM/latest/UserGuide/policies_overview.html)
 * in the IAM User Guide guide.
 *
 * @experimental
 */
export declare class Policy extends Resource implements IPolicy {
    /**
     * (experimental) Import a policy in this app based on its name.
     *
     * @experimental
     */
    static fromPolicyName(scope: Construct, id: string, policyName: string): IPolicy;
    /**
     * (experimental) The policy document.
     *
     * @experimental
     */
    readonly document: PolicyDocument;
    private readonly _policyName;
    private readonly roles;
    private readonly users;
    private readonly groups;
    private readonly force;
    private referenceTaken;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: PolicyProps);
    /**
     * (experimental) Adds a statement to the policy document.
     *
     * @experimental
     */
    addStatements(...statement: PolicyStatement[]): void;
    /**
     * (experimental) Attaches this policy to a user.
     *
     * @experimental
     */
    attachToUser(user: IUser): void;
    /**
     * (experimental) Attaches this policy to a role.
     *
     * @experimental
     */
    attachToRole(role: IRole): void;
    /**
     * (experimental) Attaches this policy to a group.
     *
     * @experimental
     */
    attachToGroup(group: IGroup): void;
    /**
     * (experimental) The name of this policy.
     *
     * @experimental
     * @attribute true
     */
    get policyName(): string;
    /**
     * (experimental) Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     *
     * @experimental
     */
    protected validate(): string[];
    /**
     * Whether the policy resource has been attached to any identity
     */
    private get isAttached();
}
