import { IPrincipal, ServicePrincipalOpts } from './principals';
/**
 * (experimental) Represents a statement in an IAM policy document.
 *
 * @experimental
 */
export declare class PolicyStatement {
    /**
     * (experimental) Creates a new PolicyStatement based on the object provided.
     *
     * This will accept an object created from the `.toJSON()` call
     *
     * @param obj the PolicyStatement in object form.
     * @experimental
     */
    static fromJson(obj: any): PolicyStatement;
    /**
     * (experimental) Statement ID for this statement.
     *
     * @experimental
     */
    sid?: string;
    /**
     * (experimental) Whether to allow or deny the actions in this statement.
     *
     * @experimental
     */
    effect: Effect;
    private readonly action;
    private readonly notAction;
    private readonly principal;
    private readonly notPrincipal;
    private readonly resource;
    private readonly notResource;
    private readonly condition;
    private principalConditionsJson?;
    /**
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
    /**
     * (experimental) Specify allowed actions into the "Action" section of the policy statement.
     *
     * @param actions actions that will be allowed.
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_action.html
     * @experimental
     */
    addActions(...actions: string[]): void;
    /**
     * (experimental) Explicitly allow all actions except the specified list of actions into the "NotAction" section of the policy document.
     *
     * @param notActions actions that will be denied.
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notaction.html
     * @experimental
     */
    addNotActions(...notActions: string[]): void;
    /**
     * (experimental) Indicates if this permission has a "Principal" section.
     *
     * @experimental
     */
    get hasPrincipal(): boolean;
    /**
     * (experimental) Adds principals to the "Principal" section of a policy statement.
     *
     * @param principals IAM principals that will be added.
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html
     * @experimental
     */
    addPrincipals(...principals: IPrincipal[]): void;
    /**
     * (experimental) Specify principals that is not allowed or denied access to the "NotPrincipal" section of a policy statement.
     *
     * @param notPrincipals IAM principals that will be denied access.
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notprincipal.html
     * @experimental
     */
    addNotPrincipals(...notPrincipals: IPrincipal[]): void;
    private validatePolicyPrincipal;
    /**
     * (experimental) Specify AWS account ID as the principal entity to the "Principal" section of a policy statement.
     *
     * @experimental
     */
    addAwsAccountPrincipal(accountId: string): void;
    /**
     * (experimental) Specify a principal using the ARN  identifier of the principal.
     *
     * You cannot specify IAM groups and instance profiles as principals.
     *
     * @param arn ARN identifier of AWS account, IAM user, or IAM role (i.e. arn:aws:iam::123456789012:user/user-name).
     * @experimental
     */
    addArnPrincipal(arn: string): void;
    /**
     * (experimental) Adds a service principal to this policy statement.
     *
     * @param service the service name for which a service principal is requested (e.g: `s3.amazonaws.com`).
     * @param opts options for adding the service principal (such as specifying a principal in a different region).
     * @experimental
     */
    addServicePrincipal(service: string, opts?: ServicePrincipalOpts): void;
    /**
     * (experimental) Adds a federated identity provider such as Amazon Cognito to this policy statement.
     *
     * @param federated federated identity provider (i.e. 'cognito-identity.amazonaws.com').
     * @param conditions The conditions under which the policy is in effect.
     * @experimental
     */
    addFederatedPrincipal(federated: any, conditions: Conditions): void;
    /**
     * (experimental) Adds an AWS account root user principal to this policy statement.
     *
     * @experimental
     */
    addAccountRootPrincipal(): void;
    /**
     * (experimental) Adds a canonical user ID principal to this policy document.
     *
     * @param canonicalUserId unique identifier assigned by AWS for every account.
     * @experimental
     */
    addCanonicalUserPrincipal(canonicalUserId: string): void;
    /**
     * (experimental) Adds all identities in all accounts ("*") to this policy statement.
     *
     * @experimental
     */
    addAnyPrincipal(): void;
    /**
     * (experimental) Specify resources that this policy statement applies into the "Resource" section of this policy statement.
     *
     * @param arns Amazon Resource Names (ARNs) of the resources that this policy statement applies to.
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_resource.html
     * @experimental
     */
    addResources(...arns: string[]): void;
    /**
     * (experimental) Specify resources that this policy statement will not apply to in the "NotResource" section of this policy statement.
     *
     * All resources except the specified list will be matched.
     *
     * @param arns Amazon Resource Names (ARNs) of the resources that this policy statement does not apply to.
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_notresource.html
     * @experimental
     */
    addNotResources(...arns: string[]): void;
    /**
     * (experimental) Adds a ``"*"`` resource to this statement.
     *
     * @experimental
     */
    addAllResources(): void;
    /**
     * (experimental) Indicates if this permission as at least one resource associated with it.
     *
     * @experimental
     */
    get hasResource(): boolean;
    /**
     * (experimental) Add a condition to the Policy.
     *
     * @experimental
     */
    addCondition(key: string, value: Condition): void;
    /**
     * (experimental) Add multiple conditions to the Policy.
     *
     * @experimental
     */
    addConditions(conditions: Conditions): void;
    /**
     * (experimental) Add a condition that limits to a given account.
     *
     * @experimental
     */
    addAccountCondition(accountId: string): void;
    /**
     * (experimental) JSON-ify the policy statement.
     *
     * Used when JSON.stringify() is called
     *
     * @experimental
     */
    toStatementJson(): any;
    /**
     * (experimental) String representation of this policy statement.
     *
     * @experimental
     */
    toString(): string;
    /**
     * (experimental) JSON-ify the statement.
     *
     * Used when JSON.stringify() is called
     *
     * @experimental
     */
    toJSON(): any;
    /**
     * Add a principal's conditions
     *
     * For convenience, principals have been modeled as both a principal
     * and a set of conditions. This makes it possible to have a single
     * object represent e.g. an "SNS Topic" (SNS service principal + aws:SourcArn
     * condition) or an Organization member (* + aws:OrgId condition).
     *
     * However, when using multiple principals in the same policy statement,
     * they must all have the same conditions or the OR samentics
     * implied by a list of principals cannot be guaranteed (user needs to
     * add multiple statements in that case).
     */
    private addPrincipalConditions;
    /**
     * (experimental) Validate that the policy statement satisfies base requirements for a policy.
     *
     * @experimental
     */
    validateForAnyPolicy(): string[];
    /**
     * (experimental) Validate that the policy statement satisfies all requirements for a resource-based policy.
     *
     * @experimental
     */
    validateForResourcePolicy(): string[];
    /**
     * (experimental) Validate that the policy statement satisfies all requirements for an identity-based policy.
     *
     * @experimental
     */
    validateForIdentityPolicy(): string[];
}
/**
 * (experimental) The Effect element of an IAM policy.
 *
 * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_effect.html
 * @experimental
 */
export declare enum Effect {
    /**
     * (experimental) Allows access to a resource in an IAM policy statement.
     *
     * By default, access to resources are denied.
     *
     * @experimental
     */
    ALLOW = "Allow",
    /**
     * (experimental) Explicitly deny access to a resource.
     *
     * By default, all requests are denied implicitly.
     *
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html
     * @experimental
     */
    DENY = "Deny"
}
/**
 * Condition for when an IAM policy is in effect. Maps from the keys in a request's context to
 * a string value or array of string values. See the Conditions interface for more details.
 */
export declare type Condition = any;
/**
 * Conditions for when an IAM Policy is in effect, specified in the following structure:
 *
 * `{ "Operator": { "keyInRequestContext": "value" } }`
 *
 * The value can be either a single string value or an array of string values.
 *
 * For more information, including which operators are supported, see [the IAM
 * documentation](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition.html).
 */
export declare type Conditions = Record<string, Condition>;
/**
 * (experimental) Interface for creating a policy statement.
 *
 * @experimental
 */
export interface PolicyStatementProps {
    /**
     * (experimental) The Sid (statement ID) is an optional identifier that you provide for the policy statement.
     *
     * You can assign a Sid value to each statement in a
     * statement array. In services that let you specify an ID element, such as
     * SQS and SNS, the Sid value is just a sub-ID of the policy document's ID. In
     * IAM, the Sid value must be unique within a JSON policy.
     *
     * @default - no sid
     * @experimental
     */
    readonly sid?: string;
    /**
     * (experimental) List of actions to add to the statement.
     *
     * @default - no actions
     * @experimental
     */
    readonly actions?: string[];
    /**
     * (experimental) List of not actions to add to the statement.
     *
     * @default - no not-actions
     * @experimental
     */
    readonly notActions?: string[];
    /**
     * (experimental) List of principals to add to the statement.
     *
     * @default - no principals
     * @experimental
     */
    readonly principals?: IPrincipal[];
    /**
     * (experimental) List of not principals to add to the statement.
     *
     * @default - no not principals
     * @experimental
     */
    readonly notPrincipals?: IPrincipal[];
    /**
     * (experimental) Resource ARNs to add to the statement.
     *
     * @default - no resources
     * @experimental
     */
    readonly resources?: string[];
    /**
     * (experimental) NotResource ARNs to add to the statement.
     *
     * @default - no not-resources
     * @experimental
     */
    readonly notResources?: string[];
    /**
     * (experimental) Conditions to add to the statement.
     *
     * @default - no condition
     * @experimental
     */
    readonly conditions?: {
        [key: string]: any;
    };
    /**
     * (experimental) Whether to allow or deny the actions in this statement.
     *
     * @default Effect.ALLOW
     * @experimental
     */
    readonly effect?: Effect;
}
