"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PermissionsBoundary = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const constructs_1 = require("constructs");
const iam_generated_1 = require("./iam.generated");
/**
 * (experimental) Modify the Permissions Boundaries of Users and Roles in a construct tree.
 *
 * @experimental
 * @example
 *
 * const policy = ManagedPolicy.fromAwsManagedPolicyName('ReadOnlyAccess');
 * PermissionsBoundary.of(stack).apply(policy);
 */
class PermissionsBoundary {
    constructor(scope) {
        this.scope = scope;
    }
    /**
     * (experimental) Access the Permissions Boundaries of a construct tree.
     *
     * @experimental
     */
    static of(scope) {
        return new PermissionsBoundary(scope);
    }
    /**
     * (experimental) Apply the given policy as Permissions Boundary to all Roles and Users in the scope.
     *
     * Will override any Permissions Boundaries configured previously; in case
     * a Permission Boundary is applied in multiple scopes, the Boundary applied
     * closest to the Role wins.
     *
     * @experimental
     */
    apply(boundaryPolicy) {
        constructs_1.Node.of(this.scope).applyAspect({
            visit(node) {
                if (node instanceof iam_generated_1.CfnRole || node instanceof iam_generated_1.CfnUser) {
                    node.permissionsBoundary = boundaryPolicy.managedPolicyArn;
                }
                else if (node instanceof core_1.CfnResource &&
                    (node.cfnResourceType == iam_generated_1.CfnRole.CFN_RESOURCE_TYPE_NAME || node.cfnResourceType == iam_generated_1.CfnUser.CFN_RESOURCE_TYPE_NAME)) {
                    node.addPropertyOverride('PermissionsBoundary', boundaryPolicy.managedPolicyArn);
                }
            },
        });
    }
    /**
     * (experimental) Remove previously applied Permissions Boundaries.
     *
     * @experimental
     */
    clear() {
        constructs_1.Node.of(this.scope).applyAspect({
            visit(node) {
                if (node instanceof iam_generated_1.CfnRole || node instanceof iam_generated_1.CfnUser) {
                    node.permissionsBoundary = undefined;
                }
                else if (node instanceof core_1.CfnResource &&
                    (node.cfnResourceType == iam_generated_1.CfnRole.CFN_RESOURCE_TYPE_NAME || node.cfnResourceType == iam_generated_1.CfnUser.CFN_RESOURCE_TYPE_NAME)) {
                    node.addPropertyDeletionOverride('PermissionsBoundary');
                }
            },
        });
    }
}
exports.PermissionsBoundary = PermissionsBoundary;
_a = JSII_RTTI_SYMBOL_1;
PermissionsBoundary[_a] = { fqn: "monocdk.aws_iam.PermissionsBoundary", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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