import { IConstruct } from 'constructs';
import { IManagedPolicy } from './managed-policy';
/**
 * (experimental) Modify the Permissions Boundaries of Users and Roles in a construct tree.
 *
 * @experimental
 * @example
 *
 * const policy = ManagedPolicy.fromAwsManagedPolicyName('ReadOnlyAccess');
 * PermissionsBoundary.of(stack).apply(policy);
 */
export declare class PermissionsBoundary {
    private readonly scope;
    /**
     * (experimental) Access the Permissions Boundaries of a construct tree.
     *
     * @experimental
     */
    static of(scope: IConstruct): PermissionsBoundary;
    private constructor();
    /**
     * (experimental) Apply the given policy as Permissions Boundary to all Roles and Users in the scope.
     *
     * Will override any Permissions Boundaries configured previously; in case
     * a Permission Boundary is applied in multiple scopes, the Boundary applied
     * closest to the Role wins.
     *
     * @experimental
     */
    apply(boundaryPolicy: IManagedPolicy): void;
    /**
     * (experimental) Remove previously applied Permissions Boundaries.
     *
     * @experimental
     */
    clear(): void;
}
