import * as cdk from "../../core";
import { PolicyStatement } from './policy-statement';
import { IGrantable, IPrincipal } from './principals';
/**
 * (experimental) Basic options for a grant operation.
 *
 * @experimental
 */
export interface CommonGrantOptions {
    /**
     * (experimental) The principal to grant to.
     *
     * @default if principal is undefined, no work is done.
     * @experimental
     */
    readonly grantee: IGrantable;
    /**
     * (experimental) The actions to grant.
     *
     * @experimental
     */
    readonly actions: string[];
    /**
     * (experimental) The resource ARNs to grant to.
     *
     * @experimental
     */
    readonly resourceArns: string[];
}
/**
 * (experimental) Options for a grant operation.
 *
 * @experimental
 */
export interface GrantWithResourceOptions extends CommonGrantOptions {
    /**
     * (experimental) The resource with a resource policy.
     *
     * The statement will be added to the resource policy if it couldn't be
     * added to the principal policy.
     *
     * @experimental
     */
    readonly resource: IResourceWithPolicy;
    /**
     * (experimental) When referring to the resource in a resource policy, use this as ARN.
     *
     * (Depending on the resource type, this needs to be '*' in a resource policy).
     *
     * @default Same as regular resource ARNs
     * @experimental
     */
    readonly resourceSelfArns?: string[];
}
/**
 * (experimental) Options for a grant operation that only applies to principals.
 *
 * @experimental
 */
export interface GrantOnPrincipalOptions extends CommonGrantOptions {
    /**
     * (experimental) Construct to report warnings on in case grant could not be registered.
     *
     * @default - the construct in which this construct is defined
     * @experimental
     */
    readonly scope?: cdk.IConstruct;
}
/**
 * (experimental) Options for a grant operation to both identity and resource.
 *
 * @experimental
 */
export interface GrantOnPrincipalAndResourceOptions extends CommonGrantOptions {
    /**
     * (experimental) The resource with a resource policy.
     *
     * The statement will always be added to the resource policy.
     *
     * @experimental
     */
    readonly resource: IResourceWithPolicy;
    /**
     * (experimental) When referring to the resource in a resource policy, use this as ARN.
     *
     * (Depending on the resource type, this needs to be '*' in a resource policy).
     *
     * @default Same as regular resource ARNs
     * @experimental
     */
    readonly resourceSelfArns?: string[];
    /**
     * (experimental) The principal to use in the statement for the resource policy.
     *
     * @default - the principal of the grantee will be used
     * @experimental
     */
    readonly resourcePolicyPrincipal?: IPrincipal;
}
/**
 * (experimental) Result of a grant() operation.
 *
 * This class is not instantiable by consumers on purpose, so that they will be
 * required to call the Grant factory functions.
 *
 * @experimental
 */
export declare class Grant implements cdk.IDependable {
    /**
     * (experimental) Grant the given permissions to the principal.
     *
     * The permissions will be added to the principal policy primarily, falling
     * back to the resource policy if necessary. The permissions must be granted
     * somewhere.
     *
     * - Trying to grant permissions to a principal that does not admit adding to
     *    the principal policy while not providing a resource with a resource policy
     *    is an error.
     * - Trying to grant permissions to an absent principal (possible in the
     *    case of imported resources) leads to a warning being added to the
     *    resource construct.
     *
     * @experimental
     */
    static addToPrincipalOrResource(options: GrantWithResourceOptions): Grant;
    /**
     * (experimental) Try to grant the given permissions to the given principal.
     *
     * Absence of a principal leads to a warning, but failing to add
     * the permissions to a present principal is not an error.
     *
     * @experimental
     */
    static addToPrincipal(options: GrantOnPrincipalOptions): Grant;
    /**
     * (experimental) Add a grant both on the principal and on the resource.
     *
     * As long as any principal is given, granting on the principal may fail (in
     * case of a non-identity principal), but granting on the resource will
     * never fail.
     *
     * Statement will be the resource statement.
     *
     * @experimental
     */
    static addToPrincipalAndResource(options: GrantOnPrincipalAndResourceOptions): Grant;
    /**
     * (experimental) Returns a "no-op" `Grant` object which represents a "dropped grant".
     *
     * This can be used for e.g. imported resources where you may not be able to modify
     * the resource's policy or some underlying policy which you don't know about.
     *
     * @param grantee The intended grantee.
     * @param _intent The user's intent (will be ignored at the moment).
     * @experimental
     */
    static drop(grantee: IGrantable, _intent: string): Grant;
    /**
     * (experimental) The statement that was added to the principal's policy.
     *
     * Can be accessed to (e.g.) add additional conditions to the statement.
     *
     * @experimental
     */
    readonly principalStatement?: PolicyStatement;
    /**
     * (experimental) The statement that was added to the resource policy.
     *
     * Can be accessed to (e.g.) add additional conditions to the statement.
     *
     * @experimental
     */
    readonly resourceStatement?: PolicyStatement;
    /**
     * The options originally used to set this result
     *
     * Private member doubles as a way to make it impossible for an object literal to
     * be structurally the same as this class.
     */
    private readonly options;
    private constructor();
    /**
     * (experimental) Whether the grant operation was successful.
     *
     * @experimental
     */
    get success(): boolean;
    /**
     * (experimental) Throw an error if this grant wasn't successful.
     *
     * @experimental
     */
    assertSuccess(): void;
    /**
     * (experimental) Make sure this grant is applied before the given constructs are deployed.
     *
     * The same as construct.node.addDependency(grant), but slightly nicer to read.
     *
     * @experimental
     */
    applyBefore(...constructs: cdk.IConstruct[]): void;
}
/**
 * (experimental) A resource with a resource policy that can be added to.
 *
 * @experimental
 */
export interface IResourceWithPolicy extends cdk.IResource {
    /**
     * (experimental) Add a statement to the resource's resource policy.
     *
     * @experimental
     */
    addToResourcePolicy(statement: PolicyStatement): AddToResourcePolicyResult;
}
/**
 * (experimental) Result of calling addToResourcePolicy.
 *
 * @experimental
 */
export interface AddToResourcePolicyResult {
    /**
     * (experimental) Whether the statement was added.
     *
     * @experimental
     */
    readonly statementAdded: boolean;
    /**
     * (experimental) Dependable which allows depending on the policy change being applied.
     *
     * @default - If `statementAdded` is true, the resource object itself.
     * Otherwise, no dependable.
     * @experimental
     */
    readonly policyDependable?: cdk.IDependable;
}
/**
 * (experimental) Composite dependable.
 *
 * Not as simple as eagerly getting the dependency roots from the
 * inner dependables, as they may be mutable so we need to defer
 * the query.
 *
 * @experimental
 */
export declare class CompositeDependable implements cdk.IDependable {
    /**
     * @experimental
     */
    constructor(...dependables: cdk.IDependable[]);
}
