import * as cdk from "../../core";
import * as cfn_parse from "../../core/lib/cfn-parse";
/**
 * Properties for defining a `AWS::GreengrassV2::ComponentVersion`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html
 */
export interface CfnComponentVersionProps {
    /**
     * `AWS::GreengrassV2::ComponentVersion.InlineRecipe`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html#cfn-greengrassv2-componentversion-inlinerecipe
     */
    readonly inlineRecipe?: string;
    /**
     * `AWS::GreengrassV2::ComponentVersion.LambdaFunction`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html#cfn-greengrassv2-componentversion-lambdafunction
     */
    readonly lambdaFunction?: CfnComponentVersion.LambdaFunctionRecipeSourceProperty | cdk.IResolvable;
    /**
     * `AWS::GreengrassV2::ComponentVersion.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html#cfn-greengrassv2-componentversion-tags
     */
    readonly tags?: {
        [key: string]: (string);
    };
}
/**
 * A CloudFormation `AWS::GreengrassV2::ComponentVersion`.
 *
 * @external
 * @cloudformationResource AWS::GreengrassV2::ComponentVersion
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html
 */
export declare class CfnComponentVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::GreengrassV2::ComponentVersion";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnComponentVersion;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute ComponentName
     */
    readonly attrComponentName: string;
    /**
     * @external
     * @cloudformationAttribute ComponentVersion
     */
    readonly attrComponentVersion: string;
    /**
     * `AWS::GreengrassV2::ComponentVersion.InlineRecipe`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html#cfn-greengrassv2-componentversion-inlinerecipe
     */
    inlineRecipe: string | undefined;
    /**
     * `AWS::GreengrassV2::ComponentVersion.LambdaFunction`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html#cfn-greengrassv2-componentversion-lambdafunction
     */
    lambdaFunction: CfnComponentVersion.LambdaFunctionRecipeSourceProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::GreengrassV2::ComponentVersion.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html#cfn-greengrassv2-componentversion-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::GreengrassV2::ComponentVersion`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnComponentVersionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::GreengrassV2::ComponentVersion`.
 *
 * @external
 * @cloudformationResource AWS::GreengrassV2::ComponentVersion
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html
 */
export declare namespace CfnComponentVersion {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-componentdependencyrequirement.html
     */
    interface ComponentDependencyRequirementProperty {
        /**
         * `CfnComponentVersion.ComponentDependencyRequirementProperty.DependencyType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-componentdependencyrequirement.html#cfn-greengrassv2-componentversion-componentdependencyrequirement-dependencytype
         */
        readonly dependencyType?: string;
        /**
         * `CfnComponentVersion.ComponentDependencyRequirementProperty.VersionRequirement`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-componentdependencyrequirement.html#cfn-greengrassv2-componentversion-componentdependencyrequirement-versionrequirement
         */
        readonly versionRequirement?: string;
    }
}
/**
 * A CloudFormation `AWS::GreengrassV2::ComponentVersion`.
 *
 * @external
 * @cloudformationResource AWS::GreengrassV2::ComponentVersion
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html
 */
export declare namespace CfnComponentVersion {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-componentplatform.html
     */
    interface ComponentPlatformProperty {
        /**
         * `CfnComponentVersion.ComponentPlatformProperty.Attributes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-componentplatform.html#cfn-greengrassv2-componentversion-componentplatform-attributes
         */
        readonly attributes?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnComponentVersion.ComponentPlatformProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-componentplatform.html#cfn-greengrassv2-componentversion-componentplatform-name
         */
        readonly name?: string;
    }
}
/**
 * A CloudFormation `AWS::GreengrassV2::ComponentVersion`.
 *
 * @external
 * @cloudformationResource AWS::GreengrassV2::ComponentVersion
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html
 */
export declare namespace CfnComponentVersion {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdacontainerparams.html
     */
    interface LambdaContainerParamsProperty {
        /**
         * `CfnComponentVersion.LambdaContainerParamsProperty.Devices`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdacontainerparams.html#cfn-greengrassv2-componentversion-lambdacontainerparams-devices
         */
        readonly devices?: Array<CfnComponentVersion.LambdaDeviceMountProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnComponentVersion.LambdaContainerParamsProperty.MemorySizeInKB`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdacontainerparams.html#cfn-greengrassv2-componentversion-lambdacontainerparams-memorysizeinkb
         */
        readonly memorySizeInKb?: number;
        /**
         * `CfnComponentVersion.LambdaContainerParamsProperty.MountROSysfs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdacontainerparams.html#cfn-greengrassv2-componentversion-lambdacontainerparams-mountrosysfs
         */
        readonly mountRoSysfs?: boolean | cdk.IResolvable;
        /**
         * `CfnComponentVersion.LambdaContainerParamsProperty.Volumes`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdacontainerparams.html#cfn-greengrassv2-componentversion-lambdacontainerparams-volumes
         */
        readonly volumes?: Array<CfnComponentVersion.LambdaVolumeMountProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::GreengrassV2::ComponentVersion`.
 *
 * @external
 * @cloudformationResource AWS::GreengrassV2::ComponentVersion
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html
 */
export declare namespace CfnComponentVersion {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdadevicemount.html
     */
    interface LambdaDeviceMountProperty {
        /**
         * `CfnComponentVersion.LambdaDeviceMountProperty.AddGroupOwner`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdadevicemount.html#cfn-greengrassv2-componentversion-lambdadevicemount-addgroupowner
         */
        readonly addGroupOwner?: boolean | cdk.IResolvable;
        /**
         * `CfnComponentVersion.LambdaDeviceMountProperty.Path`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdadevicemount.html#cfn-greengrassv2-componentversion-lambdadevicemount-path
         */
        readonly path?: string;
        /**
         * `CfnComponentVersion.LambdaDeviceMountProperty.Permission`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdadevicemount.html#cfn-greengrassv2-componentversion-lambdadevicemount-permission
         */
        readonly permission?: string;
    }
}
/**
 * A CloudFormation `AWS::GreengrassV2::ComponentVersion`.
 *
 * @external
 * @cloudformationResource AWS::GreengrassV2::ComponentVersion
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html
 */
export declare namespace CfnComponentVersion {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaeventsource.html
     */
    interface LambdaEventSourceProperty {
        /**
         * `CfnComponentVersion.LambdaEventSourceProperty.Topic`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaeventsource.html#cfn-greengrassv2-componentversion-lambdaeventsource-topic
         */
        readonly topic?: string;
        /**
         * `CfnComponentVersion.LambdaEventSourceProperty.Type`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaeventsource.html#cfn-greengrassv2-componentversion-lambdaeventsource-type
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::GreengrassV2::ComponentVersion`.
 *
 * @external
 * @cloudformationResource AWS::GreengrassV2::ComponentVersion
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html
 */
export declare namespace CfnComponentVersion {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html
     */
    interface LambdaExecutionParametersProperty {
        /**
         * `CfnComponentVersion.LambdaExecutionParametersProperty.EnvironmentVariables`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-environmentvariables
         */
        readonly environmentVariables?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnComponentVersion.LambdaExecutionParametersProperty.EventSources`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-eventsources
         */
        readonly eventSources?: Array<CfnComponentVersion.LambdaEventSourceProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnComponentVersion.LambdaExecutionParametersProperty.ExecArgs`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-execargs
         */
        readonly execArgs?: string[];
        /**
         * `CfnComponentVersion.LambdaExecutionParametersProperty.InputPayloadEncodingType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-inputpayloadencodingtype
         */
        readonly inputPayloadEncodingType?: string;
        /**
         * `CfnComponentVersion.LambdaExecutionParametersProperty.LinuxProcessParams`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-linuxprocessparams
         */
        readonly linuxProcessParams?: CfnComponentVersion.LambdaLinuxProcessParamsProperty | cdk.IResolvable;
        /**
         * `CfnComponentVersion.LambdaExecutionParametersProperty.MaxIdleTimeInSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-maxidletimeinseconds
         */
        readonly maxIdleTimeInSeconds?: number;
        /**
         * `CfnComponentVersion.LambdaExecutionParametersProperty.MaxInstancesCount`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-maxinstancescount
         */
        readonly maxInstancesCount?: number;
        /**
         * `CfnComponentVersion.LambdaExecutionParametersProperty.MaxQueueSize`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-maxqueuesize
         */
        readonly maxQueueSize?: number;
        /**
         * `CfnComponentVersion.LambdaExecutionParametersProperty.Pinned`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-pinned
         */
        readonly pinned?: boolean | cdk.IResolvable;
        /**
         * `CfnComponentVersion.LambdaExecutionParametersProperty.StatusTimeoutInSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-statustimeoutinseconds
         */
        readonly statusTimeoutInSeconds?: number;
        /**
         * `CfnComponentVersion.LambdaExecutionParametersProperty.TimeoutInSeconds`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdaexecutionparameters.html#cfn-greengrassv2-componentversion-lambdaexecutionparameters-timeoutinseconds
         */
        readonly timeoutInSeconds?: number;
    }
}
/**
 * A CloudFormation `AWS::GreengrassV2::ComponentVersion`.
 *
 * @external
 * @cloudformationResource AWS::GreengrassV2::ComponentVersion
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html
 */
export declare namespace CfnComponentVersion {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html
     */
    interface LambdaFunctionRecipeSourceProperty {
        /**
         * `CfnComponentVersion.LambdaFunctionRecipeSourceProperty.ComponentDependencies`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html#cfn-greengrassv2-componentversion-lambdafunctionrecipesource-componentdependencies
         */
        readonly componentDependencies?: {
            [key: string]: (CfnComponentVersion.ComponentDependencyRequirementProperty | cdk.IResolvable);
        } | cdk.IResolvable;
        /**
         * `CfnComponentVersion.LambdaFunctionRecipeSourceProperty.ComponentLambdaParameters`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html#cfn-greengrassv2-componentversion-lambdafunctionrecipesource-componentlambdaparameters
         */
        readonly componentLambdaParameters?: CfnComponentVersion.LambdaExecutionParametersProperty | cdk.IResolvable;
        /**
         * `CfnComponentVersion.LambdaFunctionRecipeSourceProperty.ComponentName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html#cfn-greengrassv2-componentversion-lambdafunctionrecipesource-componentname
         */
        readonly componentName?: string;
        /**
         * `CfnComponentVersion.LambdaFunctionRecipeSourceProperty.ComponentPlatforms`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html#cfn-greengrassv2-componentversion-lambdafunctionrecipesource-componentplatforms
         */
        readonly componentPlatforms?: Array<CfnComponentVersion.ComponentPlatformProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnComponentVersion.LambdaFunctionRecipeSourceProperty.ComponentVersion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html#cfn-greengrassv2-componentversion-lambdafunctionrecipesource-componentversion
         */
        readonly componentVersion?: string;
        /**
         * `CfnComponentVersion.LambdaFunctionRecipeSourceProperty.LambdaArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdafunctionrecipesource.html#cfn-greengrassv2-componentversion-lambdafunctionrecipesource-lambdaarn
         */
        readonly lambdaArn?: string;
    }
}
/**
 * A CloudFormation `AWS::GreengrassV2::ComponentVersion`.
 *
 * @external
 * @cloudformationResource AWS::GreengrassV2::ComponentVersion
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html
 */
export declare namespace CfnComponentVersion {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdalinuxprocessparams.html
     */
    interface LambdaLinuxProcessParamsProperty {
        /**
         * `CfnComponentVersion.LambdaLinuxProcessParamsProperty.ContainerParams`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdalinuxprocessparams.html#cfn-greengrassv2-componentversion-lambdalinuxprocessparams-containerparams
         */
        readonly containerParams?: CfnComponentVersion.LambdaContainerParamsProperty | cdk.IResolvable;
        /**
         * `CfnComponentVersion.LambdaLinuxProcessParamsProperty.IsolationMode`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdalinuxprocessparams.html#cfn-greengrassv2-componentversion-lambdalinuxprocessparams-isolationmode
         */
        readonly isolationMode?: string;
    }
}
/**
 * A CloudFormation `AWS::GreengrassV2::ComponentVersion`.
 *
 * @external
 * @cloudformationResource AWS::GreengrassV2::ComponentVersion
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-componentversion.html
 */
export declare namespace CfnComponentVersion {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdavolumemount.html
     */
    interface LambdaVolumeMountProperty {
        /**
         * `CfnComponentVersion.LambdaVolumeMountProperty.AddGroupOwner`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdavolumemount.html#cfn-greengrassv2-componentversion-lambdavolumemount-addgroupowner
         */
        readonly addGroupOwner?: boolean | cdk.IResolvable;
        /**
         * `CfnComponentVersion.LambdaVolumeMountProperty.DestinationPath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdavolumemount.html#cfn-greengrassv2-componentversion-lambdavolumemount-destinationpath
         */
        readonly destinationPath?: string;
        /**
         * `CfnComponentVersion.LambdaVolumeMountProperty.Permission`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdavolumemount.html#cfn-greengrassv2-componentversion-lambdavolumemount-permission
         */
        readonly permission?: string;
        /**
         * `CfnComponentVersion.LambdaVolumeMountProperty.SourcePath`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-componentversion-lambdavolumemount.html#cfn-greengrassv2-componentversion-lambdavolumemount-sourcepath
         */
        readonly sourcePath?: string;
    }
}
