import * as kms from "../../aws-kms";
import * as cdk from "../../core";
import * as constructs from 'constructs';
/**
 * (experimental) Interface representing a created or an imported {@link SecurityConfiguration}.
 *
 * @experimental
 */
export interface ISecurityConfiguration extends cdk.IResource {
    /**
     * (experimental) The name of the security configuration.
     *
     * @experimental
     * @attribute true
     */
    readonly securityConfigurationName: string;
}
/**
 * (experimental) Encryption mode for S3.
 *
 * @see https://docs.aws.amazon.com/glue/latest/webapi/API_S3Encryption.html#Glue-Type-S3Encryption-S3EncryptionMode
 * @experimental
 */
export declare enum S3EncryptionMode {
    /**
     * (experimental) Server side encryption (SSE) with an Amazon S3-managed key.
     *
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html
     * @experimental
     */
    S3_MANAGED = "SSE-S3",
    /**
     * (experimental) Server-side encryption (SSE) with an AWS KMS key managed by the account owner.
     *
     * @see https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html
     * @experimental
     */
    KMS = "SSE-KMS"
}
/**
 * Encryption mode for CloudWatch Logs.
 * @see https://docs.aws.amazon.com/glue/latest/webapi/API_CloudWatchEncryption.html#Glue-Type-CloudWatchEncryption-CloudWatchEncryptionMode
 */
export declare enum CloudWatchEncryptionMode {
    /**
     * (experimental) Encryption mode for CloudWatch Logs.
     *
     * @see https://docs.aws.amazon.com/glue/latest/webapi/API_CloudWatchEncryption.html#Glue-Type-CloudWatchEncryption-CloudWatchEncryptionMode
     * @experimental
     */
    KMS = "SSE-KMS"
}
/**
 * Encryption mode for Job Bookmarks.
 * @see https://docs.aws.amazon.com/glue/latest/webapi/API_JobBookmarksEncryption.html#Glue-Type-JobBookmarksEncryption-JobBookmarksEncryptionMode
 */
export declare enum JobBookmarksEncryptionMode {
    /**
     * (experimental) Encryption mode for Job Bookmarks.
     *
     * @see https://docs.aws.amazon.com/glue/latest/webapi/API_JobBookmarksEncryption.html#Glue-Type-JobBookmarksEncryption-JobBookmarksEncryptionMode
     * @experimental
     */
    CLIENT_SIDE_KMS = "CSE-KMS"
}
/**
 * (experimental) S3 encryption configuration.
 *
 * @experimental
 */
export interface S3Encryption {
    /**
     * (experimental) Encryption mode.
     *
     * @experimental
     */
    readonly mode: S3EncryptionMode;
    /**
     * (experimental) The KMS key to be used to encrypt the data.
     *
     * @default no kms key if mode = S3_MANAGED. A key will be created if one is not provided and mode = KMS.
     * @experimental
     */
    readonly kmsKey?: kms.IKey;
}
/**
 * (experimental) CloudWatch Logs encryption configuration.
 *
 * @experimental
 */
export interface CloudWatchEncryption {
    /**
     * (experimental) Encryption mode.
     *
     * @experimental
     */
    readonly mode: CloudWatchEncryptionMode;
    /**
     * (experimental) The KMS key to be used to encrypt the data.
     *
     * @default A key will be created if one is not provided.
     * @experimental
     */
    readonly kmsKey?: kms.IKey;
}
/**
 * (experimental) Job bookmarks encryption configuration.
 *
 * @experimental
 */
export interface JobBookmarksEncryption {
    /**
     * (experimental) Encryption mode.
     *
     * @experimental
     */
    readonly mode: JobBookmarksEncryptionMode;
    /**
     * (experimental) The KMS key to be used to encrypt the data.
     *
     * @default A key will be created if one is not provided.
     * @experimental
     */
    readonly kmsKey?: kms.IKey;
}
/**
 * (experimental) Constructions properties of {@link SecurityConfiguration}.
 *
 * @experimental
 */
export interface SecurityConfigurationProps {
    /**
     * (experimental) The name of the security configuration.
     *
     * @experimental
     */
    readonly securityConfigurationName: string;
    /**
     * (experimental) The encryption configuration for Amazon CloudWatch Logs.
     *
     * @default no cloudwatch logs encryption.
     * @experimental
     */
    readonly cloudWatchEncryption?: CloudWatchEncryption;
    /**
     * (experimental) The encryption configuration for Glue Job Bookmarks.
     *
     * @default no job bookmarks encryption.
     * @experimental
     */
    readonly jobBookmarksEncryption?: JobBookmarksEncryption;
    /**
     * (experimental) The encryption configuration for Amazon Simple Storage Service (Amazon S3) data.
     *
     * @default no s3 encryption.
     * @experimental
     */
    readonly s3Encryption?: S3Encryption;
}
/**
 * (experimental) A security configuration is a set of security properties that can be used by AWS Glue to encrypt data at rest.
 *
 * The following scenarios show some of the ways that you can use a security configuration.
 * - Attach a security configuration to an AWS Glue crawler to write encrypted Amazon CloudWatch Logs.
 * - Attach a security configuration to an extract, transform, and load (ETL) job to write encrypted Amazon Simple Storage Service (Amazon S3) targets and encrypted CloudWatch Logs.
 * - Attach a security configuration to an ETL job to write its jobs bookmarks as encrypted Amazon S3 data.
 * - Attach a security configuration to a development endpoint to write encrypted Amazon S3 targets.
 *
 * @experimental
 */
export declare class SecurityConfiguration extends cdk.Resource implements ISecurityConfiguration {
    /**
     * (experimental) Creates a Connection construct that represents an external security configuration.
     *
     * @param scope The scope creating construct (usually `this`).
     * @param id The construct's id.
     * @param securityConfigurationName name of external security configuration.
     * @experimental
     */
    static fromSecurityConfigurationName(scope: constructs.Construct, id: string, securityConfigurationName: string): ISecurityConfiguration;
    /**
     * (experimental) The name of the security configuration.
     *
     * @experimental
     * @attribute true
     */
    readonly securityConfigurationName: string;
    /**
     * (experimental) The KMS key used in CloudWatch encryption if it requires a kms key.
     *
     * @experimental
     */
    readonly cloudWatchEncryptionKey?: kms.IKey;
    /**
     * (experimental) The KMS key used in job bookmarks encryption if it requires a kms key.
     *
     * @experimental
     */
    readonly jobBookmarksEncryptionKey?: kms.IKey;
    /**
     * (experimental) The KMS key used in S3 encryption if it requires a kms key.
     *
     * @experimental
     */
    readonly s3EncryptionKey?: kms.IKey;
    /**
     * @experimental
     */
    constructor(scope: constructs.Construct, id: string, props: SecurityConfigurationProps);
}
