"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Schema = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * @see https://docs.aws.amazon.com/athena/latest/ug/data-types.html
 * @experimental
 */
class Schema {
    /**
     * (experimental) Creates a decimal type.
     *
     * TODO: Bounds
     *
     * @param precision the total number of digits.
     * @param scale the number of digits in fractional part, the default is 0.
     * @experimental
     */
    static decimal(precision, scale) {
        return {
            isPrimitive: true,
            inputString: scale !== undefined ? `decimal(${precision},${scale})` : `decimal(${precision})`,
        };
    }
    /**
     * (experimental) Fixed length character data, with a specified length between 1 and 255.
     *
     * @param length length between 1 and 255.
     * @experimental
     */
    static char(length) {
        if (length <= 0 || length > 255) {
            throw new Error(`char length must be (inclusively) between 1 and 255, but was ${length}`);
        }
        if (length % 1 !== 0) {
            throw new Error(`char length must be a positive integer, was ${length}`);
        }
        return {
            isPrimitive: true,
            inputString: `char(${length})`,
        };
    }
    /**
     * (experimental) Variable length character data, with a specified length between 1 and 65535.
     *
     * @param length length between 1 and 65535.
     * @experimental
     */
    static varchar(length) {
        if (length <= 0 || length > 65535) {
            throw new Error(`varchar length must be (inclusively) between 1 and 65535, but was ${length}`);
        }
        if (length % 1 !== 0) {
            throw new Error(`varchar length must be a positive integer, was ${length}`);
        }
        return {
            isPrimitive: true,
            inputString: `varchar(${length})`,
        };
    }
    /**
     * (experimental) Creates an array of some other type.
     *
     * @param itemType type contained by the array.
     * @experimental
     */
    static array(itemType) {
        return {
            isPrimitive: false,
            inputString: `array<${itemType.inputString}>`,
        };
    }
    /**
     * (experimental) Creates a map of some primitive key type to some value type.
     *
     * @param keyType type of key, must be a primitive.
     * @param valueType type fo the value indexed by the key.
     * @experimental
     */
    static map(keyType, valueType) {
        if (!keyType.isPrimitive) {
            throw new Error(`the key type of a 'map' must be a primitive, but was ${keyType.inputString}`);
        }
        return {
            isPrimitive: false,
            inputString: `map<${keyType.inputString},${valueType.inputString}>`,
        };
    }
    /**
     * (experimental) Creates a nested structure containing individually named and typed columns.
     *
     * @param columns the columns of the structure.
     * @experimental
     */
    static struct(columns) {
        return {
            isPrimitive: false,
            inputString: `struct<${columns.map(column => {
                if (column.comment === undefined) {
                    return `${column.name}:${column.type.inputString}`;
                }
                else {
                    return `${column.name}:${column.type.inputString} COMMENT '${column.comment}'`;
                }
            }).join(',')}>`,
        };
    }
}
exports.Schema = Schema;
_a = JSII_RTTI_SYMBOL_1;
Schema[_a] = { fqn: "monocdk.aws_glue.Schema", version: "1.106.1" };
/**
 * @experimental
 */
Schema.BOOLEAN = {
    isPrimitive: true,
    inputString: 'boolean',
};
/**
 * @experimental
 */
Schema.BINARY = {
    isPrimitive: true,
    inputString: 'binary',
};
/**
 * (experimental) A 64-bit signed INTEGER in two’s complement format, with a minimum value of -2^63 and a maximum value of 2^63-1.
 *
 * @experimental
 */
Schema.BIG_INT = {
    isPrimitive: true,
    inputString: 'bigint',
};
/**
 * @experimental
 */
Schema.DOUBLE = {
    isPrimitive: true,
    inputString: 'double',
};
/**
 * @experimental
 */
Schema.FLOAT = {
    isPrimitive: true,
    inputString: 'float',
};
/**
 * (experimental) A 32-bit signed INTEGER in two’s complement format, with a minimum value of -2^31 and a maximum value of 2^31-1.
 *
 * @experimental
 */
Schema.INTEGER = {
    isPrimitive: true,
    inputString: 'int',
};
/**
 * (experimental) A 16-bit signed INTEGER in two’s complement format, with a minimum value of -2^15 and a maximum value of 2^15-1.
 *
 * @experimental
 */
Schema.SMALL_INT = {
    isPrimitive: true,
    inputString: 'smallint',
};
/**
 * (experimental) A 8-bit signed INTEGER in two’s complement format, with a minimum value of -2^7 and a maximum value of 2^7-1.
 *
 * @experimental
 */
Schema.TINY_INT = {
    isPrimitive: true,
    inputString: 'tinyint',
};
/**
 * (experimental) Date type.
 *
 * @experimental
 */
Schema.DATE = {
    isPrimitive: true,
    inputString: 'date',
};
/**
 * (experimental) Timestamp type (date and time).
 *
 * @experimental
 */
Schema.TIMESTAMP = {
    isPrimitive: true,
    inputString: 'timestamp',
};
/**
 * (experimental) Arbitrary-length string type.
 *
 * @experimental
 */
Schema.STRING = {
    isPrimitive: true,
    inputString: 'string',
};
//# sourceMappingURL=data:application/json;base64,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