"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Connection = exports.ConnectionType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const glue_generated_1 = require("./glue.generated");
/**
 * (experimental) The type of the glue connection.
 *
 * If you need to use a connection type that doesn't exist as a static member, you
 * can instantiate a `ConnectionType` object, e.g: `new ConnectionType('NEW_TYPE')`.
 *
 * @experimental
 */
class ConnectionType {
    /**
     * @experimental
     */
    constructor(name) {
        this.name = name;
    }
    /**
     * (experimental) The connection type name as expected by Connection resource.
     *
     * @experimental
     */
    toString() {
        return this.name;
    }
}
exports.ConnectionType = ConnectionType;
_a = JSII_RTTI_SYMBOL_1;
ConnectionType[_a] = { fqn: "monocdk.aws_glue.ConnectionType", version: "1.106.1" };
/**
 * (experimental) Designates a connection to a database through Java Database Connectivity (JDBC).
 *
 * @experimental
 */
ConnectionType.JDBC = new ConnectionType('JDBC');
/**
 * (experimental) Designates a connection to an Apache Kafka streaming platform.
 *
 * @experimental
 */
ConnectionType.KAFKA = new ConnectionType('KAFKA');
/**
 * (experimental) Designates a connection to a MongoDB document database.
 *
 * @experimental
 */
ConnectionType.MONGODB = new ConnectionType('MONGODB');
/**
 * (experimental) Designates a network connection to a data source within an Amazon Virtual Private Cloud environment (Amazon VPC).
 *
 * @experimental
 */
ConnectionType.NETWORK = new ConnectionType('NETWORK');
/**
 * (experimental) An AWS Glue connection to a data source.
 *
 * @experimental
 */
class Connection extends cdk.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.connectionName,
        });
        this.properties = props.properties || {};
        const physicalConnectionRequirements = props.subnet || props.securityGroups ? {
            availabilityZone: props.subnet ? props.subnet.availabilityZone : undefined,
            subnetId: props.subnet ? props.subnet.subnetId : undefined,
            securityGroupIdList: props.securityGroups ? props.securityGroups.map(sg => sg.securityGroupId) : undefined,
        } : undefined;
        const connectionResource = new glue_generated_1.CfnConnection(this, 'Resource', {
            catalogId: cdk.Stack.of(this).account,
            connectionInput: {
                connectionProperties: cdk.Lazy.any({ produce: () => Object.keys(this.properties).length > 0 ? this.properties : undefined }),
                connectionType: props.type.name,
                description: props.description,
                matchCriteria: props.matchCriteria,
                name: props.connectionName,
                physicalConnectionRequirements,
            },
        });
        const resourceName = this.getResourceNameAttribute(connectionResource.ref);
        this.connectionArn = Connection.buildConnectionArn(this, resourceName);
        this.connectionName = resourceName;
    }
    /**
     * (experimental) Creates a Connection construct that represents an external connection.
     *
     * @param scope The scope creating construct (usually `this`).
     * @param id The construct's id.
     * @param connectionArn arn of external connection.
     * @experimental
     */
    static fromConnectionArn(scope, id, connectionArn) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.connectionName = cdk.Arn.extractResourceName(connectionArn, 'connection');
                this.connectionArn = connectionArn;
            }
        }
        return new Import(scope, id);
    }
    /**
     * (experimental) Creates a Connection construct that represents an external connection.
     *
     * @param scope The scope creating construct (usually `this`).
     * @param id The construct's id.
     * @param connectionName name of external connection.
     * @experimental
     */
    static fromConnectionName(scope, id, connectionName) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.connectionName = connectionName;
                this.connectionArn = Connection.buildConnectionArn(scope, connectionName);
            }
        }
        return new Import(scope, id);
    }
    static buildConnectionArn(scope, connectionName) {
        return cdk.Stack.of(scope).formatArn({
            service: 'glue',
            resource: 'connection',
            resourceName: connectionName,
        });
    }
    /**
     * (experimental) Add additional connection parameters.
     *
     * @param key parameter key.
     * @param value parameter value.
     * @experimental
     */
    addProperty(key, value) {
        this.properties[key] = value;
    }
}
exports.Connection = Connection;
_b = JSII_RTTI_SYMBOL_1;
Connection[_b] = { fqn: "monocdk.aws_glue.Connection", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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