import * as ec2 from "../../aws-ec2";
import * as cdk from "../../core";
import * as constructs from 'constructs';
/**
 * (experimental) The type of the glue connection.
 *
 * If you need to use a connection type that doesn't exist as a static member, you
 * can instantiate a `ConnectionType` object, e.g: `new ConnectionType('NEW_TYPE')`.
 *
 * @experimental
 */
export declare class ConnectionType {
    /**
     * (experimental) Designates a connection to a database through Java Database Connectivity (JDBC).
     *
     * @experimental
     */
    static readonly JDBC: ConnectionType;
    /**
     * (experimental) Designates a connection to an Apache Kafka streaming platform.
     *
     * @experimental
     */
    static readonly KAFKA: ConnectionType;
    /**
     * (experimental) Designates a connection to a MongoDB document database.
     *
     * @experimental
     */
    static readonly MONGODB: ConnectionType;
    /**
     * (experimental) Designates a network connection to a data source within an Amazon Virtual Private Cloud environment (Amazon VPC).
     *
     * @experimental
     */
    static readonly NETWORK: ConnectionType;
    /**
     * (experimental) The name of this ConnectionType, as expected by Connection resource.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * @experimental
     */
    constructor(name: string);
    /**
     * (experimental) The connection type name as expected by Connection resource.
     *
     * @experimental
     */
    toString(): string;
}
/**
 * (experimental) Interface representing a created or an imported {@link Connection}.
 *
 * @experimental
 */
export interface IConnection extends cdk.IResource {
    /**
     * (experimental) The name of the connection.
     *
     * @experimental
     * @attribute true
     */
    readonly connectionName: string;
    /**
     * (experimental) The ARN of the connection.
     *
     * @experimental
     * @attribute true
     */
    readonly connectionArn: string;
}
/**
 * (experimental) Base Connection Options.
 *
 * @experimental
 */
export interface ConnectionOptions {
    /**
     * (experimental) The name of the connection.
     *
     * @default cloudformation generated name
     * @experimental
     */
    readonly connectionName?: string;
    /**
     * (experimental) The description of the connection.
     *
     * @default no description
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) Key-Value pairs that define parameters for the connection.
     *
     * @default empty properties
     * @see https://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-connect.html
     * @experimental
     */
    readonly properties?: {
        [key: string]: string;
    };
    /**
     * (experimental) A list of criteria that can be used in selecting this connection.
     *
     * This is useful for filtering the results of https://awscli.amazonaws.com/v2/documentation/api/latest/reference/glue/get-connections.html
     *
     * @default no match criteria
     * @experimental
     */
    readonly matchCriteria?: string[];
    /**
     * (experimental) The list of security groups needed to successfully make this connection e.g. to successfully connect to VPC.
     *
     * @default no security group
     * @experimental
     */
    readonly securityGroups?: ec2.ISecurityGroup[];
    /**
     * (experimental) The VPC subnet to connect to resources within a VPC.
     *
     * See more at https://docs.aws.amazon.com/glue/latest/dg/start-connecting.html.
     *
     * @default no subnet
     * @experimental
     */
    readonly subnet?: ec2.ISubnet;
}
/**
 * (experimental) Construction properties for {@link Connection}.
 *
 * @experimental
 */
export interface ConnectionProps extends ConnectionOptions {
    /**
     * (experimental) The type of the connection.
     *
     * @experimental
     */
    readonly type: ConnectionType;
}
/**
 * (experimental) An AWS Glue connection to a data source.
 *
 * @experimental
 */
export declare class Connection extends cdk.Resource implements IConnection {
    /**
     * (experimental) Creates a Connection construct that represents an external connection.
     *
     * @param scope The scope creating construct (usually `this`).
     * @param id The construct's id.
     * @param connectionArn arn of external connection.
     * @experimental
     */
    static fromConnectionArn(scope: constructs.Construct, id: string, connectionArn: string): IConnection;
    /**
     * (experimental) Creates a Connection construct that represents an external connection.
     *
     * @param scope The scope creating construct (usually `this`).
     * @param id The construct's id.
     * @param connectionName name of external connection.
     * @experimental
     */
    static fromConnectionName(scope: constructs.Construct, id: string, connectionName: string): IConnection;
    private static buildConnectionArn;
    /**
     * (experimental) The ARN of the connection.
     *
     * @experimental
     */
    readonly connectionArn: string;
    /**
     * (experimental) The name of the connection.
     *
     * @experimental
     */
    readonly connectionName: string;
    private readonly properties;
    /**
     * @experimental
     */
    constructor(scope: constructs.Construct, id: string, props: ConnectionProps);
    /**
     * (experimental) Add additional connection parameters.
     *
     * @param key parameter key.
     * @param value parameter value.
     * @experimental
     */
    addProperty(key: string, value: string): void;
}
