"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Listener = exports.ClientAffinity = exports.ConnectionProtocol = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const endpoint_group_1 = require("./endpoint-group");
const ga = require("./globalaccelerator.generated");
/**
 * (experimental) The protocol for the connections from clients to the accelerator.
 *
 * @experimental
 */
var ConnectionProtocol;
(function (ConnectionProtocol) {
    ConnectionProtocol["TCP"] = "TCP";
    ConnectionProtocol["UDP"] = "UDP";
})(ConnectionProtocol = exports.ConnectionProtocol || (exports.ConnectionProtocol = {}));
/**
 * (experimental) Client affinity gives you control over whether to always route each client to the same specific endpoint.
 *
 * @see https://docs.aws.amazon.com/global-accelerator/latest/dg/about-listeners.html#about-listeners-client-affinity
 * @experimental
 */
var ClientAffinity;
(function (ClientAffinity) {
    ClientAffinity["NONE"] = "NONE";
    ClientAffinity["SOURCE_IP"] = "SOURCE_IP";
})(ClientAffinity = exports.ClientAffinity || (exports.ClientAffinity = {}));
/**
 * (experimental) The construct for the Listener.
 *
 * @experimental
 */
class Listener extends cdk.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c, _d;
        super(scope, id);
        const resource = new ga.CfnListener(this, 'Resource', {
            acceleratorArn: props.accelerator.acceleratorArn,
            portRanges: props.portRanges.map(m => {
                var _b;
                return ({
                    fromPort: m.fromPort,
                    toPort: (_b = m.toPort) !== null && _b !== void 0 ? _b : m.fromPort,
                });
            }),
            protocol: (_b = props.protocol) !== null && _b !== void 0 ? _b : ConnectionProtocol.TCP,
            clientAffinity: (_c = props.clientAffinity) !== null && _c !== void 0 ? _c : ClientAffinity.NONE,
        });
        this.listenerArn = resource.attrListenerArn;
        this.listenerName = (_d = props.listenerName) !== null && _d !== void 0 ? _d : resource.logicalId;
    }
    /**
     * (experimental) import from ARN.
     *
     * @experimental
     */
    static fromListenerArn(scope, id, listenerArn) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.listenerArn = listenerArn;
            }
        }
        return new Import(scope, id);
    }
    /**
     * (experimental) Add a new endpoint group to this listener.
     *
     * @experimental
     */
    addEndpointGroup(id, options = {}) {
        return new endpoint_group_1.EndpointGroup(this, id, {
            listener: this,
            ...options,
        });
    }
}
exports.Listener = Listener;
_a = JSII_RTTI_SYMBOL_1;
Listener[_a] = { fqn: "monocdk.aws_globalaccelerator.Listener", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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