import * as cdk from "../../core";
import { Construct } from 'constructs';
import { IAccelerator } from './accelerator';
import { EndpointGroup, EndpointGroupOptions } from './endpoint-group';
/**
 * (experimental) Interface of the Listener.
 *
 * @experimental
 */
export interface IListener extends cdk.IResource {
    /**
     * (experimental) The ARN of the listener.
     *
     * @experimental
     * @attribute true
     */
    readonly listenerArn: string;
}
/**
 * (experimental) Construct options for Listener.
 *
 * @experimental
 */
export interface ListenerOptions {
    /**
     * (experimental) Name of the listener.
     *
     * @default - logical ID of the resource
     * @experimental
     */
    readonly listenerName?: string;
    /**
     * (experimental) The list of port ranges for the connections from clients to the accelerator.
     *
     * @experimental
     */
    readonly portRanges: PortRange[];
    /**
     * (experimental) The protocol for the connections from clients to the accelerator.
     *
     * @default ConnectionProtocol.TCP
     * @experimental
     */
    readonly protocol?: ConnectionProtocol;
    /**
     * (experimental) Client affinity to direct all requests from a user to the same endpoint.
     *
     * If you have stateful applications, client affinity lets you direct all
     * requests from a user to the same endpoint.
     *
     * By default, each connection from each client is routed to seperate
     * endpoints. Set client affinity to SOURCE_IP to route all connections from
     * a single client to the same endpoint.
     *
     * @default ClientAffinity.NONE
     * @experimental
     */
    readonly clientAffinity?: ClientAffinity;
}
/**
 * (experimental) Construct properties for Listener.
 *
 * @experimental
 */
export interface ListenerProps extends ListenerOptions {
    /**
     * (experimental) The accelerator for this listener.
     *
     * @experimental
     */
    readonly accelerator: IAccelerator;
}
/**
 * (experimental) The list of port ranges for the connections from clients to the accelerator.
 *
 * @experimental
 */
export interface PortRange {
    /**
     * (experimental) The first port in the range of ports, inclusive.
     *
     * @experimental
     */
    readonly fromPort: number;
    /**
     * (experimental) The last port in the range of ports, inclusive.
     *
     * @default - same as `fromPort`
     * @experimental
     */
    readonly toPort?: number;
}
/**
 * (experimental) The protocol for the connections from clients to the accelerator.
 *
 * @experimental
 */
export declare enum ConnectionProtocol {
    /**
     * (experimental) TCP.
     *
     * @experimental
     */
    TCP = "TCP",
    /**
     * (experimental) UDP.
     *
     * @experimental
     */
    UDP = "UDP"
}
/**
 * (experimental) Client affinity gives you control over whether to always route each client to the same specific endpoint.
 *
 * @see https://docs.aws.amazon.com/global-accelerator/latest/dg/about-listeners.html#about-listeners-client-affinity
 * @experimental
 */
export declare enum ClientAffinity {
    /**
     * (experimental) Route traffic based on the 5-tuple `(source IP, source port, destination IP, destination port, protocol)`.
     *
     * @experimental
     */
    NONE = "NONE",
    /**
     * (experimental) Route traffic based on the 2-tuple `(source IP, destination IP)`.
     *
     * The result is that multiple connections from the same client will be routed the same.
     *
     * @experimental
     */
    SOURCE_IP = "SOURCE_IP"
}
/**
 * (experimental) The construct for the Listener.
 *
 * @experimental
 */
export declare class Listener extends cdk.Resource implements IListener {
    /**
     * (experimental) import from ARN.
     *
     * @experimental
     */
    static fromListenerArn(scope: Construct, id: string, listenerArn: string): IListener;
    /**
     * (experimental) The ARN of the listener.
     *
     * @experimental
     */
    readonly listenerArn: string;
    /**
     * (experimental) The name of the listener.
     *
     * @experimental
     * @attribute true
     */
    readonly listenerName: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ListenerProps);
    /**
     * (experimental) Add a new endpoint group to this listener.
     *
     * @experimental
     */
    addEndpointGroup(id: string, options?: EndpointGroupOptions): EndpointGroup;
}
