/**
 * (experimental) An endpoint for the endpoint group.
 *
 * Implementations of `IEndpoint` can be found in the `aws-globalaccelerator-endpoints` package.
 *
 * @experimental
 */
export interface IEndpoint {
    /**
     * (experimental) The region where the endpoint is located.
     *
     * If the region cannot be determined, `undefined` is returned
     *
     * @experimental
     */
    readonly region?: string;
    /**
     * (experimental) Render the endpoint to an endpoint configuration.
     *
     * @experimental
     */
    renderEndpointConfiguration(): any;
}
/**
 * (experimental) Properties for RawEndpoint.
 *
 * @experimental
 */
export interface RawEndpointProps {
    /**
     * (experimental) Identifier of the endpoint.
     *
     * Load balancer ARN, instance ID or EIP allocation ID.
     *
     * @experimental
     */
    readonly endpointId: string;
    /**
     * (experimental) Endpoint weight across all endpoints in the group.
     *
     * Must be a value between 0 and 255.
     *
     * @default 128
     * @experimental
     */
    readonly weight?: number;
    /**
     * (experimental) Forward the client IP address.
     *
     * GlobalAccelerator will create Network Interfaces in your VPC in order
     * to preserve the client IP address.
     *
     * Only applies to Application Load Balancers and EC2 instances.
     *
     * Client IP address preservation is supported only in specific AWS Regions.
     * See the GlobalAccelerator Developer Guide for a list.
     *
     * @default true if possible and available
     * @experimental
     */
    readonly preserveClientIp?: boolean;
    /**
     * (experimental) The region where this endpoint is located.
     *
     * @default - Unknown what region this endpoint is located
     * @experimental
     */
    readonly region?: string;
}
/**
 * (experimental) Untyped endpoint implementation.
 *
 * Prefer using the classes in the `aws-globalaccelerator-endpoints` package instead,
 * as they accept typed constructs. You can use this class if you want to use an
 * endpoint type that does not have an appropriate class in that package yet.
 *
 * @experimental
 */
export declare class RawEndpoint implements IEndpoint {
    private readonly props;
    /**
     * (experimental) The region where the endpoint is located.
     *
     * If the region cannot be determined, `undefined` is returned
     *
     * @experimental
     */
    readonly region?: string;
    /**
     * @experimental
     */
    constructor(props: RawEndpointProps);
    /**
     * (experimental) Render the endpoint to an endpoint configuration.
     *
     * @experimental
     */
    renderEndpointConfiguration(): any;
}
