"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EndpointGroup = exports.HealthCheckProtocol = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const _accelerator_security_group_1 = require("./_accelerator-security-group");
const ga = require("./globalaccelerator.generated");
/**
 * (experimental) The protocol for the connections from clients to the accelerator.
 *
 * @experimental
 */
var HealthCheckProtocol;
(function (HealthCheckProtocol) {
    HealthCheckProtocol["TCP"] = "TCP";
    HealthCheckProtocol["HTTP"] = "HTTP";
    HealthCheckProtocol["HTTPS"] = "HTTPS";
})(HealthCheckProtocol = exports.HealthCheckProtocol || (exports.HealthCheckProtocol = {}));
/**
 * (experimental) EndpointGroup construct.
 *
 * @experimental
 */
class EndpointGroup extends cdk.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b, _c, _d, _e, _f;
        super(scope, id);
        /**
         * (experimental) The array of the endpoints in this endpoint group.
         *
         * @experimental
         */
        this.endpoints = new Array();
        const resource = new ga.CfnEndpointGroup(this, 'Resource', {
            listenerArn: props.listener.listenerArn,
            endpointGroupRegion: (_b = props.region) !== null && _b !== void 0 ? _b : cdk.Lazy.string({ produce: () => this.firstEndpointRegion() }),
            endpointConfigurations: cdk.Lazy.any({ produce: () => this.renderEndpoints() }, { omitEmptyArray: true }),
            healthCheckIntervalSeconds: (_c = props.healthCheckInterval) === null || _c === void 0 ? void 0 : _c.toSeconds({ integral: true }),
            healthCheckPath: props.healthCheckPath,
            healthCheckPort: props.healthCheckPort,
            healthCheckProtocol: props.healthCheckProtocol,
            thresholdCount: props.healthCheckThreshold,
            trafficDialPercentage: props.trafficDialPercentage,
            portOverrides: (_d = props.portOverrides) === null || _d === void 0 ? void 0 : _d.map(o => ({
                endpointPort: o.endpointPort,
                listenerPort: o.listenerPort,
            })),
        });
        this.endpointGroupArn = resource.attrEndpointGroupArn;
        this.endpointGroupName = (_e = props.endpointGroupName) !== null && _e !== void 0 ? _e : resource.logicalId;
        for (const endpoint of (_f = props.endpoints) !== null && _f !== void 0 ? _f : []) {
            this.addEndpoint(endpoint);
        }
    }
    /**
     * (experimental) import from ARN.
     *
     * @experimental
     */
    static fromEndpointGroupArn(scope, id, endpointGroupArn) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.endpointGroupArn = endpointGroupArn;
            }
        }
        return new Import(scope, id);
    }
    /**
     * (experimental) Add an endpoint.
     *
     * @experimental
     */
    addEndpoint(endpoint) {
        this.endpoints.push(endpoint);
    }
    /**
     * (experimental) Return an object that represents the Accelerator's Security Group.
     *
     * Uses a Custom Resource to look up the Security Group that Accelerator
     * creates at deploy time. Requires your VPC ID to perform the lookup.
     *
     * The Security Group will only be created if you enable **Client IP
     * Preservation** on any of the endpoints.
     *
     * You cannot manipulate the rules inside this security group, but you can
     * use this security group as a Peer in Connections rules on other
     * constructs.
     *
     * @experimental
     */
    connectionsPeer(id, vpc) {
        return _accelerator_security_group_1.AcceleratorSecurityGroupPeer.fromVpc(this, id, vpc, this);
    }
    renderEndpoints() {
        return this.endpoints.map(e => e.renderEndpointConfiguration());
    }
    /**
     * Return the first (readable) region of the endpoints in this group
     */
    firstEndpointRegion() {
        for (const endpoint of this.endpoints) {
            if (endpoint.region) {
                return endpoint.region;
            }
        }
        return cdk.Stack.of(this).region;
    }
}
exports.EndpointGroup = EndpointGroup;
_a = JSII_RTTI_SYMBOL_1;
EndpointGroup[_a] = { fqn: "monocdk.aws_globalaccelerator.EndpointGroup", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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