import * as ec2 from "../../aws-ec2";
import * as cdk from "../../core";
import { Construct } from 'constructs';
import { IEndpoint } from './endpoint';
import { IListener } from './listener';
/**
 * (experimental) The interface of the EndpointGroup.
 *
 * @experimental
 */
export interface IEndpointGroup extends cdk.IResource {
    /**
     * (experimental) EndpointGroup ARN.
     *
     * @experimental
     * @attribute true
     */
    readonly endpointGroupArn: string;
}
/**
 * (experimental) Basic options for creating a new EndpointGroup.
 *
 * @experimental
 */
export interface EndpointGroupOptions {
    /**
     * (experimental) Name of the endpoint group.
     *
     * @default - logical ID of the resource
     * @experimental
     */
    readonly endpointGroupName?: string;
    /**
     * (experimental) The AWS Region where the endpoint group is located.
     *
     * @default - region of the first endpoint in this group, or the stack region if that region can't be determined
     * @experimental
     */
    readonly region?: string;
    /**
     * (experimental) The time between health checks for each endpoint.
     *
     * Must be either 10 or 30 seconds.
     *
     * @default Duration.seconds(30)
     * @experimental
     */
    readonly healthCheckInterval?: cdk.Duration;
    /**
     * (experimental) The ping path for health checks (if the protocol is HTTP(S)).
     *
     * @default '/'
     * @experimental
     */
    readonly healthCheckPath?: string;
    /**
     * (experimental) The port used to perform health checks.
     *
     * @default - The listener's port
     * @experimental
     */
    readonly healthCheckPort?: number;
    /**
     * (experimental) The protocol used to perform health checks.
     *
     * @default HealthCheckProtocol.TCP
     * @experimental
     */
    readonly healthCheckProtocol?: HealthCheckProtocol;
    /**
     * (experimental) The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an unhealthy endpoint to healthy.
     *
     * @default 3
     * @experimental
     */
    readonly healthCheckThreshold?: number;
    /**
     * (experimental) The percentage of traffic to send to this AWS Region.
     *
     * The percentage is applied to the traffic that would otherwise have been
     * routed to the Region based on optimal routing. Additional traffic is
     * distributed to other endpoint groups for this listener.
     *
     * @default 100
     * @experimental
     */
    readonly trafficDialPercentage?: number;
    /**
     * (experimental) Override the destination ports used to route traffic to an endpoint.
     *
     * Unless overridden, the port used to hit the endpoint will be the same as the port
     * that traffic arrives on at the listener.
     *
     * @default - No overrides
     * @experimental
     */
    readonly portOverrides?: PortOverride[];
    /**
     * (experimental) Initial list of endpoints for this group.
     *
     * @default - Group is initially empty
     * @experimental
     */
    readonly endpoints?: IEndpoint[];
}
/**
 * (experimental) Override specific listener ports used to route traffic to endpoints that are part of an endpoint group.
 *
 * @experimental
 */
export interface PortOverride {
    /**
     * (experimental) The listener port that you want to map to a specific endpoint port.
     *
     * This is the port that user traffic arrives to the Global Accelerator on.
     *
     * @experimental
     */
    readonly listenerPort: number;
    /**
     * (experimental) The endpoint port that you want a listener port to be mapped to.
     *
     * This is the port on the endpoint, such as the Application Load Balancer or Amazon EC2 instance.
     *
     * @experimental
     */
    readonly endpointPort: number;
}
/**
 * (experimental) The protocol for the connections from clients to the accelerator.
 *
 * @experimental
 */
export declare enum HealthCheckProtocol {
    /**
     * (experimental) TCP.
     *
     * @experimental
     */
    TCP = "TCP",
    /**
     * (experimental) HTTP.
     *
     * @experimental
     */
    HTTP = "HTTP",
    /**
     * (experimental) HTTPS.
     *
     * @experimental
     */
    HTTPS = "HTTPS"
}
/**
 * (experimental) Property of the EndpointGroup.
 *
 * @experimental
 */
export interface EndpointGroupProps extends EndpointGroupOptions {
    /**
     * (experimental) The Amazon Resource Name (ARN) of the listener.
     *
     * @experimental
     */
    readonly listener: IListener;
}
/**
 * (experimental) EndpointGroup construct.
 *
 * @experimental
 */
export declare class EndpointGroup extends cdk.Resource implements IEndpointGroup {
    /**
     * (experimental) import from ARN.
     *
     * @experimental
     */
    static fromEndpointGroupArn(scope: Construct, id: string, endpointGroupArn: string): IEndpointGroup;
    /**
     * (experimental) EndpointGroup ARN.
     *
     * @experimental
     */
    readonly endpointGroupArn: string;
    /**
     * (experimental) The name of the endpoint group.
     *
     * @experimental
     * @attribute true
     */
    readonly endpointGroupName: string;
    /**
     * (experimental) The array of the endpoints in this endpoint group.
     *
     * @experimental
     */
    protected readonly endpoints: IEndpoint[];
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: EndpointGroupProps);
    /**
     * (experimental) Add an endpoint.
     *
     * @experimental
     */
    addEndpoint(endpoint: IEndpoint): void;
    /**
     * (experimental) Return an object that represents the Accelerator's Security Group.
     *
     * Uses a Custom Resource to look up the Security Group that Accelerator
     * creates at deploy time. Requires your VPC ID to perform the lookup.
     *
     * The Security Group will only be created if you enable **Client IP
     * Preservation** on any of the endpoints.
     *
     * You cannot manipulate the rules inside this security group, but you can
     * use this security group as a Peer in Connections rules on other
     * constructs.
     *
     * @experimental
     */
    connectionsPeer(id: string, vpc: ec2.IVpc): ec2.IPeer;
    private renderEndpoints;
    /**
     * Return the first (readable) region of the endpoints in this group
     */
    private firstEndpointRegion;
}
