"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NetworkLoadBalancerEndpoint = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _util_1 = require("./_util");
/**
 * (experimental) Use a Network Load Balancer as a Global Accelerator Endpoint.
 *
 * @experimental
 */
class NetworkLoadBalancerEndpoint {
    /**
     * @experimental
     */
    constructor(loadBalancer, options = {}) {
        this.loadBalancer = loadBalancer;
        this.options = options;
        _util_1.validateWeight(options.weight);
        this.region = loadBalancer.env.region;
    }
    /**
     * (experimental) Render the endpoint to an endpoint configuration.
     *
     * @experimental
     */
    renderEndpointConfiguration() {
        return {
            endpointId: this.loadBalancer.loadBalancerArn,
            weight: this.options.weight,
        };
    }
}
exports.NetworkLoadBalancerEndpoint = NetworkLoadBalancerEndpoint;
_a = JSII_RTTI_SYMBOL_1;
NetworkLoadBalancerEndpoint[_a] = { fqn: "monocdk.aws_globalaccelerator_endpoints.NetworkLoadBalancerEndpoint", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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