import * as elbv2 from "../../aws-elasticloadbalancingv2";
import * as ga from "../../aws-globalaccelerator";
/**
 * (experimental) Properties for a NetworkLoadBalancerEndpoint.
 *
 * @experimental
 */
export interface NetworkLoadBalancerEndpointProps {
    /**
     * (experimental) Endpoint weight across all endpoints in the group.
     *
     * Must be a value between 0 and 255.
     *
     * @default 128
     * @experimental
     */
    readonly weight?: number;
}
/**
 * (experimental) Use a Network Load Balancer as a Global Accelerator Endpoint.
 *
 * @experimental
 */
export declare class NetworkLoadBalancerEndpoint implements ga.IEndpoint {
    private readonly loadBalancer;
    private readonly options;
    /**
     * (experimental) The region where the endpoint is located.
     *
     * If the region cannot be determined, `undefined` is returned
     *
     * @experimental
     */
    readonly region?: string;
    /**
     * @experimental
     */
    constructor(loadBalancer: elbv2.INetworkLoadBalancer, options?: NetworkLoadBalancerEndpointProps);
    /**
     * (experimental) Render the endpoint to an endpoint configuration.
     *
     * @experimental
     */
    renderEndpointConfiguration(): any;
}
