import * as ec2 from "../../aws-ec2";
import * as ga from "../../aws-globalaccelerator";
/**
 * (experimental) Properties for a NetworkLoadBalancerEndpoint.
 *
 * @experimental
 */
export interface InstanceEndpointProps {
    /**
     * (experimental) Endpoint weight across all endpoints in the group.
     *
     * Must be a value between 0 and 255.
     *
     * @default 128
     * @experimental
     */
    readonly weight?: number;
    /**
     * (experimental) Forward the client IP address.
     *
     * GlobalAccelerator will create Network Interfaces in your VPC in order
     * to preserve the client IP address.
     *
     * Client IP address preservation is supported only in specific AWS Regions.
     * See the GlobalAccelerator Developer Guide for a list.
     *
     * @default true if available
     * @experimental
     */
    readonly preserveClientIp?: boolean;
}
/**
 * (experimental) Use an EC2 Instance as a Global Accelerator Endpoint.
 *
 * @experimental
 */
export declare class InstanceEndpoint implements ga.IEndpoint {
    private readonly instance;
    private readonly options;
    /**
     * (experimental) The region where the endpoint is located.
     *
     * If the region cannot be determined, `undefined` is returned
     *
     * @experimental
     */
    readonly region?: string;
    /**
     * @experimental
     */
    constructor(instance: ec2.IInstance, options?: InstanceEndpointProps);
    /**
     * (experimental) Render the endpoint to an endpoint configuration.
     *
     * @experimental
     */
    renderEndpointConfiguration(): any;
}
