"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnEipEndpoint = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const _util_1 = require("./_util");
/**
 * (experimental) Use an EC2 Instance as a Global Accelerator Endpoint.
 *
 * @experimental
 */
class CfnEipEndpoint {
    /**
     * @experimental
     */
    constructor(eip, options = {}) {
        this.eip = eip;
        this.options = options;
        _util_1.validateWeight(options.weight);
        this.region = core_1.Stack.of(eip).region;
    }
    /**
     * (experimental) Render the endpoint to an endpoint configuration.
     *
     * @experimental
     */
    renderEndpointConfiguration() {
        return {
            endpointId: this.eip.attrAllocationId,
            weight: this.options.weight,
        };
    }
}
exports.CfnEipEndpoint = CfnEipEndpoint;
_a = JSII_RTTI_SYMBOL_1;
CfnEipEndpoint[_a] = { fqn: "monocdk.aws_globalaccelerator_endpoints.CfnEipEndpoint", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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