import * as ec2 from "../../aws-ec2";
import * as ga from "../../aws-globalaccelerator";
/**
 * (experimental) Properties for a NetworkLoadBalancerEndpoint.
 *
 * @experimental
 */
export interface CfnEipEndpointProps {
    /**
     * (experimental) Endpoint weight across all endpoints in the group.
     *
     * Must be a value between 0 and 255.
     *
     * @default 128
     * @experimental
     */
    readonly weight?: number;
}
/**
 * (experimental) Use an EC2 Instance as a Global Accelerator Endpoint.
 *
 * @experimental
 */
export declare class CfnEipEndpoint implements ga.IEndpoint {
    private readonly eip;
    private readonly options;
    /**
     * (experimental) The region where the endpoint is located.
     *
     * If the region cannot be determined, `undefined` is returned
     *
     * @experimental
     */
    readonly region?: string;
    /**
     * @experimental
     */
    constructor(eip: ec2.CfnEIP, options?: CfnEipEndpointProps);
    /**
     * (experimental) Render the endpoint to an endpoint configuration.
     *
     * @experimental
     */
    renderEndpointConfiguration(): any;
}
