"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationLoadBalancerEndpoint = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _util_1 = require("./_util");
/**
 * (experimental) Use an Application Load Balancer as a Global Accelerator Endpoint.
 *
 * @experimental
 */
class ApplicationLoadBalancerEndpoint {
    /**
     * @experimental
     */
    constructor(loadBalancer, options = {}) {
        this.loadBalancer = loadBalancer;
        this.options = options;
        _util_1.validateWeight(options.weight);
        this.region = loadBalancer.env.region;
    }
    /**
     * (experimental) Render the endpoint to an endpoint configuration.
     *
     * @experimental
     */
    renderEndpointConfiguration() {
        return {
            endpointId: this.loadBalancer.loadBalancerArn,
            weight: this.options.weight,
            clientIpPreservationEnabled: this.options.preserveClientIp,
        };
    }
}
exports.ApplicationLoadBalancerEndpoint = ApplicationLoadBalancerEndpoint;
_a = JSII_RTTI_SYMBOL_1;
ApplicationLoadBalancerEndpoint[_a] = { fqn: "monocdk.aws_globalaccelerator_endpoints.ApplicationLoadBalancerEndpoint", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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