import * as elbv2 from "../../aws-elasticloadbalancingv2";
import * as ga from "../../aws-globalaccelerator";
/**
 * (experimental) Properties for a ApplicationLoadBalancerEndpoint.
 *
 * @experimental
 */
export interface ApplicationLoadBalancerEndpointOptions {
    /**
     * (experimental) Endpoint weight across all endpoints in the group.
     *
     * Must be a value between 0 and 255.
     *
     * @default 128
     * @experimental
     */
    readonly weight?: number;
    /**
     * (experimental) Forward the client IP address in an `X-Forwarded-For` header.
     *
     * GlobalAccelerator will create Network Interfaces in your VPC in order
     * to preserve the client IP address.
     *
     * Client IP address preservation is supported only in specific AWS Regions.
     * See the GlobalAccelerator Developer Guide for a list.
     *
     * @default true if available
     * @experimental
     */
    readonly preserveClientIp?: boolean;
}
/**
 * (experimental) Use an Application Load Balancer as a Global Accelerator Endpoint.
 *
 * @experimental
 */
export declare class ApplicationLoadBalancerEndpoint implements ga.IEndpoint {
    private readonly loadBalancer;
    private readonly options;
    /**
     * (experimental) The region where the endpoint is located.
     *
     * If the region cannot be determined, `undefined` is returned
     *
     * @experimental
     */
    readonly region?: string;
    /**
     * @experimental
     */
    constructor(loadBalancer: elbv2.IApplicationLoadBalancer, options?: ApplicationLoadBalancerEndpointOptions);
    /**
     * (experimental) Render the endpoint to an endpoint configuration.
     *
     * @experimental
     */
    renderEndpointConfiguration(): any;
}
