"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateWeight = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
function validateWeight(x) {
    if (x !== undefined && !core_1.Token.isUnresolved(x) && (x < 0 || x > 255)) {
        throw new Error(`'weight' must be between 0 and 255, got: ${x}`);
    }
}
exports.validateWeight = validateWeight;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiX3V0aWwuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJfdXRpbC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxxQ0FBbUMsQ0FBQyxnREFBZ0Q7QUFDcEYsU0FBZ0IsY0FBYyxDQUFDLENBQVU7SUFDckMsSUFBSSxDQUFDLEtBQUssU0FBUyxJQUFJLENBQUMsWUFBSyxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxHQUFHLEdBQUcsQ0FBQyxFQUFFO1FBQ2pFLE1BQU0sSUFBSSxLQUFLLENBQUMsNENBQTRDLENBQUMsRUFBRSxDQUFDLENBQUM7S0FDcEU7QUFDTCxDQUFDO0FBSkQsd0NBSUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBUb2tlbiB9IGZyb20gXCIuLi8uLi9jb3JlXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9jb3JlJ1xuZXhwb3J0IGZ1bmN0aW9uIHZhbGlkYXRlV2VpZ2h0KHg/OiBudW1iZXIpIHtcbiAgICBpZiAoeCAhPT0gdW5kZWZpbmVkICYmICFUb2tlbi5pc1VucmVzb2x2ZWQoeCkgJiYgKHggPCAwIHx8IHggPiAyNTUpKSB7XG4gICAgICAgIHRocm93IG5ldyBFcnJvcihgJ3dlaWdodCcgbXVzdCBiZSBiZXR3ZWVuIDAgYW5kIDI1NSwgZ290OiAke3h9YCk7XG4gICAgfVxufVxuIl19