"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LustreMaintenanceTime = exports.Weekday = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * (experimental) Enum for representing all the days of the week.
 *
 * @experimental
 */
var Weekday;
(function (Weekday) {
    Weekday["MONDAY"] = "1";
    Weekday["TUESDAY"] = "2";
    Weekday["WEDNESDAY"] = "3";
    Weekday["THURSDAY"] = "4";
    Weekday["FRIDAY"] = "5";
    Weekday["SATURDAY"] = "6";
    Weekday["SUNDAY"] = "7";
})(Weekday = exports.Weekday || (exports.Weekday = {}));
/**
 * (experimental) Class for scheduling a weekly manitenance time.
 *
 * @experimental
 */
class LustreMaintenanceTime {
    /**
     * @experimental
     */
    constructor(props) {
        this.validate(props.hour, props.minute);
        this.day = props.day;
        this.hour = this.getTwoDigitString(props.hour);
        this.minute = this.getTwoDigitString(props.minute);
    }
    /**
     * (experimental) Converts a day, hour, and minute into a timestamp as used by FSx for Lustre's weeklyMaintenanceStartTime field.
     *
     * @experimental
     */
    toTimestamp() {
        return `${this.day.valueOf()}:${this.hour}:${this.minute}`;
    }
    /**
     * Pad an integer so that it always contains at least 2 digits. Assumes the number is a positive integer.
     */
    getTwoDigitString(n) {
        const numberString = n.toString();
        if (numberString.length === 1) {
            return `0${n}`;
        }
        return numberString;
    }
    /**
     * Validation needed for the values of the maintenance time.
     */
    validate(hour, minute) {
        if (!Number.isInteger(hour) || hour < 0 || hour > 24) {
            throw new Error('Maintenance time hour must be an integer between 0 and 24');
        }
        if (!Number.isInteger(minute) || minute < 0 || minute > 59) {
            throw new Error('Maintenance time minute must be an integer between 0 and 59');
        }
    }
}
exports.LustreMaintenanceTime = LustreMaintenanceTime;
_a = JSII_RTTI_SYMBOL_1;
LustreMaintenanceTime[_a] = { fqn: "monocdk.aws_fsx.LustreMaintenanceTime", version: "1.106.1" };
//# sourceMappingURL=data:application/json;base64,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