/**
 * (experimental) Enum for representing all the days of the week.
 *
 * @experimental
 */
export declare enum Weekday {
    /**
     * (experimental) Monday.
     *
     * @experimental
     */
    MONDAY = "1",
    /**
     * (experimental) Tuesday.
     *
     * @experimental
     */
    TUESDAY = "2",
    /**
     * (experimental) Wednesday.
     *
     * @experimental
     */
    WEDNESDAY = "3",
    /**
     * (experimental) Thursday.
     *
     * @experimental
     */
    THURSDAY = "4",
    /**
     * (experimental) Friday.
     *
     * @experimental
     */
    FRIDAY = "5",
    /**
     * (experimental) Saturday.
     *
     * @experimental
     */
    SATURDAY = "6",
    /**
     * (experimental) Sunday.
     *
     * @experimental
     */
    SUNDAY = "7"
}
/**
 * (experimental) Properties required for setting up a weekly maintenance time.
 *
 * @experimental
 */
export interface LustreMaintenanceTimeProps {
    /**
     * (experimental) The day of the week for maintenance to be performed.
     *
     * @experimental
     */
    readonly day: Weekday;
    /**
     * (experimental) The hour of the day (from 0-24) for maintenance to be performed.
     *
     * @experimental
     */
    readonly hour: number;
    /**
     * (experimental) The minute of the hour (from 0-59) for maintenance to be performed.
     *
     * @experimental
     */
    readonly minute: number;
}
/**
 * (experimental) Class for scheduling a weekly manitenance time.
 *
 * @experimental
 */
export declare class LustreMaintenanceTime {
    /**
     * The day of the week for maintenance to be performed.
     */
    private readonly day;
    /**
     * The hour of the day (from 00-24) for maintenance to be performed.
     */
    private readonly hour;
    /**
     * The minute of the hour (from 00-59) for maintenance to be performed.
     */
    private readonly minute;
    /**
     * @experimental
     */
    constructor(props: LustreMaintenanceTimeProps);
    /**
     * (experimental) Converts a day, hour, and minute into a timestamp as used by FSx for Lustre's weeklyMaintenanceStartTime field.
     *
     * @experimental
     */
    toTimestamp(): string;
    /**
     * Pad an integer so that it always contains at least 2 digits. Assumes the number is a positive integer.
     */
    private getTwoDigitString;
    /**
     * Validation needed for the values of the maintenance time.
     */
    private validate;
}
